program Context;
Uses
  DOS,bibstrg;
const
  lbrace = #123; rbrace = #125;
  pre = 'hc_';
  Width = 20;
var
  tex,pas,h: text;
  line,key,tmp: string;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
  counter: word;
  i,j,nbr: integer;
begin
  fsplit(fexpand(ParamStr(1)),Dir,Name,Ext);
  assign(tex,Dir+Name+'.tex');
  write('Extracting from "'+Name+'.TEX" to "');
  fsplit(fexpand(paramStr(2)),Dir,Name,Ext);
  writeln(Name+'.PAS" and "'+Name+'.H"...');
{  writeln(fexpand(ParamStr(2)));}
  assign(pas,Dir+Name+'.pas');
  assign(h,Dir+Name+'.h');
  reset(tex);
  rewrite(pas); rewrite(h);
  writeln(pas,'Unit '+Name+';');
  writeln(pas); writeln(pas,'Interface'); writeln(pas);
  writeln(pas,'Const');
  counter:=0;
  repeat
    readln(tex,line);
    ChrDelL(line,' '); ChrDelR(line,' ');
    i:=Pos('\label'+lbrace,line);
    if i>0 then
    begin
      j:=Pos('\chapter',line);
      if j=0 then j:=Pos('\section',line);
      if j=0 then j:=Pos('\subsection',line);
      if j=0 then j:=Pos('\subsubsection',line);
      if j>0 then
      begin
        delete(line,1,j);
        j:=Pos(lbrace,line); delete(line,1,j);
        nbr:=1;
        j:=0;
        while (j<length(line)) and (nbr>0) do
        begin
          inc(j);
          if line[j]=lbrace then inc(nbr)
          else if line[j]=rbrace then dec(nbr);
        end;
        key:=Copy(line,1,j-1); Delete(line,1,j);
        i:=Pos('\label'+lbrace,line);
        delete(line,1,i+6);
        i:=pos(rbrace,line); if i>0 then line[0]:=Chr(i-1);
        for i:=length(line) to Width do line:=line+' ';
        if line<>'' then
        begin
          inc(counter);
          Str(counter,tmp);
          for j:=length(tmp)+1 to 6 do tmp:=tmp+' ';
          writeln(h,'#define ',line,' ',tmp,' /* Keyword: "',key,'" */');
          Str(counter,tmp); tmp:=tmp+';';
          for j:=length(tmp)+1 to 6 do tmp:=tmp+' ';
          writeln(pas,'  ',pre,line,' = ',tmp,' '+lbrace+' Keyword: "',key,
                  '" '+rbrace);
        end;
      end;
    end;
  until eof(tex);
  writeln(pas); writeln(pas,'Implementation');
  writeln(pas); writeln(pas,'End.');
  close(tex); close(pas); close(h);
end.
