/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     October 1999
 *
 */

#include  <gtk/gtk.h>

#include  "xbibfile.h"



/* input text fields and labels used BibTeX format windows handled in
 * this file */

GtkWidget  *label30, *data30;
GtkWidget  *label31, *data31;
GtkWidget  *label32, *data32;

/* Procedure to cancel the linking window and remove links */

void cancel_linking(GtkWidget *widget)
{
  extern int length[];
  extern close_window();

  length[30] = 0;
  length[31] = 0;
  length[32] = 0;
  close_window(widget);
}



/* Procedure to take data from the linking window */

void save_linking(GtkWidget *widget)
{
  extern  void close_window();   /* defined in file cleanup.c */
  extern  int  length[];
  extern  char slate30[];
  extern  char slate31[];
  extern  char slate32[];

  strcpy(slate30, gtk_entry_get_text(GTK_ENTRY(data30)));
  length[30] = strlen(slate30);
  strcpy(slate31, gtk_entry_get_text(GTK_ENTRY(data31)));
  length[31] = strlen(slate31);
  strcpy(slate32, gtk_entry_get_text(GTK_ENTRY(data32)));
  length[32] = strlen(slate32);
  close_window(widget);
}
  

/* Procedure to put window on screen for the common linking process */

void  linkwindow(widget)
{
  GtkTooltips *tooltips;
  GtkWidget  *window;
  GtkWidget  *decoration;
  GtkWidget  *totalPane;
  GtkWidget  *field0;
  GtkWidget  *key0;
  GtkWidget  *key1;
  GtkWidget  *field1;
  GtkWidget  *field2;
  GtkWidget  *field3;
  extern int format;

  if (format == 0) {
    error (widget, GINT_TO_POINTER(6));
    return;
  }

                    /* create the tooltip help feature */

  tooltips = gtk_tooltips_new();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile create");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize(GTK_WIDGET(window), 400, 170);
  decoration = gtk_frame_new("Linking Labels");
  gtk_container_add(GTK_CONTAINER(window), decoration);
  totalPane = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(decoration), totalPane);

  field1 = gtk_hbox_new(FALSE, 0);
  label30 = gtk_label_new("Up link:");
  gtk_widget_set_usize(GTK_WIDGET(label30), 60, -1);
  gtk_box_pack_start(GTK_BOX(field1), label30, FALSE, FALSE, 10);
  data30 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data30), 300, -1);
  gtk_box_pack_start(GTK_BOX(field1), data30, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field1, FALSE, TRUE, 10);

  field2 = gtk_hbox_new(FALSE, 0);
  label31 = gtk_label_new("Cross link:");
  gtk_widget_set_usize(GTK_WIDGET(label31), 60, -1);
  gtk_box_pack_start(GTK_BOX(field2), label31, FALSE, FALSE, 10);
  data31 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data31), 300, -1);
  gtk_box_pack_start(GTK_BOX(field2), data31, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field2, FALSE, TRUE, 0);

  field3 = gtk_hbox_new(FALSE, 0);
  label32 = gtk_label_new("Externals:");
  gtk_widget_set_usize(GTK_WIDGET(label32), 60, -1);
  gtk_box_pack_start(GTK_BOX(field3), label32, FALSE, FALSE, 10);
  data32 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data32), 300, -1);
  gtk_box_pack_start(GTK_BOX(field3), data32, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field3, FALSE, TRUE, 10);

                         /* finally, put the cancel and save buttons
                          * in the window */
  field0 = gtk_hbox_new(FALSE, 0);
  key0 = gtk_button_new_with_label("CANCEL");
  gtk_widget_set_usize(GTK_WIDGET(key0), 90, -1);
  g_signal_connect(GTK_OBJECT(key0), "clicked",
                   G_CALLBACK(cancel_linking), NULL);
  gtk_tooltips_set_tip(tooltips, key0,
                       "Discard the contents of this window", NULL);
  gtk_box_pack_end(GTK_BOX(field0), key0, FALSE, FALSE, 10);
  key1 = gtk_button_new_with_label("Save");
  gtk_widget_set_usize(GTK_WIDGET(key1), 90, -1);
  g_signal_connect(GTK_OBJECT(key1), "clicked",
                   G_CALLBACK(save_linking), NULL);
  gtk_tooltips_set_tip(tooltips, key1,
                       "Store the contents of this window", NULL);
  gtk_box_pack_end(GTK_BOX(field0), key1, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field0, FALSE, TRUE, 0);

                         /* make the composite window visible on the screen */
  gtk_widget_show_all(window);
}


