%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% This is the file zsty.mk, part of the MathKit package
%% (version 0.7, January , 1998) for math font 
%% generation.  (Author: Alan Hoenig, ajhjj@cunyvm.cuny.edu)
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\ProvidesPackage{z<mock><fam>}

\renewcommand{\rmdefault}{<famx>}
\renewcommand{\encodingdefault}{OT1}
\renewcommand{\bfdefault}{<nfssb>}

\DeclareFontFamily{OMX}{<mock><fam>}{}
  \DeclareFontShape{OMX}{<mock><fam>}{m}{n}{<-> <mock>ex10}{}
\DeclareFontFamily{OMS}{<mock><fam>}{\skewchar\font=48}
  \DeclareFontShape{OMS}{<mock><fam>}{m}{n}{ 
    <12>  <mock>sy10 
    <10>  <mock>sy10 
    <9>   <mock>sy9 
    <8>   <mock>sy8
    <7>   <mock>sy7 
    <6>   <mock>sy6 
    <5>   <mock>sy5 
  }{}

\SetSymbolFont{operators}{normal}{OT1}{<mock><fam>}{m}{n}
\SetSymbolFont{letters}{normal}{OML}{<mock><fam>}{m}{it}
\SetSymbolFont{symbols}{normal}{OMS}{<mock><fam>}{m}{n}
\SetSymbolFont{largesymbols}{normal}{OMX}{<mock><fam>}{m}{n}

\SetMathAlphabet{\mathit}{normal}{OT1}{\rmdefault}{m}{it}
\SetMathAlphabet{\mathbf}{normal}{OT1}{<mock><fam>}{\bfdefault}{n}


%% Math Calligraphic.
\DeclareFontFamily{OT1}{cal}{}
\DeclareFontShape{OT1}{cal}{m}{it}{<-> <mock>sy10}{}
\newcommand{\caldefault}{cal}
\SetMathAlphabet{\mathcal}{normal}{OT1}{\caldefault}{m}{it}

[fr]%% Math Fraktur.
[fr]\DeclareFontFamily{OT1}{frak}{}
[fr]\DeclareFontShape{OT1}{frak}{m}{n}{<-> [<frsf>] eufm10}{}
[fr]\newcommand{\frakdefault}{frak}
[fr]\DeclareMathAlphabet{\mathfr}{OT1}{\frakdefault}{m}{n}

[bb]%% Math Blackboard Bold.
[bb]\DeclareFontFamily{OT1}{bbold}{}
[bb]\DeclareFontShape{OT1}{bbold}{m}{n}{<-> <mock>bb10}{}
[bb]\newcommand{\bbdefault}{bbold}
[bb]\DeclareMathAlphabet{\mathbb}{OT1}{\bbdefault}{m}{n}

[b]\DeclareMathVersion{boldmath}
[b]  \DeclareFontShape{OMX}{<mock><fam>}{<bseries>}{n}{<-> <mock>bex10}{}
[b]  \DeclareFontShape{OMS}{<mock><fam>}{<bseries>}{n}{ 
[b]    <12>  <mock>bsy12
[b]    <10>  <mock>bsy10 
[b]    <9>   <mock>bsy9 
[b]    <8>   <mock>bsy8
[b]    <7>   <mock>bsy7 
[b]    <6>   <mock>bsy6 
[b]    <5>   <mock>bsy5 
[b]  }{}
[b]
[b]\SetSymbolFont{operators}{boldmath}{OT1}{<mock><fam>}{<bseries>}{n}
[b]\SetSymbolFont{letters}{boldmath}{OML}{<mock><fam>}{<bseries>}{it}
[b]\SetSymbolFont{symbols}{boldmath}{OMS}{<mock><fam>}{<bseries>}{n}
[b]\SetSymbolFont{largesymbols}{boldmath}{OMX}{<mock><fam>}{<bseries>}{n}
[b]\SetMathAlphabet{\mathcal}{boldmath}{OMS}{<mock><fam>}{<bseries>}{n}
[b]
[b]\newenvironment{boldface}{\bgroup\mathversion{boldmath}%
[b]  \def\it{\fontseries{<bseries>}\fontshape{it}\selectfont}%
[b]  \fontseries{<bseries>}\selectfont }{\egroup}
