@echo off
rem File: psfont.bat
rem Author: Phons Bloemen (4allTeX)
rem Purpose: generate TFM STY VF FD from one AFM file

set name=afm2tfm
if not exist %EMTEXDIR%\bin\afm2tfm.exe goto errorc
set name=ps2pk
if not exist %EMTEXDIR%\bin\ps2pk.exe goto errorc
set name=vptovf
if not exist %EMTEXDIR%\bin\vptovf.exe goto errorc
set name=vpltovpl
if not exist %EMTEXDIR%\bin\vpltovpl.exe goto errorc
set name=ec.enc
if not exist ec.enc goto errorc

:interact
echo PSFONT.BAT ps font installer (PhB)
echo ---------------------------------------
set NAME=%2
set AFM=%1
if not "%2"=="" goto entered
rem Test for 4dos
if "%@eval[1+1]" == "2" goto dosok
if "%1"=="" goto errora
goto testfont
:dosok
echo The font name is the name of the afm file on disk,
echo without a trailing 0 (which indicates Adobe encoding).
echo A Postscript font family consists of
echo xxxr.afm xxxb.afm xxxri.afm xxxbi.afm
echo Of these, the 'italic' versions may be unavailable
echo Small caps and a slanted version will be derived!
echo The family name is the 'xxx'.
echo A Postscript Berry font name consists of F TT W V W
echo (Foundry Typeface Weight Variant/Encoding Width )
echo Small caps and a slanted version will be derived!
echo.
input What font name (7 chars max) : %%AFM%
input What stylefile name to use : %%NAME%
:entered
echo How to install %AFM% (%NAME%) ?
echo A: Postscript family
echo B: Special Postscript symbol font
echo C: Test out a PS font (show fonttable)
ask Your choice ,abcde
echo.
if errorlevel 3 goto testfont
if errorlevel 2 goto specfont
if errorlevel 1 goto bigfam
goto end

:testfont
set AFROMAN=%AFM%
echo Checking %AFROMAN%.afm
if exist %AFROMAN%.afm goto mfound
set AFROMAN=%AFM%0
if exist %AFROMAN%.afm goto mfound
set AFROMAN=%AFM%r0
if exist %AFROMAN%.afm goto mfound
goto errorb
:mfound
afm2tfm %AFROMAN%.afm %AFROMAN%.tfm >%AFM%.map
echo Generating %AFROMAN%.tex
echo %%%% Filename: %AFROMAN%.tex (4allTeX postscript font setup) >%AFROMAN%.TEX
echo %%%% Created using fontbat %AFROMAN% (PhB)       >>%AFROMAN%.TEX
echo %%%% Based on PSNFSS 2.4.1 and 3 by S. Rahtz      >>%AFROMAN%.TEX
echo %%%% Can be processed by both PSNFSS1 and LaTeX2e >>%AFROMAN%.TEX
echo %%%% File created to test font %NAME%.    >>%AFROMAN%.TEX
echo %%%% This file may be deleted.           >>%AFROMAN%.TEX
echo \def\stylename{%AFROMAN%}                >>%AFROMAN%.TEX
echo \font\testfont=%AFROMAN%                 >>%AFROMAN%.TEX
echo \def\fonttotest{\testfont}               >>%AFROMAN%.TEX
echo \input{tabtest.tex}                      >>%AFROMAN%.tex
echo \endinput >>%AFROMAN%.tex
ps2pk -X300 -Y300 -P10 -a%AFROMAN%.afm %AFROMAN%.pfb %AFROMAN%.pk
call latex %AFROMAN%
call v %AFROMAN%
del %AFROMAN%.pk > nul
del %AFROMAN%.tfm >nul
del %AFROMAN%.log >nul
del %AFROMAN%.dvi >nul
del %AFROMAN%.aux >nul
goto end

:mffam
echo This is not yet available
goto end


:specfont
echo What kind of font is this (%NAME%) %AFM%?
echo S: symbol font (postscript symbols)
echo M: math font (TeX cmmi)
echo Y: math symbol font (TeX cmsy)
echo V: math extension font (TeX cmex)
echo U: unknown encoding
ask Your choice ,osmyvuq
echo.
SET FT=
if errorlevel 6 goto checking
SET FT=u
if errorlevel 5 goto checking
SET FT=v
if errorlevel 4 goto checking
SET FT=y
if errorlevel 3 goto checking
SET FT=m
if errorlevel 2 goto checking
SET FT=s
if errorlevel 1 goto checking
:checking
set AFROMAN=%AFM%
set ENC=
if "%FT%"=="m" set ENC=OML
if "%FT%"=="y" set ENC=OMS
if "%FT%"=="v" set ENC=OMX
if "%FT%"=="s" set ENC=U
if "%FT%"=="u" set ENC=U
if "%ENC%"=="" goto errorb
if "%FT%"=="" goto errora
echo Checking %AFM%.afm
if not exist %AFM%.afm goto errorb
afm2tfm %2.afm %2.tfm >%2.map
call fontbat2 %NAME% %AFM% %ENC%

goto installat

:bigfam
echo What kind of font is this (%NAME%) %AFM%?
echo R: roman (serif) font (sets \rmdefault)
echo S: sansserif font (sets \sfdefault)
echo T: typewriter (non-proportional) font (sets \ttdefault)
ask Your choice : ,rst
echo.
SET FT=t
if errorlevel 3 goto littfamok
SET FT=s
if errorlevel 2 goto littfamok
SET FT=r
:littfamok
set AFROMAN=%AFM%r
echo Checking %AFROMAN%.afm
if not exist %AFROMAN%.afm goto errorb
set AFBOLD=%AFM%b
echo Checking %AFBOLD%.afm
if exist %AFBOLD%.afm goto allfam
set AFBOLD=%AFROMAN%
rem :errorlit
rem set AFROMAN=%AFM%
rem set AFBOLD=%AFM%
rem echo Checking %AFROMAN%.afm
rem if not exist %AFROMAN%.afm goto errorb
:allfam
set ENC=T1
echo %%%% ===================================================== >%AFM%.FTI
echo %%%% 4allTeX fontinst file (PhB)                           >>%AFM%.FTI
echo %%%% Use phbfonti.sty instead of fontinst.sty              >>%AFM%.FTI
echo %%%% ===================================================== >>%AFM%.FTI
echo %%%% Installation file for fontinst. Feed this file to     >>%AFM%.FTI
echo %%%% plain TeX (emTeX: add -ms 6000 to increase save size) >>%AFM%.FTI
echo %%%% Output: .pl files: run pltotf on them                 >>%AFM%.FTI
echo %%%%         .vpl files: run vptovf on them                >>%AFM%.FTI
echo %%%%         .sty file: for 209/NFSS1 and 2e.              >>%AFM%.FTI
echo %%%%         .fd files: for LaTeX2e font selection.        >>%AFM%.FTI
echo %%%% Move .tfm to \emtex\tfm.                              >>%AFM%.FTI
echo %%%% Move .sty to \emtex\texinput\nfss                     >>%AFM%.FTI
echo %%%% Move .fd  to \emtex\latex2e\nfss                      >>%AFM%.FTI
echo %%%% Nuke .pl, .mtx and .vpl files afterwards.             >>%AFM%.FTI
echo %%%% ===================================================== >>%AFM%.FTI
echo \nonstopmode                                               >>%AFM%.FTI
echo \input phbfonti.sty                                       >>%AFM%.FTI
echo \installgenericstyle{%NAME%}{%AFM%}{}{}{%FT%}{}{    >>%AFM%.FTI
if not "%AFROMAN%"=="%AFM%" goto famfont
echo \install_latin_series{}{}{m}{r} >>%AFM%.FTI
goto onefont
:famfont
echo \install_latin_series{r}{}{m}{r} >>%AFM%.FTI
echo \install_latin_series{b}{}{b}{b} >>%AFM%.FTI
:onefont
echo }\bye                                               >>%AFM%.FTI
echo How to create the font (%NAME%) %AFM%?
echo F: fontinst (slow and neat)
echo A: afm2tfm (quick and dirty)
ask Your choice : ,fa
echo.
if errorlevel 2 goto qandd
call fontinst %AFM%
echo Generating all TFM files
for %%i in (%AFM%*.pl) do pltotf %%i >nul
del %AFM%*.pl > nul
goto installat
:qandd
set AFCAPS=%AFROMAN%c
set AFSLANT=%AFROMAN%o
set AFBITAL=%AFBOLD%o
set AFBSLANT=%AFBOLD%o
set AFITAL=%AFSLANT%
echo Using %AFROMAN% %AFITAL% %AFBOLD% %AFBITAL% %AFCAPS% %AFSLANT%
echo %% %AFM% (%NAME%.sty). Append to PSFONTS.MAP >%AFM%.MAP
echo %% Adjust these lines if the fonts are resident! >>%AFM%.MAP
echo Installing Normal (%AFROMAN%)
afm2tfm %AFROMAN%.afm -v %AFROMAN%.vpl %AFROMAN%0.tfm >>%AFM%.map
afm2tfm %AFROMAN%.afm -t ec.enc -v %AFROMAN%q.vpl %AFROMAN%0.tfm >>%AFM%.MAP
vpltovpl %AFROMAN%q.vpl %AFROMAN%.afm >nul
echo Installing Slant (%AFSLANT%)
afm2tfm %AFROMAN%.afm -t ec.enc -s 0.167 -v %AFSLANT%q.vpl %AFSLANT%0.tfm >>%AFM%.MAP
afm2tfm %AFROMAN%.afm -s 0.167 -v %AFSLANT%.vpl %AFSLANT%0.tfm >>%AFM%.map
vpltovpl %AFSLANT%q.vpl %AFROMAN%.afm >nul
echo Installing SmallCaps (%AFCAPS%)
afm2tfm %AFROMAN%.afm -V %AFCAPS.vpl %AFROMAN%0.tfm >>%AFM%.map
afm2tfm %AFROMAN%.afm -t ec.enc -V %AFCAPS%q.vpl %AFROMAN%0.tfm >>%AFM%.MAP
vpltovpl %AFCAPS%q.vpl %AFROMAN%.afm >nul
set AFITAL=%AFROMAN%o
if not exist %AFROMAN%i.afm goto noitalics
set AFITAL=%AFROMAN%i
echo Installing Italic (%AFITAL%)
afm2tfm %AFITAL%.afm -v %AFITAL.vpl %AFITAL%0.tfm >>%AFM%.map
afm2tfm %AFITAL%.afm -t ec.enc -v %AFITAL%q.vpl %AFITAL%0.tfm >>%AFM%.MAP
vpltovpl %AFITAL%q.vpl %AFITAL%.afm >nul
:noitalics
if "%AFBOLD%"=="%AFROMAN%" goto nobitalics
echo Installing Bold (%AFBOLD%)
afm2tfm %AFBOLD%.afm -v %AFBOLD.vpl %AFBOLD%0.tfm >>%AFM%.map
afm2tfm %AFBOLD%.afm -t ec.enc -v %AFBOLD%q.vpl %AFBOLD%0.tfm >>%AFM%.MAP
vpltovpl %AFBOLD%q.vpl %AFBOLD%.afm >nul
echo Installing BoldSlant (%AFBSLANT%)
afm2tfm %AFBOLD%.afm -s 0.167 -v %AFBSLANT%.vpl %AFBSLANT%0.tfm >>%AFM%.map
afm2tfm %AFBOLD%.afm -t ec.enc -s 0.167 -v %AFBSLANT%q.vpl %AFSLANT%0.tfm >>%AFM%.MAP
vpltovpl %AFBSLANT%q.vpl %AFBOLD%.afm >nul
set AFBITAL=%AFBOLD%o
if not exist %AFBOLD%i.afm goto nobitalics
set AFBITAL=%AFBOLD%i
echo Installing BoldItalic (%AFBITAL%)
afm2tfm %AFBITAL%.afm -v %AFBITAL.vpl %AFBITAL%0.tfm >>%AFM%.map
afm2tfm %AFBITAL%.afm -t ec.enc -v %AFBITAL%q.vpl %AFBITAL%0.tfm >>%AFM%.MAP
vpltovpl %AFBITAL%q.vpl %AFBITAL%.afm >nul
:nobitalics
call fontbat5 %NAME% %AFM% %FT% %AFROMAN% %AFITAL% %AFBOLD% %AFBITAL% %AFCAPS% %AFSLANT%
call fontbat4 %AFM% T1 %AFROMAN% %AFITAL% %AFBOLD% %AFBITAL% %AFCAPS% %AFSLANT% q
call fontbat4 %AFM% OT1 %AFROMAN% %AFITAL% %AFBOLD% %AFBITAL% %AFCAPS% %AFSLANT%

:installat
echo Generating all VF files
for %%i in (*.vpl) do vptovf %%i >nul
del *.vpl > nul
:novpl
ask Install generated files in EMTEX directory tree ?,yn
if errorlevel 2 goto end
echo.
copy %AFM%*.vf %EMTEXDIR%\texfonts\vf >nul
del %AFM%*.vf >nul
copy %AFM%*.tfm %EMTEXDIR%\tfm >nul
del %AFM%*.tfm >nul
if exist %ENC%%AFM%.fd copy %ENC%%AFM%.fd %EMTEXDIR%\texinput\latex2e\psnfss >nul
if exist %ENC%%2.fd del %ENC%%AFM%.fd >nul
if exist OT1%2.fd copy OT1%AFM%.fd %EMTEXDIR%\texinput\latex2e\psnfss >nul
if exist OT1%2.fd del OT1%AFM%.fd >nul
copy %NAME%.sty %EMTEXDIR%\texinput\latex2e\psnfss >nul
del %NAME%.sty >nul
echo Font family %AFM% installed. Use package %NAME%.sty
ask Append %AFM%.MAP to %EMTEXDIR%\ps\psfonts.map ?,yn
if errorlevel 2 goto end
echo.
type %AFM%.MAP >> %EMTEXDIR%\ps\psfonts.map
echo Edit %EMTEXDIR%\ps\psfonts.map if font is non-resident!
goto end

:errora
echo Usage: fontbat $1 $2
echo Args :1: name of afm file (or Berry family name)
echo       2: name of stylefile to use (without .sty)
echo Example: fontbat ptm times
goto end
:errorc
echo Missing program or file: %NAME%
echo They are on 4allTeX disk 8.
echo.
:errorb
echo Missing font: %AFM%*.afm
:end
echo.

