/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class TexlipseAnnotationUpdater
implements ISelectionChangedListener {
    private final List<Annotation> fOldAnnotations = new LinkedList<Annotation>();
    private AbstractTextEditor fEditor;
    private Job fUpdateJob;
    private static final String ANNOTATION_TYPE = "net.sourceforge.texlipse.defAnnotation";
    private boolean fEnabled;

    public TexlipseAnnotationUpdater(AbstractTextEditor editor) {
        ((IPostSelectionProvider)editor.getSelectionProvider()).addPostSelectionChangedListener((ISelectionChangedListener)this);
        this.fEditor = editor;
        this.fEnabled = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("textEditorAnnotations");
        TexlipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("textEditorAnnotations".equals(property)) {
                    boolean enabled = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("textEditorAnnotations");
                    TexlipseAnnotationUpdater.this.fEnabled = enabled;
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update((ISourceViewer)event.getSource());
    }

    private void update(ISourceViewer viewer) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        if (this.testSelection(selection, model)) {
            return;
        }
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        this.removeOldAnnotations(model);
        if (!this.fEnabled) {
            return;
        }
        if (selection instanceof ITextSelection) {
            try {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                int lineNr = document.getLineOfOffset(offset);
                int lineOff = document.getLineOffset(lineNr);
                String line = document.get(lineOff, document.getLineLength(lineNr));
                IRegion r = LatexParserUtils.getCommand(line, offset - lineOff);
                if (r == null) {
                    return;
                }
                String command = line.substring(r.getOffset(), r.getOffset() + r.getLength()).trim();
                if ("\\begin".equals(command) || "\\end".equals(command)) {
                    IRegion r2 = LatexParserUtils.getCommandArgument(line, r.getOffset());
                    if (r2 == null) {
                        return;
                    }
                    Region startRegion = new Region(lineOff + r.getOffset(), r2.getOffset() + r2.getLength() - r.getOffset() + 1);
                    String refName = line.substring(r2.getOffset(), r2.getOffset() + r2.getLength());
                    this.fUpdateJob = this.createMatchEnvironmentJob(document, model, offset, command, (IRegion)startRegion, refName);
                    this.fUpdateJob.setPriority(50);
                    this.fUpdateJob.setSystem(true);
                    this.fUpdateJob.schedule();
                } else if (command.endsWith("ref") || "\\label".equals(command)) {
                    IRegion r2 = LatexParserUtils.getCommandArgument(line, r.getOffset());
                    if (r2 == null) {
                        return;
                    }
                    String refName = line.substring(r2.getOffset(), r2.getOffset() + r2.getLength());
                    this.fUpdateJob = this.createMatchReferenceJob(document, model, refName);
                    this.fUpdateJob.setPriority(50);
                    this.fUpdateJob.setSystem(true);
                    this.fUpdateJob.schedule();
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private Job createMatchReferenceJob(final IDocument document, final IAnnotationModel model, final String refName) {
        return new Job("Update Annotations"){

            public IStatus run(IProgressMonitor monitor) {
                String text = document.get();
                String refNameRegExp = refName.replaceAll("\\*", "\\\\*");
                String simpleRefRegExp = "\\\\([a-zA-Z]*ref|label)\\s*\\{" + refNameRegExp + "\\}";
                Matcher m = Pattern.compile(simpleRefRegExp).matcher(text);
                while (m.find()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    IRegion match = LatexParserUtils.getCommand(text, m.start());
                    if (match == null) continue;
                    Region fi = new Region(m.start(), m.end() - m.start());
                    TexlipseAnnotationUpdater.this.createNewAnnotation((IRegion)fi, "References", model);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private Job createMatchEnvironmentJob(final IDocument document, final IAnnotationModel model, int offset, final String command, final IRegion startRegion, final String envName) {
        return new Job("Update Annotations"){

            public IStatus run(IProgressMonitor monitor) {
                String text = document.get();
                boolean forward = false;
                if ("\\begin".equals(command)) {
                    forward = true;
                }
                if (forward) {
                    IRegion endRegion = LatexParserUtils.findMatchingEndEnvironment(text, envName, startRegion.getOffset());
                    if (endRegion != null) {
                        TexlipseAnnotationUpdater.this.createNewAnnotation(endRegion, "Environment", model);
                        TexlipseAnnotationUpdater.this.createNewAnnotation(startRegion, "Environment", model);
                    }
                } else {
                    IRegion endRegion = LatexParserUtils.findMatchingBeginEnvironment(text, envName, startRegion.getOffset());
                    if (endRegion != null) {
                        TexlipseAnnotationUpdater.this.createNewAnnotation(endRegion, "Environment", model);
                        TexlipseAnnotationUpdater.this.createNewAnnotation(startRegion, "Environment", model);
                    }
                }
                return Status.OK_STATUS;
            }
        };
    }

    private boolean testSelection(ISelection selection, IAnnotationModel model) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            for (Annotation anno : this.fOldAnnotations) {
                Position p = model.getPosition(anno);
                if (p == null || p.offset > textSelection.getOffset() || p.offset + p.length < textSelection.getOffset()) continue;
                return true;
            }
        }
        return false;
    }

    private void removeOldAnnotations(IAnnotationModel model) {
        for (Annotation annotation : this.fOldAnnotations) {
            model.removeAnnotation(annotation);
        }
        this.fOldAnnotations.clear();
    }

    private void createNewAnnotation(IRegion r, String annString, IAnnotationModel model) {
        Annotation annotation = new Annotation(ANNOTATION_TYPE, false, annString);
        Position position = new Position(r.getOffset(), r.getLength());
        model.addAnnotation(annotation, position);
        this.fOldAnnotations.add(annotation);
    }
}

