/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.texlipse.PathUtils;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class KeyValueListFieldEditor
extends FieldEditor
implements IInputValidator {
    public static final String SEPARATOR = ",";
    private static final String INVALID_CHARS = " ,=*()[]{}<>|\\?+/&#%$\u00c2\u00a4\u00c2\u00a3#@\"!\u00c2\u00a7\u00c2\u00bd";
    private static final String ENV_TABLE_KEY = "key";
    private static final String ENV_TABLE_VALUE = "value";
    private Composite table;
    private TableViewer environmentTable;
    private Button envAddButton;
    private Button envRemoveButton;
    private Button envEditButton;
    private Button envImportButton;
    private Map environment = new HashMap();

    public KeyValueListFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public String isValid(String newText) {
        boolean error = false;
        int i = 0;
        while (i < newText.length()) {
            if (INVALID_CHARS.indexOf(newText.charAt(i)) >= 0) {
                error = true;
                break;
            }
            ++i;
        }
        return error ? "invalid character" : null;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.table = this.createTable(parent);
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
        this.createButtons(parent);
    }

    protected Composite createTable(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        this.getLabelControl(tableComposite);
        this.environmentTable = new TableViewer(tableComposite, 68354);
        Table table = this.environmentTable.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.environmentTable.getControl().setLayoutData((Object)gridData);
        this.environmentTable.setContentProvider((IContentProvider)new EnvironmentVariableContentProvider());
        this.environmentTable.setLabelProvider((IBaseLabelProvider)new EnvironmentVariableLabelProvider());
        this.environmentTable.setColumnProperties(new String[]{ENV_TABLE_KEY, ENV_TABLE_VALUE});
        this.environmentTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                KeyValueListFieldEditor.this.handleTableSelectionChanged(event);
            }
        });
        this.environmentTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!KeyValueListFieldEditor.this.environmentTable.getSelection().isEmpty()) {
                    KeyValueListFieldEditor.this.handleEnvEditButtonSelected();
                }
            }
        });
        ColumnWeightData columnLayout = new ColumnWeightData(50);
        tableLayout.addColumnData((ColumnLayoutData)columnLayout);
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setResizable(columnLayout.resizable);
        tc.setText(TexlipsePlugin.getResourceString("preferenceKeyValueTableColumn1"));
        columnLayout = new ColumnWeightData(50);
        tableLayout.addColumnData((ColumnLayoutData)columnLayout);
        tc = new TableColumn(table, 0, 1);
        tc.setResizable(columnLayout.resizable);
        tc.setText(TexlipsePlugin.getResourceString("preferenceKeyValueTableColumn2"));
        return tableComposite;
    }

    protected Composite createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        buttonComposite.setLayout((Layout)new GridLayout());
        Label empty = new Label(buttonComposite, 0);
        empty.setLayoutData((Object)new GridData());
        this.envAddButton = new Button(buttonComposite, 8);
        this.envAddButton.setText(TexlipsePlugin.getResourceString("preferenceKeyValueAddButton"));
        this.envAddButton.setLayoutData((Object)new GridData(768));
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyValueListFieldEditor.this.handleEnvAddButtonSelected();
            }
        });
        this.envRemoveButton = new Button(buttonComposite, 8);
        this.envRemoveButton.setText(TexlipsePlugin.getResourceString("preferenceKeyValueRemoveButton"));
        this.envRemoveButton.setLayoutData((Object)new GridData(768));
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyValueListFieldEditor.this.handleEnvRemoveButtonSelected();
            }
        });
        this.envRemoveButton.setEnabled(false);
        this.envEditButton = new Button(buttonComposite, 8);
        this.envEditButton.setText(TexlipsePlugin.getResourceString("preferenceKeyValueEditButton"));
        this.envEditButton.setLayoutData((Object)new GridData(768));
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyValueListFieldEditor.this.handleEnvEditButtonSelected();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envImportButton = new Button(buttonComposite, 8);
        this.envImportButton.setText(TexlipsePlugin.getResourceString("preferenceKeyValueImportButton"));
        this.envImportButton.setLayoutData((Object)new GridData(768));
        this.envImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyValueListFieldEditor.this.handleEnvImportButtonSelected();
            }
        });
        Label filler = new Label(buttonComposite, 0);
        filler.setLayoutData((Object)new GridData(1040));
        return buttonComposite;
    }

    private void handleEnvAddButtonSelected() {
        KeyValueInputDialog dialog = new KeyValueInputDialog(this.getLabelControl().getShell(), TexlipsePlugin.getResourceString("preferenceKeyValueAddDialogTitle"), TexlipsePlugin.getResourceString("preferenceKeyValueAddDialogLabel"), this);
        int code = dialog.open();
        if (code == 0) {
            String key = dialog.getKey();
            if (key == null || key.length() == 0) {
                return;
            }
            String value = dialog.getValue();
            this.environment.put(key, value);
            this.environmentTable.add((Object)new EnvironmentVariable(key, value));
        }
    }

    private void handleEnvRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        this.environmentTable.getControl().setRedraw(false);
        for (EnvironmentVariable var : sel) {
            this.environmentTable.remove((Object)var);
            this.environment.remove(var.getName());
        }
        this.environmentTable.getControl().setRedraw(true);
    }

    private void handleEnvEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        EnvironmentVariable var = (EnvironmentVariable)sel.iterator().next();
        if (var == null) {
            return;
        }
        KeyValueInputDialog dialog = new KeyValueInputDialog(this.getLabelControl().getShell(), TexlipsePlugin.getResourceString("preferenceKeyValueEditDialogTitle"), TexlipsePlugin.getResourceString("preferenceKeyValueEditDialogLabel"), this);
        dialog.setKey(var.getName());
        dialog.setValue(var.getValue());
        int code = dialog.open();
        if (code == 0) {
            String key = dialog.getKey();
            if (key == null || key.length() == 0) {
                return;
            }
            String value = dialog.getValue();
            this.environmentTable.remove((Object)var);
            this.environment.remove(var.getName());
            this.environment.put(key, value);
            this.environmentTable.add((Object)new EnvironmentVariable(key, value));
        }
    }

    private void handleEnvImportButtonSelected() {
        String[] items = PathUtils.getStrings(PathUtils.getEnv());
        EnvVarInputDialog dialog = new EnvVarInputDialog(this.getLabelControl().getShell(), TexlipsePlugin.getResourceString("preferenceEnvVarImportDialogTitle"), TexlipsePlugin.getResourceString("preferenceEnvVarImportDialogLabel"), items);
        int code = dialog.open();
        if (code == 0) {
            int[] sel = dialog.getSelections();
            int i = 0;
            while (i < sel.length) {
                String line = items[sel[i]];
                int index = line.indexOf(61);
                if (index > 0) {
                    String key = line.substring(0, index);
                    String value = line.substring(index + 1);
                    this.environment.put(key, value);
                    this.environmentTable.add((Object)new EnvironmentVariable(key, value));
                }
                ++i;
            }
        }
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    protected void doLoad() {
        this.doLoadFrom(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadFrom(String str) {
        this.environment.clear();
        if (str == null) {
            return;
        }
        String[] binds = str.split(SEPARATOR);
        if (binds == null) {
            return;
        }
        int i = 0;
        while (i < binds.length) {
            int index = binds[i].indexOf(61);
            if (index > 0) {
                this.environment.put(binds[i].substring(0, index), binds[i].substring(index + 1));
            }
            ++i;
        }
        this.environmentTable.setInput((Object)this.environment);
    }

    protected void doLoadDefault() {
        this.doLoadFrom(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        StringBuffer sb = new StringBuffer();
        String[] keys = this.environment.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            sb.append(keys[i]);
            sb.append('=');
            sb.append(this.environment.get(keys[i]));
            if (i < keys.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), sb.toString());
    }

    class EnvVarInputDialog
    extends MessageDialog {
        private List envVarList;
        protected int[] selections;
        protected String[] items;

        public EnvVarInputDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.selections = new int[0];
            this.items = new String[0];
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public EnvVarInputDialog(Shell shell, String title, String message, String[] items) {
            this(shell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.items = items;
        }

        protected Point getInitialSize() {
            Point p = super.getInitialSize();
            int sum = 0;
            int maxLen = 0;
            int i = 0;
            while (i < this.items.length) {
                int l = this.items[i].length();
                sum += l;
                if (l > maxLen) {
                    maxLen = l;
                }
                ++i;
            }
            FontData[] fd = this.envVarList.getFont().getFontData();
            p.x = (p.x - 100) * (sum /= this.items.length) / maxLen + 100;
            p.y += fd[0].getHeight() * 8 * 2;
            p.x *= 2;
            return p;
        }

        public int[] getSelections() {
            return this.selections;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout());
            this.envVarList = new List(composite, 2818);
            this.envVarList.setLayoutData((Object)new GridData(1808));
            this.envVarList.setItems(this.items);
            this.envVarList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    EnvVarInputDialog.this.selections = EnvVarInputDialog.this.envVarList.getSelectionIndices();
                }
            });
            return composite;
        }
    }

    class EnvironmentVariable {
        private String name;
        private String value;

        public EnvironmentVariable(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (obj instanceof EnvironmentVariable) {
                EnvironmentVariable var = (EnvironmentVariable)obj;
                equal = var.getName().equals(this.name);
            }
            return equal;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    class EnvironmentVariableContentProvider
    implements IStructuredContentProvider {
        EnvironmentVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new EnvironmentVariable[]{};
            Map m = (Map)inputElement;
            if (m != null && !m.isEmpty()) {
                elements = new EnvironmentVariable[m.size()];
                String[] varNames = new String[m.size()];
                m.keySet().toArray(varNames);
                int i = 0;
                while (i < m.size()) {
                    elements[i] = new EnvironmentVariable(varNames[i], (String)m.get(varNames[i]));
                    ++i;
                }
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer iviewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
                    }
                });
            }
        }
    }

    class EnvironmentVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EnvironmentVariableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class KeyValueInputDialog
    extends MessageDialog {
        private IInputValidator validator;
        private Text keyTextField;
        protected String key;
        private Text valueTextField;
        protected String value;

        public KeyValueInputDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.key = "";
            this.value = "";
        }

        public KeyValueInputDialog(Shell shell, String title, String message, IInputValidator vali) {
            this(shell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.validator = vali;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String name) {
            this.key = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String val) {
            this.value = val;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Label keyLabel = new Label(composite, 16384);
            keyLabel.setLayoutData((Object)new GridData());
            keyLabel.setText("key:");
            this.keyTextField = new Text(composite, 2052);
            this.keyTextField.setLayoutData((Object)new GridData(768));
            this.keyTextField.setText(this.key);
            this.keyTextField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (KeyValueInputDialog.this.validator != null) {
                        KeyValueInputDialog.this.key = KeyValueInputDialog.this.keyTextField.getText();
                        if (KeyValueInputDialog.this.key != null) {
                            KeyValueInputDialog.this.key = KeyValueInputDialog.this.key.trim();
                        }
                        String error = KeyValueInputDialog.this.validator.isValid(KeyValueInputDialog.this.key);
                        Button ok = KeyValueInputDialog.this.getButton(0);
                        ok.setEnabled(error == null);
                    } else {
                        KeyValueInputDialog.this.key = KeyValueInputDialog.this.keyTextField.getText();
                    }
                }
            });
            Label valueLabel = new Label(composite, 16384);
            valueLabel.setLayoutData((Object)new GridData());
            valueLabel.setText("value:");
            this.valueTextField = new Text(composite, 2052);
            this.valueTextField.setLayoutData((Object)new GridData(768));
            this.valueTextField.setText(this.value);
            this.valueTextField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    KeyValueInputDialog.this.value = KeyValueInputDialog.this.valueTextField.getText();
                }
            });
            return composite;
        }
    }
}

