/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import com.swabunga.spell.event.SpellCheckEvent;
import java.text.MessageFormat;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.spelling.TexSpellDictionary;
import net.sourceforge.texlipse.spelling.TexSpellingEngine;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class AddToDictProposal
implements ICompletionProposal {
    private SpellCheckEvent ferror;
    private String fLang;
    private ISourceViewer fviewer;

    public AddToDictProposal(SpellCheckEvent error, String lang, ISourceViewer viewer) {
        this.ferror = error;
        this.fLang = lang;
        this.fviewer = viewer;
    }

    public void apply(IDocument document) {
        TexSpellDictionary dict = TexSpellingEngine.getDict(this.fLang);
        dict.addWord(this.ferror.getInvalidWord());
        SpellingProblem.removeAll((ISourceViewer)this.fviewer, (String)this.ferror.getInvalidWord());
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return MessageFormat.format(TexlipsePlugin.getResourceString("spellCheckerAddToUserDict"), this.ferror.getInvalidWord());
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
    }

    public Point getSelection(IDocument document) {
        return null;
    }
}

