/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordFinder;
import com.swabunga.spell.event.WordTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TeXSpellingReconcileStrategy;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.spelling.AddToDictProposal;
import net.sourceforge.texlipse.spelling.IgnoreProposal;
import net.sourceforge.texlipse.spelling.TexSpellDictionary;
import net.sourceforge.texlipse.spelling.TexlipseWordFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class TexSpellingEngine
implements ISpellingEngine,
SpellCheckListener {
    private static final String DEFAULT_DICT_PATH = "/dict/";
    private static final String DEFAULT_LANG = "en";
    private static SpellChecker spellCheck;
    private static TexSpellDictionary dict;
    private static String currentLang;
    private static Set<String> ignore;
    private List<SpellCheckEvent> errors;

    private static SpellChecker getSpellChecker(String lang) {
        if (lang == null) {
            return null;
        }
        if (lang.equals(currentLang)) {
            return spellCheck;
        }
        String dictPathSt = TexlipsePlugin.getPreference("spellcheckerDictDir");
        if (dictPathSt == null || "".equals(dictPathSt.trim())) {
            return null;
        }
        File dictPath = new File(dictPathSt);
        if (!dictPath.exists() || !dictPath.isDirectory()) {
            return null;
        }
        File f = new File(String.valueOf(dictPath.getAbsolutePath()) + File.separator + lang + ".dict");
        if (!f.exists() || !f.canRead()) {
            return null;
        }
        spellCheck = null;
        dict = null;
        currentLang = lang;
        try {
            FileInputStream input = new FileInputStream(f);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)input, "UTF-8"));
            dict = new TexSpellDictionary(r);
            ((Reader)r).close();
            String customDictPath = TexlipsePlugin.getPreference("spellcheckerCustomDictDir");
            if (customDictPath != null && !"".equals(customDictPath.trim())) {
                dict.setUserDict(new File(String.valueOf(customDictPath) + File.separator + lang + "_user.dict"));
            }
            spellCheck = new SpellChecker((SpellDictionary)dict);
            return spellCheck;
        }
        catch (IOException e) {
            TexlipsePlugin.log("Error while loading dictionary", e);
            return null;
        }
    }

    public static TexSpellDictionary getDict(String lang) {
        TexSpellingEngine.getSpellChecker(lang);
        return dict;
    }

    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        SpellChecker spellCheck;
        if (ignore == null) {
            ignore = new HashSet<String>();
        }
        IProject project = TexlipsePlugin.getCurrentProject();
        String lang = DEFAULT_LANG;
        if (project != null) {
            lang = TexlipseProperties.getProjectProperty((IResource)project, "langSpell");
        }
        if ((spellCheck = TexSpellingEngine.getSpellChecker(lang)) == null) {
            return;
        }
        if (collector instanceof TeXSpellingReconcileStrategy.TeXSpellingProblemCollector) {
            ((TeXSpellingReconcileStrategy.TeXSpellingProblemCollector)collector).setRegions(regions);
        }
        try {
            spellCheck.addSpellCheckListener((SpellCheckListener)this);
            IRegion[] iRegionArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                IRegion r = iRegionArray[n2];
                this.errors = new LinkedList<SpellCheckEvent>();
                int roffset = r.getOffset();
                TexlipseWordFinder wf = new TexlipseWordFinder();
                wf.setIgnoreComments(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("spellcheckerIgnoreComments"));
                wf.setIgnoreMath(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("spellcheckerIgnoreMath"));
                spellCheck.checkSpelling((WordTokenizer)new StringWordTokenizer(document.get(roffset, r.getLength()), (WordFinder)wf));
                for (SpellCheckEvent error : this.errors) {
                    TexSpellingProblem p = new TexSpellingProblem(error, roffset, lang);
                    collector.accept((SpellingProblem)p);
                }
                ++n2;
            }
            spellCheck.removeSpellCheckListener((SpellCheckListener)this);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static boolean isMixedCase(String word) {
        int i = 1;
        while (i < word.length()) {
            if (Character.isUpperCase(word.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void spellingError(SpellCheckEvent event) {
        String invWord = event.getInvalidWord();
        if (invWord.length() < 3) {
            return;
        }
        if (invWord.indexOf(95) > -1) {
            return;
        }
        if (invWord.indexOf(94) > -1) {
            return;
        }
        if (ignore.contains(invWord)) {
            return;
        }
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("spellcheckerIgnoreMixedCase") && TexSpellingEngine.isMixedCase(invWord)) {
            return;
        }
        this.errors.add(event);
    }

    public static class TexSpellingProblem
    extends SpellingProblem {
        private SpellCheckEvent fError;
        private String fLang;
        private int fOffset;
        private static final Image fCorrectionImage = TexlipsePlugin.getImage("correction_change");
        private static final String CHANGE_TO = TexlipsePlugin.getResourceString("spellCheckerChangeWord");
        private static final String MESSAGE = TexlipsePlugin.getResourceString("spellMarkerMessage");

        public TexSpellingProblem(SpellCheckEvent error, int roffset, String lang) {
            this.fError = error;
            this.fOffset = roffset + this.fError.getWordContextPosition();
            this.fLang = lang;
        }

        public ICompletionProposal[] getProposals() {
            return this.getProposals(null);
        }

        public ICompletionProposal[] getProposals(IQuickAssistInvocationContext context) {
            List sugg = this.fError.getSuggestions();
            int length = this.fError.getInvalidWord().length();
            ICompletionProposal[] props = new ICompletionProposal[sugg.size() + 2];
            int i = 0;
            while (i < sugg.size()) {
                String suggestion = ((Word)sugg.get(i)).toString();
                String s = MessageFormat.format(CHANGE_TO, suggestion);
                props[i] = new CompletionProposal(suggestion, this.fOffset, length, suggestion.length(), fCorrectionImage, s, null, null);
                ++i;
            }
            props[props.length - 2] = new IgnoreProposal(ignore, this.fError.getInvalidWord(), context.getSourceViewer());
            props[props.length - 1] = new AddToDictProposal(this.fError, this.fLang, context.getSourceViewer());
            return props;
        }

        public void setOffset(int offset) {
            this.fOffset = offset;
        }

        public int getOffset() {
            return this.fOffset;
        }

        public String getMessage() {
            return MessageFormat.format(MESSAGE, this.fError.getInvalidWord());
        }

        public int getLength() {
            return this.fError.getInvalidWord().length();
        }
    }
}

