/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.templates;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class ProjectTemplateManager {
    private static final String USER_TEMPLATES_DIR = "templates";
    private static final String SYSTEM_TEMPLATES_DIR = "templates";

    public static String[] loadUserTemplateNames() {
        ArrayList list = new ArrayList();
        ProjectTemplateManager.appendUserTemplates(list);
        Object[] array = list.toArray(new String[0]);
        Arrays.sort(array);
        return array;
    }

    public static String[] loadSystemTemplateNames() {
        ArrayList list = new ArrayList();
        ProjectTemplateManager.appendSystemTemplates(list);
        Object[] array = list.toArray(new String[0]);
        Arrays.sort(array);
        return array;
    }

    public static String[] loadTemplateNames() {
        ArrayList list = new ArrayList();
        ProjectTemplateManager.appendSystemTemplates(list);
        ProjectTemplateManager.appendUserTemplates(list);
        Object[] array = list.toArray(new String[0]);
        Arrays.sort(array);
        return array;
    }

    private static void appendSystemTemplates(ArrayList list) {
        Enumeration templateEnum = TexlipsePlugin.getDefault().getBundle().getEntryPaths("templates/");
        while (templateEnum.hasMoreElements()) {
            String path = (String)templateEnum.nextElement();
            if (!path.endsWith(".tex")) continue;
            list.add(path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46)));
        }
    }

    private static void appendUserTemplates(ArrayList list) {
        File userTemplateFolder = ProjectTemplateManager.getUserTemplateFolder();
        if (userTemplateFolder.exists()) {
            File[] templates = userTemplateFolder.listFiles();
            int i = 0;
            while (i < templates.length) {
                String ext;
                String name = templates[i].getName();
                int index = name.lastIndexOf(46);
                String string = ext = index > 0 ? name.substring(index + 1) : "";
                if (ext != null && ext.length() > 0) {
                    name = name.substring(0, name.length() - ext.length() - 1);
                }
                list.add(name);
                ++i;
            }
        }
    }

    public static boolean templateExists(String templateName) {
        URL templ;
        int index = templateName.lastIndexOf(46);
        if (index > 0) {
            String ext = templateName.substring(index + 1);
            if (!ext.equals("tex")) {
                templateName = String.valueOf(templateName) + ".tex";
            }
        } else {
            templateName = String.valueOf(templateName) + ".tex";
        }
        if ((templ = TexlipsePlugin.getDefault().getBundle().getEntry("templates/" + templateName)) != null) {
            return true;
        }
        File userTemplateFolder = ProjectTemplateManager.getUserTemplateFolder();
        return new File(userTemplateFolder, templateName).exists();
    }

    public static byte[] readUserTemplate(String name) throws IOException {
        if (!name.endsWith(".tex")) {
            name = String.valueOf(name) + ".tex";
        }
        return ProjectTemplateManager.readStream(new FileInputStream(new File(ProjectTemplateManager.getUserTemplateFolder(), name)));
    }

    public static byte[] readSystemTemplate(String name) throws IOException {
        URL templ;
        if (!name.endsWith(".tex")) {
            name = String.valueOf(name) + ".tex";
        }
        if ((templ = TexlipsePlugin.getDefault().getBundle().getEntry("templates/" + name)) != null) {
            return ProjectTemplateManager.readStream(templ.openStream());
        }
        return null;
    }

    protected static byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int len = 0;
        while ((len = in.read(buff)) == buff.length) {
            out.write(buff);
        }
        if (len > 0) {
            out.write(buff, 0, len);
        }
        in.close();
        return out.toByteArray();
    }

    public static File getUserTemplateFolder() {
        IPath pluginStatePath = TexlipsePlugin.getDefault().getStateLocation().append("templates").addTrailingSeparator();
        return pluginStatePath.toFile();
    }

    public static void saveProjectTemplate(IFile file, String templateName) {
        int index;
        IPath templateDir = TexlipsePlugin.getDefault().getStateLocation().append("templates");
        File dir = new File(templateDir.toOSString());
        if (!dir.exists()) {
            dir.mkdir();
        }
        if ((index = templateName.lastIndexOf(46)) > 0) {
            String ext = templateName.substring(index + 1);
            if (!ext.equals("tex")) {
                templateName = String.valueOf(templateName) + ".tex";
            }
        } else {
            templateName = String.valueOf(templateName) + ".tex";
        }
        IPath dest = templateDir.append(templateName);
        try {
            ProjectTemplateManager.copyFile(file.getLocation().toFile(), dest.toFile());
        }
        catch (IOException e) {
            TexlipsePlugin.log("Saving template", e);
        }
    }

    private static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buff = new byte[4096];
        int len = 0;
        while ((len = in.read(buff)) == buff.length) {
            out.write(buff);
        }
        if (len > 0) {
            out.write(buff, 0, len);
        }
        out.close();
        in.close();
    }

    public static void deleteUserTemplate(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        IPath pluginStatePath = TexlipsePlugin.getDefault().getStateLocation().append("templates").addTrailingSeparator();
        File userTemplateFolder = pluginStatePath.toFile();
        if (userTemplateFolder.exists()) {
            File[] templates = userTemplateFolder.listFiles();
            int i = 0;
            while (i < templates.length) {
                String fileName = templates[i].getName();
                if (fileName.startsWith(name)) {
                    if (fileName.length() > name.length()) {
                        if (fileName.charAt(name.length()) == '.') {
                            templates[i].delete();
                            return;
                        }
                    } else if (fileName.equals(name)) {
                        templates[i].delete();
                        return;
                    }
                }
                ++i;
            }
        }
    }
}

