#!/usr/local/bin/perl
#
# Perl-Example.pl
# 
# included in the Alpha distribution as an example of the Perl mode
# Perl mode is part of Alpha's standard distribution
# More information about Perl and MacPerl can be found at
#      <http://www.macperl.com/>
#      
# Note: if you use Setext mode, this Perl script can be used to convert
# Setext to HTML.  Some customization is available in the first code block.
#      -Donavan Hall
#      
#########################################################################
# Setext2HTML.pl
# Convert setext input file to html index plus 1 file per chapter.
# NOTE: Input text must be wrapped text (not word processor paragraphs).
# Refer to EasyView documentation for setext details, or anon ftp
#          ftp://garbo.uwasa.fi/mac/tidbits/setext/setext_concepts_Aug92.etx
#
# Sandra Silcot, csg1, ITS, University of Melbourne
# Email: ssilcot@ariel.unimelb.edu.au
#########################################################################
# CUSTOMISE These as required

$title             = "MACSCRPT Digests";
$parttitle         = "MACSCRPT Digest :";
$source = 'Mail digests --> EasyView --> Setext --> Setext2HTML (S.Silcot)';
$datemodified      = '23-Sep-1994.';
$maintainer        = 'Sandra Silcot';
$maintaineremail   = 'ssilcot@www.unimelb.edu.au';
$indexpointers = "<pre><a href=\"ghindex.html\"><b>Search</b></a>  |  ".
"<a href=\"http://www.unimelb.edu.au/~ssilcot/mail-archive/index.html\">Mail-index</a>  |  ".
"<a href=\"http://www.unimelb.edu.au/~ssilcot/index.html\">Sandra's-home</a>  |  ".
"<a href=\"http://www.unimelb.edu.au/\">UniMelb-CWIS</a></pre>";

########################################################### 
# No customisation needed below this line
########################################################### Init
$Url 	   = '(http://|ftp://|afs://|wais://|telnet://|gopher://|' .
	      'news:|nntp:|mid:|cid:|mailto:|prospero:)';
$UrlExp    = $Url . q%[^\s\(\)\|<>"']*[^\.;,"'\|\[\]\(\)\s<>]%;
$HUrlExp   = $Url . q%[^\s\(\)\|<>"'\&]*[^\.;,"'\|\[\]\(\)\s<>\&]%;


$q = '"';              # double quote
require "ctime.pl";
$DateTime = &ctime(time);
chop($DateTime);
if( $MacPerl'Version ) {$pathdelim = ":";}
else                   {$pathdelim = "/";}
@filenameparts = split(/$pathdelim/,$ARGV[0]);
$infile= $filenameparts[$#filenameparts];
if (!infile) {die ("NO INPUT FILE");}

$footer = "\n<hr>\n" .
          "<pre>HTML generated by " .
          "<a href=\"http://www.unimelb.edu.au/~ssilcot/ssperltools/Setext2html.html\">Setext2html.pl</a>".
          " $DateTime.\n" .
          "Original source: $source\n" .
          "<address>$maintainer\n" .
          "<a href=\"mailto:$maintaineremail\">$maintaineremail</a></address>\n" .
          "</pre></body>\n</html>\n";

$CHAPTER = 1;
$SECTION = 2;
$BODY    = 3;
$SKIP    = 0;

########################################################### glob input file

open (STDIN,"$ARGV[0]") || die ("FAILED TO OPEN INPUT FILE $ARGV[0]");

#$out = "<li><a href=$q".$infile."_$cnum.html#$i$q>$_</a></li>\n";
#print $out;
#exit;

# read in the whole file, do bolds and translate specials

$i = 0;
for (<STDIN>) {
#    s~<~&lt;~g;
#    s~>~&gt;~g;
    s~\*\*([^\*]+)\*\*~<b>$1</b>~g;  # setext bolds wrapped like **foo**
    tr//*"'"'/;                # translate specials
    $data[$i] = $_;
    $i++;
}

########################################################### pass 1 - set flags

$prev = "";
$nchapters = 0;

for ($i = 0; $i <= $#data; $i++) {
    $before = $i - 1;
    $_ = $data[$i];                 # $_ is default
    $thislength = length;
    if (($thislength==$prevlength) && (m/^====/i)) {   # preceeding line a chapter
        if ($nchapters == 0) {    
            $docname = $prev;    # first chapter is document name
            chop($docname);
            } 
        $nchapters++;
        $chap{$i} = $prev;
        $flag[$before] = $CHAPTER;
        chop($data[$before]);
        $flag[$i] = $SKIP;
        }
    elsif (($thislength==$prevlength) && (m/^----/i)) {   # preceeding line a section
        $sect{$i} = $prev;
        $flag[$before] = $SECTION;
        chop($data[$before]); 
        $flag[$i] = $SKIP;
        }
    else {
        $flag[$i] = $BODY;        
    }
    $prev = $_;
    $prevlength = length;
}

########################################################### htmlise
# THANKS to Earl Hood - his MHonArc supplies the code which htmlises lines
for ($i = 0; $i <= $#data; $i++) {
####    $data[$i] =~ s~<~&lt;~g;
####    $data[$i] =~ s~>~&gt;~g;
    # convert to html
    $data[$i] = &convert_line($data[$i]);
    # do mail to urls (ex mhonarc by E.Hood
	   $data[$i] =~ s|([\!\%\w\.-]+@[\w\.-]+)|<A HREF="mailto:$1">$1</A>|g;

}

########################################################### do chapter index file

open (STDOUT,">$ARGV[0].html") || die ("FAILED TO OPEN OUTPUT FILE $ARGV[0].html");
print "<html><head>\n<link rev=\"made\" href=\"mailto:$maintaineremail\">\n" .
      "<title>$title</title>\n</head>\n<body>\n\n";
print "$indexpointers\n<hr>\n<h1>$title</h1>\n\n<ul>\n";


# now pass through all the lines again for lists in TOC file

$lastischap = 1;
$cnum = 9;

for ($i = 0; $i <= $#data; $i++) {
    $_ = $data[$i]; 
    if  ($flag[$i] == $CHAPTER) {   # its a chapter
        $cnum++;
        print "<li><a href=$q".$infile."_$cnum.html#$i$q>$_</a></li>\n";
        }
}
print "  </ul>\n<hr>$indexpointers\n\n$footer";

########################################################### chapter contents
# now pass through all the lines again and print heads and body 
# ONE FILE PER CHAPTER - print section contents to each file

$cnum = 9;
$end ="";

for ($i = 0; $i <= $#data; $i++) {
    $_ = $data[$i];   
    if  ($flag[$i] == $CHAPTER) {   
        #
        # NEW CHAPTER - finish off last and start a new output file
        #
        $cnum++;
        if ($cnum == 10) {
            $prev = $infile. ".html";  # link back to index if first chapter
            }
        else {
            $x = $cnum - 1;
            $prev = $infile. "_$x.html";
            }
        $x = $cnum + 1;
        $next = $infile. "_$x.html";
        #
        # finish off last file
        #
        print "$end"; 
        if ($nchapters > 1) {
           if ($cnum == ($nchapters + 9)) {                    # last chapter
               $navigation[$cnum] = "<hr><pre><a href=$q$prev$q><b>Previous-digest</b></a>  |  " .
                                    "<a href=$q$infile.html$q><b>Digest-index</b></a>\n\n".
                                    "$indexpointers\n";
               }
           elsif ($cnum == 10) {                               # first chapter
               $navigation[$cnum] = "<hr><pre><a href=$q$next$q><b>Next-digest</b></a>  |  " .
                                    "<a href=$q$infile.html$q><b>Digest-index</b></a>\n\n".
                                    "$indexpointers\n";
               }
           else {
               $navigation[$cnum] = "<hr><pre><a href=$q$next$q><b>Next-digest</b></a>  |  " .
                                    "<a href=$q$prev$q><b>Previous-digest</b></a>  |  " .
                                    "<a href=$q$infile.html$q><b>Digest-index</b></a>\n\n".
                                    "$indexpointers\n";
               }
           }
        else {$navigation[$cnum] = "";}
        $end = "</ul>\n$navigation[$cnum]\n<hr><pre>";
        close (STDOUT);
        #
        # start next file
        #
        open (STDOUT,">$ARGV[0]_$cnum.html") || die ("FAILED TO OPEN $ARGV[0]_$cnum.html");
        if ($nchapters > 1) {
            print "<html><head>\n" .
                  "<link rev=\"made\" href=\"mailto:$maintaineremail\">\n" .
                  "<title>$title - $_</title>\n</head>\n<body>\n\n";
            }
        else {
            print "<html><head>\n" .
                  "<link rev=\"made\" href=\"mailto:$maintaineremail\">\n" .
                  "<title>$title</title>\n</head>\n<body>\n\n";
            }
        print "$indexpointers\n<hr>\n<h1>$parttitle $_</h1>\n\n<ul>\n";
        }
    elsif  ($flag[$i] == $SECTION) {   # its a section
        #
        # NEW SECTION
        #
        print "<li><a href=#$i>$_</a></li>\n";
        }
}

########################################################### append chapter body
# now pass through all the lines again and print headers for sections and body 
# APPEND TO EACH CHAPTER

$cnum = 9;

for ($i = 0; $i <= $#data; $i++) {
    $_ = $data[$i];   
    if  ($flag[$i] == $CHAPTER) {   # its a chapter

        $cnum++;     
        # print end stuff
        print "$end";
        $end = "</pre>\n<p></p>\n$navigation[$cnum]\n$footer";
        close (STDOUT);

        # append heads and body

        open (STDOUT,">>$ARGV[0]_$cnum.html") || die ("FAILED TO OPEN $ARGV[0]_$cnum.html");
        
        }
    elsif  ($flag[$i] == $SECTION) {   # its a section
        print "</pre>\n\n<hr><h2><a name=$i>$_</a></h2>\n<pre>\n";
        }
    elsif  ($flag[$i] == $BODY) {   # its a body line 
        print;
        }
}

# fin
print "$end";
close (STDOUT);

##---------------------------------------------------------------------------
##	convert_line() translates a line to HTML.  Checks are made for
##	embedded URLs.
sub convert_line {
    local($tmp) = shift;
    local($item, $item2, @array);

    if (!$NOURL) {
	if (@array = split(m%($Url[^\s\(\)\|<>"']*[^\.;,"'\|\[\]\(\)\s<>])%o,
		           $tmp)) {
	    $tmp = '';
	    while($#array > 0) {
		$item = shift @array;
		&htmlize(*item);
		$item2 = shift @array;
		$tmp .= $item . '<A HREF="' . $item2 . '">' . $item2 . '</A>';

		# The next line is needed since Perl's split function also
		# returns extra entries for nested ()'s in the split pattern.
		shift @array  if $array[0] =~ m%^$Url$%o;
	    }
	    $item = shift @array;
	    &htmlize(*item);
	    $tmp .= $item;
	## Regular line
	} else {
	    &htmlize(*tmp);
	}
    } else {
	&htmlize(*tmp);
    }
    $tmp;
}
##---------------------------------------------------------------------------
##	"Entify" special characters
sub htmlize {
    local(*txt) = shift;
    $txt =~ s/&/\&amp;/g;
    $txt =~ s/>/&gt;/g;
    $txt =~ s/</&lt;/g;
    $txt;
}

