## -*-Tcl-*- (install)
 # ###################################################################
 # 
 #  FILE: "clogMode.tcl",v1.1
 #                                    created: 26/5/97 {10:36:06 pm} 
 #                                last update: 16/4/98 {9:02:13 pm} 
 #  Author: Tom Fetherston (trf)
 #  
 #  The object of this mode is to provide support for documentation
 #  of changes to source code in a project, Hence the name of this 
 #  mode, "clog", for Change-log.
 #  
 # ###################################################################
 ##

#  clog mini-load  #
alpha::mode Clog 1.0 dummyClog {*.clog *.clg} {clogMenu} {	
	set clogMenu "Link"
	addMenu clogMenu
} 

proc dummyClog {} {}

#  proc's to register with openhook  #

proc closeAllWindowsExcept {pathOfClogWindowJustOpened} {
	
	set clogWindowJustOpened [file tail $pathOfClogWindowJustOpened] 
	
	set otherWindows [lremove [winNames] $clogWindowJustOpened]
	
	foreach w $otherWindows {
		bringToFront $w
		killWindow
	}
}

hook::register openHook closeAllWindowsExcept Clog

proc establishClogGeo {dummy} {
	global tileHeight tileWidth tileTop tileLeft tileHeight errorHeight errorDisp tileMargin
	
	set top $tileTop
	set geo [getGeometry]
	if {([lindex $geo 0] != $tileLeft) || ([lindex $geo 1] != $top) || ([lindex $geo 3] != $errorHeight) } {
		moveWin $tileLeft $top
		sizeWin $tileWidth $errorHeight
	}
	goto 0
	
}

hook::register openHook establishClogGeo Clog

## 
 # -------------------------------------------------------------------------
 # 
 # "setClogTabsize" --
 # 
 #  We ensure the clog window has a big tabsize to hide links offscreen.
 # -------------------------------------------------------------------------
 ##
proc setClogTabsize {dummy} {
	setWinInfo tabsize 200
}

hook::register openHook setClogTabsize Clog

#  Clog menu and its handlers  #

#empty proc with the same name as the menu for this mode.
# (otherwise we get a wasteful call to 'unknown' when changeMode
#   tries to call the menu as a menu-returning proc e.g. htmlMenu)
proc clogMenu {} {}

# # The menu.
menu -n $clogMenu {
	"multiModeVisibility"
	"(-"
	"formLink"
	"formOpenFileLink"
	"pasteLink"
	"(-"
	"saveToBackup"
	"(-"
	"checkLinks"
}

proc multiModeVisibility {} {
	global menus globalMenus_curr clogMenu
	
	set isMultimodeVisible [lsearch $globalMenus_curr clogMenu]
	if {$isMultimodeVisible != -1} {
		#uncheck "multi-ModeVisibility"
		markMenuItem $clogMenu {multiModeVisibility} off
		#remove menu
		catch "removeMenu clogMenu"
		#delete from globalMenus_curr
		extractList globalMenus_curr $isMultimodeVisible
	} else {
		#check "multi-ModeVisibility"
		markMenuItem  $clogMenu {multiModeVisibility} on		
# 		#insert menu global to all modes
# 		
		#add to globalMenus_curr
		lappend globalMenus_curr "clogMenu"
	} 
}

proc formLink {} {
	global mode clogMenu clog::scrap
	
	if {$mode == "Clog"} {
		alertnote "Forming links to a change log document is not allowed"
		return 0
	} 
	if {![isSelection]} {
		message "this links terminus will be a single line"
		#select all of the line the insertion point is on
		set pos [getPos]
		select [lineStart $pos] [nextLineStart [lineStart $pos]]
		#get, validate, and remember globally that line's contents
		set scrap [getSelect]
		if {[regexp  "" $scrap]} {
			alertnote "a link terminus cannot contain any '' characters"
			return 0
		} 
		#get the pathname for the file associated with this window
		set pname [lindex [winNames -f] 0]
		set clog::scrap "$pname$scrap"
	} 
}


proc pasteLink {} {
	global mode clogMenu clog::scrap
	
	if {$mode != "Clog"} {
		alertnote "You can only paste links into a change log document."
		return 0
	} 
# 	if {![isSelection]} {
# 		alertnote "To make sure the link only get set at "
# 	} 
	#establish which line you are going to set the link on
	set pos [getPos]
	select [lineStart $pos] [nextLineStart [lineStart $pos]]
	set targetLine [getSelect]
	#remove any pre-existing link
	
	#pre-pend a link indicator (if not already there)
	set targetLine " [string trimright $targetLine "\r"]"
	#establish link
	set text ${clog::scrap}
	set ind1 [string first "" $text]
	set ind2 [string last "" $text]
	if {$ind1 == $ind2} {
		set link $text
		message "this must be an 'open file' type link"
	} else {
		set fname [string trim [string range $text $ind1 $ind2] {}]
		set fname [substDirVars $fname]
		set patt "^[quoteExpr2 [string trim [string range $text $ind2 end] {}]]"
		set link "$fname$patt"
	}
	#insert link into doc
	set targetLine "$targetLine\t$link"
	replaceText [getPos] [selEnd] $targetLine
}

proc substDirVars {f} {
	global vinceD PREFS HOME TeXInputs perlFilterPath
	
	catch {regsub  [quoteExpr2 $HOME] $f "\$\{HOME\}" f}
	catch {regsub  [quoteExpr2 $vinceD] $f "\$\{vinceD\}" f}
	catch {regsub  [quoteExpr2 $PREFS] $f "\$\{PREFS\}" f}
	catch {regsub  [quoteExpr2 $TeXInputs] $f "\$\{TeXInputs\}" f}
	catch {regsub  [quoteExpr2 $perlFilterPath] $f "\$\{perlFilterPath\}" f}

	return $f
}
#  modeVars  #
newModeVar Clog commentColor	red	0
newModeVar Clog linkColumun		200	0



#  colorizing  #
regModeKeywords -e {#} -c $ClogmodeVars(commentColor) Clog {}

#  marking  #

proc Clog::MarkFile {} {
	set end [maxPos]
	set pos 0
	set l {}
	set markExpr {^[ 	]*# }
	set class ""
	set hasMarkers 0
	while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$markExpr" $pos} res]} {
		set start [lindex $res 0]
		set end [nextLineStart $start]
		set t [getText $start $end]
		switch -glob [lindex $t 0] {
			"#" { 
				regexp "#  (.*)  #" $t all text
				set text "$text"
				set hasMarkers 1
			}
		}
		set pos $end
		set inds($text) [lineStart [expr $start - 1]]
		lappend asEncountered $text
	}

	set already ""
	
	if {[info exists inds]} {
		foreach f $asEncountered {
			if {$inds($f) != 0} {
				set next [nextLineStart $inds($f)]
			} else {
				set next 0
			} 
			
			if { [string first "000" $f] != -1 } {
				set ff "Class '[lindex $f 0]'"
			} elseif {0} {#{ [string first "::" $f] != -1 } 
				set ff [split $f "::"]
				set ff " :: [lindex $ff [expr [llength $ff] -1]]"
			} else {
				set ff $f
			}
			while { [lsearch -exact $already $ff] != -1 } {
				set ff "$ff "
			}
			lappend already $ff
			if {$hasMarkers && ![string match "*" $ff] } {
				set ff " $ff"
			} 
			setNamedMark $ff $inds($f) $next $next
		}
	}
}
 
#  file linking  #

#  link locaters  #

## 
 # -------------------------------------------------------------------------
 # 
 # "fromInstall" --
 # 
 #  this proc looks to see if the clog document is in some subdirectory of 
 #  the HOME folder. If so, it look for files as given in links. If not, it 
 #  will look to see if file is in the same folder as the clog document, or 
 #  a subfolder. This way, you can talk about changes before they are loaded 
 #  into Alpha, and then later refer to the copied in files just by changing 
 #  the location on the file
 # -------------------------------------------------------------------------
 ##
proc fromInstall {} {
	
}

#  navigation  #
proc upClog {} {
	set pos [getPos]
	set limit [nextLineStart [nextLineStart 0]]
	set found [expr ![catch {search -f 0 -r 1 -l $limit -- "^\[ 	\]+" [expr $pos - 1]} BegEnd]]
	if {$found} {
		eval select $BegEnd 
	}
}

proc downClog {} {
	set pos [getPos]
	if {$pos < [nextLineStart 0]} {
		set pos [nextLineStart 0]
	}
	if {[nextLineStart $pos] != [maxPos]} {
		set found [expr ![catch {search -f 1 -r 1   -- "^\[ 	\]+" [expr $pos +1]} BegEnd]]
		if {$found} {
			eval select $BegEnd 
		} 
		
	}
	select [lineStart $beg] [nextLineStart [lineStart $beg]]
}

proc clogGotoMatch { {goto/PEEK 0 } } {
	global tileHeight tileWidth tileTop tileLeft tileHeight errorHeight errorDisp tileMargin
	global vinceD PREFS HOME TeXInputs perlFilterPath
	
	set clogDoc [lindex [winNames] 0]

	set errorDisp [expr (2 * ($tileHeight - $tileMargin)) / 3]
	set beg [getPos] 
	set clog_BegEnd [list [lineStart $beg] [expr [nextLineStart $beg] - 1]]
	set text [getText [lineStart $beg] [expr [nextLineStart $beg] - 1]]
	set ind1 [string first "" $text]
	set ind2 [string last "" $text]
	if {$ind1 == $ind2} {
		set fname [subst [string trim [string range $text $ind1 end] {}]]
		set patt ""
	} else {
		set fname [subst [string trim [string range $text $ind1 $ind2] {}]]
		set patt [string trim [string range $text $ind2 end] {}]
	}
	# if clog doc is not in the $HOME tree, look for local versions to kink to
	set clogDocPath [lindex [winNames -f] 0]
	if {![string match "${HOME}*" $clogDocPath]} {
		set fname [file::PathWithRespectToTopWindow'sDir [file tail $fname]]
	} 
	set mar $tileMargin
	set top $tileTop
	incr top [expr $errorHeight + $mar]
	
	if {[string length $patt]} {
		set indices [searchInFile $fname $patt 1]
	}
	
	if {[expr {[lsearch [winNames -f] "*$fname"] >= 0}]} {
		if {[string match "*:*" $fname]} {
			set fname [file tail $fname]
		}
		if {[expr {[lsearch [winNames -f] "$fname"] != 1}]} {
			bringToFront $fname
		}
	} elseif {[file exists $fname]} {
		edit -g $tileLeft $top $tileWidth $errorDisp $fname
	} else {
		if {![string match "*Link*" [getText 0 [nextLineStart 0]]]} {
			alertnote "File \" $fname \" not found." 
		}
		return
	}
	if {[regexp {Line 1:} $text dummy]} {
		select -w \{$fname\} 0 0
	} else {
		set found [expr ![catch {search -f 1 -r 1   -- $patt 0} file_BegEnd]]
		if {$found} {
			eval select -w \{$clogDoc\} $clog_BegEnd 
			eval select -w \{$fname\} $file_BegEnd 
		} 

	} 
	#return to the change log document
	if { ${goto/PEEK} } {
		bringToFront $clogDoc
	} else {
		bringToFront $fname
	}
}

proc scrollUpLineInOther {} {
	otherThing
	scrollUpLine
	otherThing
}

#  other Key bound procs (& support)  #

proc file::PathWithRespectToTopWindow'sDir { name } {
	set currD [list [file dirname [lindex [winNames -f] 0]]]
	set dirs [glob -nocomplain "$currD:*:"]
	foreach d $dirs {
		lappend currD [string trimright $d :]
	}
	foreach d $currD {
		if [file exists "$d:$name" ] {
			return "$d:$name"
		}
	}
	error "Sorry, couldn't find $name"
}

## 
 # -------------------------------------------------------------------------
 # 
 # "ClogcarriageReturn" --
 # 
 #  This lets the return key carry out two functions, a normal carrigeReturn
 #  if we don't have a linking line selected, (so you can add text to the clog
 #  file), or traverse link if an linking line is selected.
 #  
 #  note: although it is now normal not to link this to a the return key
 #    directly in a mode, i do so here because univ::carriageReturn checks
 #    and delete a selection automatically.
 # -------------------------------------------------------------------------
 ##
proc ClogcarriageReturn {} {
	if {[isSelection]} {
		if {[linkIndicatorSelected]} {
			clogGotoMatch
			return
		} elseif {[linkingLineSelected]} {
			downClog 
			return
		} else {
			deleteSelection
		} 	
	}
	insertText "\r"
	univ::IndentLine		
}

proc Clog_space {} {
	if {[isSelection]} {
		set justShow 1
		if {[linkIndicatorSelected]} {
			clogGotoMatch $justShow 
			return
		} elseif {[linkingLineSelected]} {
			downClog 
			return
		} else {
			deleteSelection
		} 	
	}
	insertText " "
}

proc linkIndicatorSelected {} {
	set text [getSelect]
	if {[regexp "^\[ 	\]+$" $text ]} {
		return 1
	} else {
		return 0
	} 
}

proc linkingLineSelected {} {
	set text [getSelect]
	if {[regexp "^\[ 	\]+\[^ 	\].*$" $text ]} {
		return 1
	} else {
		return 0
	} 
}

#  bindings  #
bind '\r'		ClogcarriageReturn 				Clog
bind '\r' <c>	clogGotoMatch					Clog
bind enter		clogGotoMatch					Clog
bind down 		downClog 						Clog
bind up 		upClog 							Clog
bind up <cs>	scrollUpLineInOther 			Clog
bind '3' <o>	insertDivider					Clog
ascii 0x20  	Clog_space						Clog
bind 0x30       {insertText "  "}				Clog


#  Marking  #