/*
 * Copyright (c) 1994 Paul Vojta.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
 /*
    Ported to MS-DOS by Apostolos Syropoulos.
  */
#ifndef lint
static  char    copyright[] =
"@(#) Copyright (c) 1994 Paul Vojta.  All rights reserved.\n /
 Ported to MS-DOS by Apostolos Syropoulos\n";
#endif

#include "config.h"
#include <errno.h>
#include <ctype.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <setjmp.h>

#ifdef  POSIX_DIRENT
#include <dirent.h>
typedef struct dirent   struct_dirent;
#else   /* !POSIX */
#include <sys/dir.h>
typedef struct direct   struct_dirent;
#endif

#define BLANC " "

#ifndef atof
double  atof();
#endif
char    *getenv();

#ifdef  __GNUC__
#define NORETURN        volatile
#else
#define NORETURN        /* nothing */
#endif

#ifdef  I_STDARG
#define NeedVarargsPrototypes   1
#include <stdarg.h>
#else
#define NeedVarargsPrototypes   0
#include <varargs.h>
#endif

typedef char    Boolean;
#define True    1
#define False   0

#ifndef MAXPATHLEN
#define MAXPATHLEN      256
#endif

char    ident[] = "gsftopk version 1.10";

typedef unsigned char   byte;


/*
 *      Information from the .tfm file.
 */

int             tfm_lengths[12];
#define lh      tfm_lengths[1]
#define bc      tfm_lengths[2]
#define ec      tfm_lengths[3]
#define nw      tfm_lengths[4]

long            checksum;
long            design;
byte            width_index[256];
long            tfm_widths[256];

/*
 *      Print error message and quit.
 */

#if     NeedVarargsPrototypes
NORETURN void
oops(const char *message, ...)
#else
/* VARARGS */
NORETURN void
oops(va_alist)
	va_dcl
#endif
{
#if     !NeedVarargsPrototypes
	const char *message;
#endif
	va_list args;

#if     NeedVarargsPrototypes
	va_start(args, message);
#else
	va_start(args);
	message = va_arg(args, const char *);
#endif
	vfprintf(stderr, message, args);
	va_end(args);
	putc('\n', stderr);
	exit(1);
}

/*
 *      Either allocate storage or fail with explanation.
 */

char *
xmalloc(size, why)
	unsigned        size;
	const char      *why;
{
	char *mem = (char *) malloc(size);

	if (mem == NULL)
	    oops("Cannot allocate %u bytes for %s.\n", size, why);
	return mem;
}

/*
 *      Either reallocate storage or fail with explanation.
 */

char *
xrealloc(oldp, size, why)
	char            *oldp;
	unsigned        size;
	const char      *why;
{
	char    *mem;

	mem = oldp == NULL ? (char *) malloc(size)
	    : (char *) realloc(oldp, size);
	if (mem == NULL)
	    oops("Cannot reallocate %u bytes for %s.\n", size, why);
	return mem;
}

/*
 *      Here's the patch searching stuff.  First the typedefs and variables.
 */

static  char    searchpath[MAXPATHLEN + 1];

#define HUNKSIZE        (MAXPATHLEN + 2)

struct spacenode {      /* used for storage of directory names */
	struct spacenode        *next;
	char                    *sp_end;        /* end of data for this chunk */
	char                    sp[HUNKSIZE];
}
	firstnode;

static  jmp_buf found_env;
static  FILE    *searchfile;
static  char    *searchname;
static  int     searchnamelen;

static  char *
find_dbl_slash(char *sp_bgn, char *sp_end)
{
	char *p;

	for (;;) {
	    p = memchr(sp_bgn, '/', sp_end - sp_bgn);
	    if (p == NULL) return sp_end;
	    if (p[1] == '/') return p;
	    sp_bgn = p + 1;
	}
}

static  void
main_search_proc(char *matpos, char *sp_pos, char *sp_slash, char *sp_end,
	Boolean skip_subdirs, struct spacenode *space, char *spacenext, char*mode)
{
	char            *mp;
	struct stat     statbuf;
	DIR             *dir;
	struct_dirent   *entry;
	int             lenleft;
	int             len;
	struct spacenode *space1;
	char            *spacenext1;

	mp = matpos + (sp_slash - sp_pos);
	/* check length */
	if (mp + searchnamelen >= searchpath + sizeof(searchpath) - 2) return;
	memcpy(matpos, sp_pos, sp_slash - sp_pos);
	if (sp_slash == sp_end) {       /* try for a file */
	    *mp = '/';
	    strcpy(mp + (mp == searchpath || mp[-1] != '/'), searchname);
	    searchfile = fopen(searchpath, mode);
	    if (searchfile != NULL) longjmp(found_env, True);
	}
	else {/* try for a subdirectory */
	    *mp = '\0';
	    if (stat(searchpath, &statbuf) == 0 && S_ISDIR(statbuf.st_mode)) {
		*mp++ = '/';
		sp_slash += 2;
		main_search_proc(mp, sp_slash, find_dbl_slash(sp_slash, sp_end),
		    sp_end, statbuf.st_nlink <= 2, space, spacenext, mode);
		return;
	    }
	}
	if (skip_subdirs) return;
	*matpos = '\0';
	dir = opendir(searchpath);
	if (dir == NULL) return;
	lenleft = searchpath + sizeof(searchpath) - matpos;
	space1 = space;
	spacenext1 = spacenext;
	for (;;) {
	    entry = readdir(dir);
	    if (entry == NULL) break;
	    len = strlen(entry->d_name) + 1;
	    if (len > lenleft) continue;        /* too long */
	    strcpy(matpos, entry->d_name);
	    if (*matpos == '.' && (matpos[1] == '\0' || (matpos[1] == '.'
		    && matpos[2] == '\0')))
		continue;               /* ignore . and .. */
	    if (stat(searchpath, &statbuf) != 0 || !S_ISDIR(statbuf.st_mode))
		continue;               /* if not a directory */
	    if (statbuf.st_nlink > 2) ++len;
	    if (spacenext1 + len > space1->sp + HUNKSIZE) {
		space1->sp_end = spacenext1;
		if (space1->next == NULL) {
		    space1->next =
			(struct spacenode *) xmalloc(sizeof(struct spacenode),
			    "space for directory names");
		    space1->next->next = NULL;
		}
		space1 = space1->next;
		spacenext1 = space1->sp;
	    }
	    if (statbuf.st_nlink > 2) {
		*spacenext1++ = '/';
		--len;
	    }
	    memcpy(spacenext1, entry->d_name, len);
	    spacenext1 += len;
	}
	closedir(dir);
	for (;;) {
	    space1->sp_end = spacenext1;
	    if (spacenext == space->sp_end) {
		if (space == space1) break;
		space = space->next;
		spacenext = space->sp;
	    }
	    skip_subdirs = True;
	    if (*spacenext == '/') {
		++spacenext;
		skip_subdirs = False;
	    }
	    len = strlen(spacenext);
	    memcpy(matpos, spacenext, len);
	    matpos[len] = '/';
	    main_search_proc(matpos + len + 1, sp_pos, sp_slash, sp_end,
		skip_subdirs, space1, spacenext1, mode);
	    spacenext += len + 1;
	}
}

static  FILE *
search(char *path, char *path_var, char *name, char *mode)
{
	char    *env_path       = NULL;
	FILE    *f;

	if (path_var != NULL) {
	    if (*name == '/') {
		strcpy(searchpath, name);
		return fopen(searchpath, "r");
	    }
	    env_path = getenv(path_var);
	}
	if (env_path == NULL) {
	    env_path = path;
	    path = NULL;
	}
	searchname = name;
	searchnamelen = strlen(name);
	for (;;) {
	    char *p;

	    p = strchr(env_path, ':');
	    if (p == NULL) p = env_path + strlen(env_path);
	    if (p == env_path) {
		if (path != NULL) {
		    f = search(path, NULL, name, mode);
		    if (f != NULL) return f;
		}
	    }
	    else {
		if (setjmp(found_env))
		    return searchfile;
		main_search_proc(searchpath,
		    env_path, find_dbl_slash(env_path, p), p,
		    True, &firstnode, firstnode.sp, mode);
	    }
	    if (*p == '\0') return NULL;
	    env_path = p + 1;
	}
}

/*
 *      Add to dlstring
 */

char            *dlstring       = NULL;
unsigned int    dls_len         = 0;
unsigned int    dls_max         = 0;

void
addtodls(char *s)
{
	int     len     = strlen(s);

	if (dls_len + len >= dls_max) {
	    unsigned int newsize = dls_max + 80;

	    if (newsize <= dls_len + len) newsize = dls_len + len + 1;
	    dlstring = xrealloc(dlstring, dls_max = newsize, "download string");
	}
	strcpy(dlstring + dls_len, s);
	dls_len += len;
}



long
getlong(FILE *f)
{
	int     value;

	value = (int) ((byte) getc(f)) << 24;
	value |= (int) ((byte) getc(f)) << 16;
	value |= (int) ((byte) getc(f)) << 8;
	value |= (int) ((byte) getc(f));
	return value;
}

int
main(int argc, char **argv)
{
	FILE    *config_file;
	FILE    *tfm_file;
	float   dpi;
	char    *fontname;
	int     fontlen;
	char    *configline;
	unsigned int    cflinelen;
	char    *p;
	char    *PSname         = NULL;
	char    *specinfo       = "";
	char    *xfilename;
	char    charlist[10*2 + 90*3 + 156*4 + 1];
	char    designstr[20];
	char    dpistr[20];
	int     cc;
	int     ppp;
	int     i;

	FILE    *cmd_file;
	FILE    *out_data;
	char    render_ps[30];

	if (argc != 3 || (dpi = atof(argv[2])) <= 0.0) { 
	    fputs("Usage: gsftopk <font> <dpi>\n", stderr);
	    exit(1);
	}

	fontname = argv[1];
	fontlen = strlen(fontname);

	printf("%s\n",ident);

	config_file = search(CONFIGPATH, "TEXCONFIG", "psfonts.map", "r");
	if (config_file == NULL) oops("Cannot find file psfonts.map.");

	configline = (char *) xmalloc(cflinelen = 80, "Config file line");
	do {
	    int len     = 0;

	    if (fgets(configline, cflinelen, config_file) == NULL)
		oops("Cannot find font %s in config file.", fontname);
	    for (;;) {
		i = strlen(configline + len);

		len += i;
		if (len > 0 && configline[len - 1] == '\n') {
		    configline[--len] = '\0';
		    break;
		}
		if (len < cflinelen - 1) break;
		configline = xrealloc(configline, cflinelen += 80,
		    "config file line");
		fgets(configline + len, cflinelen - len, config_file);
	    }
	}
	while (memcmp(configline, fontname, fontlen) != 0
	    || (configline[fontlen] != '\0' && !isspace(configline[fontlen])));
	fclose(config_file);

	/*
	 * Parse the line from the config file.
	 */
	for (p = configline + fontlen; *p != '\0'; ++p) {
	    if (isspace(*p)) continue;
	    if (*p == '<') {
		char    *q      = ++p;
		char    endc;
		FILE    *f;

		addtodls(" (");
		while (*p != '\0' && !isspace(*p)) ++p;
		endc = *p;
		*p = '\0';
		f = search(HEADERPATH, "DVIPSHEADERS", q, "rb");
		if (f == NULL) oops("Cannot find font file %s", q);
		/* search() also sets searchpath */
		addtodls(searchpath);
		addtodls((char) getc(f) == '\200' ? ") brun" : ") run");
		fclose(f);
		if (endc == '\0') break;
		continue;
	    }
	    else if (*p == '"') {
		char    *q;

		specinfo = ++p;
		q = strchr(p, '"');
		if (q == NULL) break;
		p = q;
	    }
	    else {
		PSname = p;
		while (*p != '\0' && !isspace(*p)) ++p;
		if (*p == '\0') break;
	    }
	    *p = '\0';
	}

#ifdef  OLD_DVIPS
	/* Parse lines like `Symbol-Slanted "/Symbol .167 SlantFont"'. */
	if (*(p = specinfo) == '/') {
	    PSname = ++p;
	    while (*p && !isspace(*p)) ++p;
	    if (*p) *p++ = '\0';
	    specinfo = p;
	}
#endif  /* OLD_DVIPS */

	tfm_file = search(HEADERPATH, "DVIPSHEADERS", "render.ps", "r");
	strcpy(render_ps, searchpath);
	if (tfm_file == NULL)
	    oops("Cannot find PS driver file \"render.ps\".");
	fclose(tfm_file);
	sprintf(dpistr, "%f", dpi);
	      
	/*
	 *      Open and read the tfm file.  If this takes a while, at least
	 *      it can overlap with the startup of GhostScript.
	 */

	fontlen = strlen(fontname);
	xfilename = xmalloc(fontlen + 10, "name of tfm/pk file");
	strcpy(xfilename, fontname);
	strcpy(xfilename + fontlen, ".tfm");
	tfm_file = search(TEXFONTS_DEFAULT, "TEXFONTS", xfilename, "rb");
	if (tfm_file == NULL) oops("Cannot find tfm file.");
	for (i = 0; i < 12; ++i) {
	    int j;

	    j = (int) ((byte) getc(tfm_file)) << 8;
	    tfm_lengths[i] = j | (int) ((byte) getc(tfm_file));
	}
	checksum = getlong(tfm_file);
	design = getlong(tfm_file);
	fseek(tfm_file, 4 * (lh + 6), 0);
	p = charlist;
	for (cc = bc; cc <= ec; ++cc) {
	    width_index[cc] = (byte) getc(tfm_file);
	    if (width_index[cc] != 0) {
		sprintf(p, "%d ", cc);
		p += strlen(p);
	    }
	    (void) getc(tfm_file);
	    (void) getc(tfm_file);
	    (void) getc(tfm_file);
	}
	for (i = 0; i < nw; ++i) tfm_widths[i] = getlong(tfm_file);
	fclose(tfm_file);
	p[-1] = '\n';

	/* write the design size and character list to the file */
	if((out_data=fopen("gsin","w")) == NULL){
	    printf("Can't create file \"gsin\"\n");
	    exit(1);
	}
	sprintf(designstr, "%f\n", (float) design / (1 << 20));
	fprintf(out_data, "%s%s", designstr, charlist);
	fclose(out_data);

	/* Invoce GhostScript                       */

	if((cmd_file=fopen("gs.ps","w")) == NULL){
	   printf("Can't create batch file \"gs.bat\"\n");
	   exit(1);
	}
	fprintf(cmd_file, "(%s)\n", (PSname != NULL ? PSname : fontname));
	fprintf(cmd_file, "(%s)\n", (dlstring != NULL ? dlstring : ""));
	fprintf(cmd_file, "(%s)\n", (strcmp(specinfo, "") == 0 ? "" : specinfo));
	fprintf(cmd_file, "(%s)\n",   dpistr);
	fprintf(cmd_file, "(%s) run", render_ps);
	fclose(cmd_file);
	return 0;
}
