; address translation subroutines for virtual arrays of
; (e)TeX, METAFONT, MetaPost, PATgen, etc.
; Copyright (C) 1991,96 by Peter Breitenlohner
; Distributed under terms of GNU General Public License

DATA        segment word
            extrn   clock:word
DATA        ends

stamp       equ     (100h*sz)+8  ; offset of stamp in slotrec

CODE        segment word
            assume  cs:CODE, ds:DATA
            extrn   fetchmem:far

; function fetch_mem(id: Word): Word; {brings a page into memory}
;           brings the page id into memory ( Hi(id)=type Lo(id)=nr )
;           returns segment allocated to that page

CODE        ends
.XLIST
getofs      macro                ; convert index into offset
            if      sz eq 4
            add     ax,ax
            add     ax,ax
            else
            if      sz eq 6
            mov     bx,ax
            add     ax,ax
            add     ax,bx
            add     ax,ax
            else
            err     ; sz must be 4 or 6
            endif
            endif
            endm

virtaddr    macro   name, zro
            local   @@1, @@2, @@3
DATA        segment word
            extrn   t&name:word  ; page translation table
            extrn   i&name:word  ; id of most recently used page
            extrn   s&name:word  ; segment of most recently used page
DATA        ends

CODE        segment word

            public  f&name

f&name      proc    near
            pop     cx           ; return address
            pop     ax           ; ax = p
            sub     ah,byte ptr i&name ; ah = Hi(p) - Hi(mru_p)
            jnz     @@1          ; this is a different page
            mov     dx,s&name    ; dx = slseg; ax = Lo(p)
            getofs               ; dx:ax = result
            jmp     cx           ; return

@@1:        mov     si,offset clock ; incr(clock)
            add     word ptr [si],1
            adc     word ptr [si+2],0
            add     byte ptr i&name,ah ; remember this page
            xor     ah,ah        ; ax = Lo(p)
            ifb     <zro>
            xor     bh,bh
            mov     bl,byte ptr i&name ; bx = Hi(p)
            else
            mov     bx,i&name    ; bx = Hi(p) since name&_pg_type=0
            endif
            add     bx,bx
            add     bx,bx
            mov     dx,t&name[bx] ; dx = t&name[Hi(p)].slseg
            or      dx,dx
            jz      @@3          ; page is not in memory
@@2:        mov     s&name,dx    ; remember slseg
            mov     es,dx
            mov     di,stamp     ; stamp:=clock
            cld
            movsw
            movsw
            getofs               ; dx:ax = result
            jmp     cx           ; return

@@3:        push    cx           ; save cx, si, ax
            push    si
            push    ax
            push    i&name       ; Hi(id) = type; Lo(id) = Hi(p)
            assume  cs:NOTHING
            call    fetchmem
            assume  cs:CODE
            mov     dx,ax        ; dx = fetch_mem(id)
            pop     ax           ; restore ax, si, cx
            pop     si
            pop     cx
            jmp     @@2
f&name      endp
CODE        ends
            endm
.LALL
.LIST
