/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import java.io.Serializable;
import java.util.Vector;
import nts.command.OtherToken;
import nts.command.SpaceToken;
import nts.command.Token;
import nts.io.CharCode;
import nts.io.Log;
import nts.io.Loggable;
import nts.io.MaxLoggable;
import nts.io.Name;

public class TokenList
implements Serializable,
Loggable,
MaxLoggable {
    public static final TokenList NULL;
    public static final TokenList EMPTY;
    private Token[] tokens;

    private static Token tokenFor(char chr) {
        if (chr == ' ') {
            return SpaceToken.TOKEN;
        }
        return new OtherToken(Token.makeCharCode(chr));
    }

    private static Token tokenFor(CharCode code) {
        if (code.match(' ')) {
            return SpaceToken.TOKEN;
        }
        return new OtherToken(code);
    }

    public final int length() {
        return this.tokens.length;
    }

    public final boolean isEmpty() {
        return this.length() == 0;
    }

    public final Token tokenAt(int idx) {
        return this.tokens[idx];
    }

    public final boolean match(TokenList list) {
        if (this.length() == list.length()) {
            int i = 0;
            while (i < this.length()) {
                if (!this.tokenAt(i).match(list.tokenAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void addOn(Log log) {
        int i = 0;
        while (i < this.length()) {
            this.tokenAt(i).addProperlyOn(log);
            ++i;
        }
    }

    public void addOn(Log log, int maxCount) {
        maxCount += log.getCount();
        int i = 0;
        while (i < this.length() && log.getCount() < maxCount) {
            this.tokenAt(i).addProperlyOn(log);
            ++i;
        }
        if (i < this.length()) {
            log.addEsc("ETC.");
        }
    }

    public void addContext(Log left, Log right, int pos, int maxCount) {
        Log log = left;
        maxCount += log.getCount();
        int i = 0;
        while (i < this.length() && log.getCount() < maxCount) {
            if (i == pos) {
                maxCount -= log.getCount();
                log = right;
                maxCount += log.getCount();
            }
            this.tokenAt(i).addProperlyOn(log);
            ++i;
        }
        if (i < this.length()) {
            log.addEsc("ETC.");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.length()) {
            buf.append(this.tokenAt(i++));
        }
        return buf.toString();
    }

    public TokenList() {
        this.tokens = new Token[0];
    }

    public TokenList(Token[] tokens) {
        this.tokens = tokens;
    }

    public TokenList(Token[] tokens, int offset, int count) {
        this.tokens = new Token[count];
        System.arraycopy(tokens, offset, this.tokens, 0, count);
    }

    public TokenList(Token tok) {
        this.tokens = new Token[1];
        this.tokens[0] = tok;
    }

    public TokenList(String str) {
        this.tokens = new Token[str.length()];
        int i = 0;
        while (i < str.length()) {
            this.tokens[i] = TokenList.tokenFor(str.charAt(i));
            ++i;
        }
    }

    public TokenList(Name name) {
        this.tokens = new Token[name.length()];
        int i = 0;
        while (i < name.length()) {
            this.tokens[i] = TokenList.tokenFor(name.codeAt(i));
            ++i;
        }
    }

    static {
        EMPTY = new TokenList();
    }

    public static class Buffer
    implements Loggable,
    MaxLoggable {
        protected Vector data;

        public Buffer append(Token tok) {
            this.data.addElement(tok);
            return this;
        }

        public Buffer append(char chr) {
            return this.append(TokenList.tokenFor(chr));
        }

        public Buffer append(CharCode code) {
            return this.append(TokenList.tokenFor(code));
        }

        public Buffer append(Token[] tokens, int offset, int count) {
            this.data.ensureCapacity(this.data.size() + count);
            while (count-- > 0) {
                this.data.addElement(tokens[offset++]);
            }
            return this;
        }

        public Buffer append(Token[] tokens) {
            return this.append(tokens, 0, tokens.length);
        }

        public Buffer append(TokenList list) {
            return this.append(list.tokens);
        }

        public void insertTokenAt(Token tok, int idx) {
            this.data.insertElementAt(tok, idx);
        }

        public void insertTokenAt(CharCode code, int idx) {
            this.data.insertElementAt(TokenList.tokenFor(code), idx);
        }

        public void insertTokenAt(char chr, int idx) {
            this.data.insertElementAt(TokenList.tokenFor(chr), idx);
        }

        public int length() {
            return this.data.size();
        }

        public void setLength(int size) {
            this.data.setSize(size);
        }

        public Token tokenAt(int idx) {
            return (Token)this.data.elementAt(idx);
        }

        public Token lastToken() {
            return (Token)this.data.elementAt(this.data.size() - 1);
        }

        public void removeTokenAt(int idx) {
            this.data.removeElementAt(idx);
        }

        public void removeLastToken() {
            this.data.removeElementAt(this.data.size() - 1);
        }

        public void getTokens(int beg, int end, Token[] dst, int offset) {
            while (beg < end) {
                dst[offset++] = this.tokenAt(beg++);
            }
        }

        public TokenList toTokenList() {
            if (this.length() == 0) {
                return EMPTY;
            }
            Object[] tokens = new Token[this.length()];
            this.data.copyInto(tokens);
            return new TokenList((Token[])tokens);
        }

        public void addOn(Log log) {
            this.toTokenList().addOn(log);
        }

        public void addOn(Log log, int maxCount) {
            this.toTokenList().addOn(log, maxCount);
        }

        public Buffer() {
            this.data = new Vector();
        }

        public Buffer(int initCap) {
            this.data = new Vector(initCap);
        }

        public Buffer(int initCap, int capIncrement) {
            this.data = new Vector(initCap, capIncrement);
        }
    }

    public static interface Provider {
        public TokenList getToksValue();
    }

    public static interface Maintainer
    extends Provider {
        public void setToksValue(TokenList var1);

        public boolean isEmpty();
    }

    public static interface Inserter {
        public void insertToks();

        public boolean isEmpty();
    }
}

