/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableReader;
import writer2latex.util.Misc;

public class TableFormatter
extends ConverterHelper {
    private TableReader table;
    private char[][] cAlign;
    private char[] cGlobalAlign;
    private boolean[][] bHBorder;
    private boolean[][] bVBorder;
    private boolean[] bGlobalVBorder;
    private String[] sRowColor;
    private String[][] sCellColor;
    private String[] sColumnWidth;
    private boolean bIsLongtable;
    private boolean bIsSupertabular;
    private boolean bIsTabulary;
    private boolean bIsColortbl;
    private boolean bIsSimple;

    public TableFormatter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette, TableReader table, boolean bAllowPageBreak, boolean bIsInTable) {
        super(ofr, config, palette);
        int nCol;
        int nRow;
        StyleWithProperties style;
        int nCol2;
        this.table = table;
        int nRowCount = table.getRowCount();
        int nColCount = table.getColCount();
        int nSimpleTableLimit = config.getSimpleTableLimit();
        this.bIsSimple = true;
        this.cAlign = new char[nRowCount][nColCount];
        this.cGlobalAlign = new char[nColCount];
        int[] nPendingChars = new int[nRowCount];
        int[] nPendingColSpan = new int[nRowCount];
        int nTableWidth = 0;
        for (nCol2 = 0; nCol2 < nColCount; ++nCol2) {
            int nRow2;
            for (int nRow3 = 0; nRow3 < nRowCount; ++nRow3) {
                Element cell = table.getCell(nRow3, nCol2);
                if (cell == null || !Misc.isElement(cell, "table:table-cell")) continue;
                if (OfficeReader.isSingleParagraph(cell)) {
                    Element par = Misc.getChildByTagName(cell, "text:p");
                    style = ofr.getParStyle(Misc.getAttribute((Node)par, "text:style-name"));
                    this.cAlign[nRow3][nCol2] = 108;
                    if (style != null) {
                        String sAlign = style.getProperty("fo:text-align", true);
                        if ("center".equals(sAlign)) {
                            this.cAlign[nRow3][nCol2] = 99;
                        } else if ("end".equals(sAlign)) {
                            this.cAlign[nRow3][nCol2] = 114;
                        }
                    }
                } else {
                    this.bIsSimple = false;
                }
                nPendingChars[nRow3] = OfficeReader.getCharacterCount(cell);
                nPendingColSpan[nRow3] = Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1);
            }
            int nColChars = 0;
            for (nRow2 = 0; nRow2 < nRowCount; ++nRow2) {
                if (nPendingColSpan[nRow2] != 1) continue;
                nColChars = Math.max(nColChars, nPendingChars[nRow2]);
            }
            nTableWidth += nColChars;
            for (nRow2 = 0; nRow2 < nRowCount; ++nRow2) {
                if (nPendingColSpan[nRow2] < 1) continue;
                nPendingChars[nRow2] = Math.max(0, nPendingChars[nRow2] - nColChars);
                int n = nRow2;
                nPendingColSpan[n] = nPendingColSpan[n] - 1;
            }
        }
        if (nTableWidth > nSimpleTableLimit) {
            this.bIsSimple = false;
        }
        for (nCol2 = 0; nCol2 < nColCount; ++nCol2) {
            int nCenter = 0;
            int nRight = 0;
            for (int nRow4 = 0; nRow4 < nRowCount; ++nRow4) {
                if (this.cAlign[nRow4][nCol2] == 'c') {
                    ++nCenter;
                    continue;
                }
                if (this.cAlign[nRow4][nCol2] != 'r') continue;
                ++nRight;
            }
            this.cGlobalAlign[nCol2] = 108;
            int nLeft = nColCount - nCenter - nRight;
            if (nCenter > nLeft) {
                if (nRight > nLeft) {
                    this.cGlobalAlign[nCol2] = 114;
                    continue;
                }
                this.cGlobalAlign[nCol2] = 99;
                continue;
            }
            if (nRight <= nLeft) continue;
            this.cGlobalAlign[nCol2] = 114;
        }
        this.bHBorder = new boolean[nRowCount + 1][nColCount];
        for (nRow = 0; nRow <= nRowCount; ++nRow) {
            for (nCol = 0; nCol < nColCount; ++nCol) {
                this.bHBorder[nRow][nCol] = false;
            }
        }
        this.bVBorder = new boolean[nRowCount][nColCount + 1];
        for (nRow = 0; nRow < nRowCount; ++nRow) {
            for (nCol = 0; nCol <= nColCount; ++nCol) {
                this.bVBorder[nRow][nCol] = false;
            }
        }
        for (nRow = 0; nRow < nRowCount; ++nRow) {
            nCol = 0;
            while (nCol < nColCount) {
                Element cell = table.getCell(nRow, nCol);
                if (cell != null) {
                    String sStyleName = Misc.getAttribute((Node)cell, "table:style-name");
                    style = ofr.getCellStyle(sStyleName);
                    int nColSpan = Misc.getPosInteger(Misc.getAttribute((Node)cell, "table:number-columns-spanned"), 1);
                    boolean bLeft = false;
                    boolean bRight = false;
                    boolean bTop = false;
                    boolean bBottom = false;
                    if (style != null) {
                        String sBorder = style.getProperty("fo:border");
                        if (sBorder != null && !"none".equals(sBorder)) {
                            bLeft = true;
                            bRight = true;
                            bTop = true;
                            bBottom = true;
                        }
                        if ((sBorder = style.getProperty("fo:border-left")) != null && !"none".equals(sBorder)) {
                            bLeft = true;
                        }
                        if ((sBorder = style.getProperty("fo:border-right")) != null && !"none".equals(sBorder)) {
                            bRight = true;
                        }
                        if ((sBorder = style.getProperty("fo:border-top")) != null && !"none".equals(sBorder)) {
                            bTop = true;
                        }
                        if ((sBorder = style.getProperty("fo:border-bottom")) != null && !"none".equals(sBorder)) {
                            bBottom = true;
                        }
                    }
                    boolean[] blArray = this.bVBorder[nRow];
                    int n = nCol;
                    blArray[n] = blArray[n] | bLeft;
                    boolean[] blArray2 = this.bVBorder[nRow];
                    int n2 = nCol + nColSpan;
                    blArray2[n2] = blArray2[n2] | bRight;
                    do {
                        boolean[] blArray3 = this.bHBorder[nRow];
                        int n3 = nCol;
                        blArray3[n3] = blArray3[n3] | bTop;
                        boolean[] blArray4 = this.bHBorder[nRow + 1];
                        int n4 = nCol++;
                        blArray4[n4] = blArray4[n4] | bBottom;
                    } while (--nColSpan > 0);
                    continue;
                }
                ++nCol;
            }
        }
        this.bGlobalVBorder = new boolean[nColCount + 1];
        for (nCol2 = 0; nCol2 <= nColCount; ++nCol2) {
            int nBalance = 0;
            for (int nRow5 = 0; nRow5 < nRowCount; ++nRow5) {
                nBalance += this.bVBorder[nRow5][nCol2] ? 1 : -1;
            }
            this.bGlobalVBorder[nCol2] = nBalance > 0;
        }
        this.sRowColor = new String[nRowCount];
        this.sCellColor = new String[nRowCount][nColCount];
        if (config.useColortbl()) {
            int nRow6;
            String sTableColor = null;
            StyleWithProperties tableStyle = ofr.getTableStyle(table.getTableStyleName());
            if (tableStyle != null) {
                sTableColor = tableStyle.getProperty("fo:background-color");
            }
            for (nRow6 = 0; nRow6 < nRowCount; ++nRow6) {
                StyleWithProperties rowStyle = ofr.getRowStyle(table.getRow(nRow6).getStyleName());
                if (rowStyle != null) {
                    this.sRowColor[nRow6] = rowStyle.getProperty("fo:background-color");
                }
                if (this.sRowColor[nRow6] == null) {
                    this.sRowColor[nRow6] = sTableColor;
                }
                if (this.sRowColor[nRow6] == null) continue;
                this.bIsColortbl = true;
            }
            for (nRow6 = 0; nRow6 < nRowCount; ++nRow6) {
                for (int nCol3 = 0; nCol3 < nColCount; ++nCol3) {
                    StyleWithProperties cellStyle = ofr.getCellStyle(Misc.getAttribute(table.getCell(nRow6, nCol3), "table:style-name"));
                    if (cellStyle == null) continue;
                    this.sCellColor[nRow6][nCol3] = cellStyle.getProperty("fo:background-color");
                    if (this.sCellColor[nRow6][nCol3] == null) continue;
                    this.bIsColortbl = true;
                    if (!this.sCellColor[nRow6][nCol3].equals(this.sRowColor[nRow6])) continue;
                    this.sCellColor[nRow6][nCol3] = null;
                }
            }
        }
        this.sColumnWidth = new String[nColCount];
        for (int nCol4 = 0; nCol4 < nColCount; ++nCol4) {
            StyleWithProperties colStyle = ofr.getColumnStyle(table.getCol(nCol4).getStyleName());
            if (colStyle != null) {
                this.sColumnWidth[nCol4] = colStyle.getProperty("style:column-width");
            }
            if (this.sColumnWidth[nCol4] != null) continue;
            this.sColumnWidth[nCol4] = "2cm";
        }
        this.bIsLongtable = false;
        this.bIsSupertabular = false;
        this.bIsTabulary = false;
        if (!table.isSubTable() && !bIsInTable) {
            boolean bMayBreak;
            String sStyleName = table.getTableStyleName();
            StyleWithProperties style2 = ofr.getTableStyle(sStyleName);
            boolean bl = bMayBreak = style2 == null || !"false".equals(style2.getProperty("style:may-break-between-rows"));
            if (config.useLongtable() && bMayBreak && bAllowPageBreak) {
                this.bIsLongtable = true;
            } else if (config.useSupertabular() && bMayBreak && bAllowPageBreak) {
                this.bIsSupertabular = true;
            } else if (!this.bIsSimple && config.useTabulary()) {
                this.bIsTabulary = true;
            }
        }
    }

    public boolean isLongtable() {
        return this.bIsLongtable;
    }

    public boolean isSupertabular() {
        return this.bIsSupertabular;
    }

    public boolean isTabulary() {
        return this.bIsTabulary;
    }

    public boolean isColortbl() {
        return this.bIsColortbl;
    }

    public boolean isSimple() {
        return this.bIsSimple;
    }

    public void applyTableStyle(BeforeAfter ba, BeforeAfter baAlign, boolean bInFloat) {
        String sStyleName = this.table.getTableStyleName();
        StyleWithProperties style = this.ofr.getTableStyle(sStyleName);
        char cAlign = 'c';
        if (style != null && !this.table.isSubTable()) {
            String s = style.getProperty("table:align");
            if ("left".equals(s)) {
                cAlign = 'l';
            } else if ("right".equals(s)) {
                cAlign = 'r';
            }
        }
        String sAlign = "center";
        switch (cAlign) {
            case 'c': {
                sAlign = "center";
                break;
            }
            case 'r': {
                sAlign = "flushright";
                break;
            }
            case 'l': {
                sAlign = "flushleft";
            }
        }
        if (!this.bIsLongtable && !this.table.isSubTable()) {
            if (bInFloat & !this.bIsSupertabular) {
                switch (cAlign) {
                    case 'c': {
                        baAlign.add("\\centering\n", "");
                        break;
                    }
                    case 'r': {
                        baAlign.add("\\raggedleft\n", "");
                        break;
                    }
                    case 'l': {
                        baAlign.add("\\raggedright\n", "");
                    }
                }
            } else {
                baAlign.add("\\begin{" + sAlign + "}\n", "\\end{" + sAlign + "}\n");
            }
        }
        if (this.bIsLongtable) {
            ba.add("\\begin{longtable}[" + cAlign + "]", "\\end{longtable}");
        } else if (this.bIsSupertabular) {
            ba.add("\\begin{supertabular}", "\\end{supertabular}");
        } else if (this.bIsTabulary) {
            ba.add("\\begin{tabulary}{" + this.table.getTableWidth() + "}", "\\end{tabulary}");
        } else if (!this.table.isSubTable()) {
            ba.add("\\begin{tabular}", "\\end{tabular}");
        } else {
            ba.add("\\hspace*{-\\tabcolsep}\\begin{tabular}", "\\end{tabular}\\hspace*{-\\tabcolsep}");
        }
        ba.add("{", "");
        if (this.bGlobalVBorder[0]) {
            ba.add("|", "");
        }
        int nColCount = this.table.getColCount();
        for (int nCol = 0; nCol < nColCount; ++nCol) {
            if (this.bIsSimple) {
                ba.add(Character.toString(this.cGlobalAlign[nCol]), "");
            } else if (!this.bIsTabulary) {
                ba.add("m{" + Misc.add(this.sColumnWidth[nCol], "-0.2cm") + "}", "");
            } else {
                ba.add("J", "");
            }
            if (!this.bGlobalVBorder[nCol + 1]) continue;
            ba.add("|", "");
        }
        ba.add("}", "");
    }

    public String getInterrowMaterial(int nRow) {
        int nColCount = this.table.getColCount();
        int nCount = 0;
        for (int nCol = 0; nCol < nColCount; ++nCol) {
            if (!this.bHBorder[nRow][nCol]) continue;
            ++nCount;
        }
        if (nCount == 0) {
            return "";
        }
        if (nCount == nColCount) {
            return "\\hline";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\\hhline{");
        for (int nCol = 0; nCol < nColCount; ++nCol) {
            if (this.bHBorder[nRow][nCol]) {
                buf.append("-");
                continue;
            }
            buf.append("~");
        }
        buf.append("}");
        return buf.toString();
    }

    public void applyRowStyle(int nRow, BeforeAfter ba, Context context) {
        this.palette.getColorCv().applyBgColor("\\rowcolor", this.sRowColor[nRow], ba, context);
    }

    public void applyCellStyle(int nRow, int nCol, BeforeAfter ba, Context context) {
        Element cell = this.table.getCell(nRow, nCol);
        int nColSpan = Misc.getPosInteger(Misc.getAttribute((Node)cell, "table:number-columns-spanned"), 1);
        boolean bNeedLeft = nCol == 0 && this.bVBorder[nRow][0] != this.bGlobalVBorder[0];
        boolean bNeedRight = this.bVBorder[nRow][nCol + 1] != this.bGlobalVBorder[nCol + 1];
        boolean bNeedAlign = this.bIsSimple && this.cGlobalAlign[nCol] != this.cAlign[nRow][nCol];
        String sTotalColumnWidth = this.sColumnWidth[nCol];
        for (int i = nCol + 1; i < nCol + nColSpan; ++i) {
            sTotalColumnWidth = Misc.add(sTotalColumnWidth, this.sColumnWidth[i]);
        }
        sTotalColumnWidth = Misc.add(sTotalColumnWidth, "-0.2cm");
        if (bNeedAlign || bNeedLeft || bNeedRight || nColSpan > 1) {
            ba.add("\\multicolumn{" + nColSpan + "}{", "");
            if (nCol == 0 && this.bVBorder[nRow][0]) {
                ba.add("|", "");
            }
            if (this.bIsSimple) {
                ba.add(Character.toString(this.cAlign[nRow][nCol]), "");
            } else {
                ba.add("m{" + sTotalColumnWidth + "}", "");
            }
            if (this.bVBorder[nRow][nCol + nColSpan]) {
                ba.add("|", "");
            }
            ba.add("}{", "}");
        }
        this.palette.getColorCv().applyBgColor("\\cellcolor", this.sCellColor[nRow][nCol], ba, context);
    }
}

