/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.i18n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyglossia {
    private static Map<String, String> languageMap = new HashMap<String, String>();
    private static Map<String, String> variantMap;
    private Set<String> languages = new HashSet<String>();
    private List<String> declarations = new ArrayList<String>();
    private Map<String, String[]> commands = new HashMap<String, String[]>();

    private static String getEntry(Map<String, String> map, String sLocale, String sLang) {
        if (map.containsKey(sLocale)) {
            return map.get(sLocale);
        }
        if (map.containsKey(sLang)) {
            return map.get(sLang);
        }
        return null;
    }

    public String[] getDeclarations() {
        return this.declarations.toArray(new String[this.declarations.size()]);
    }

    public String[] applyLanguage(String sLang, String sCountry) {
        String sLocale;
        String string = sLocale = sCountry != null ? sLang + "-" + sCountry : sLang;
        if (this.commands.containsKey(sLocale)) {
            return this.commands.get(sLocale);
        }
        String sPolyLang = Polyglossia.getEntry(languageMap, sLocale, sLang);
        if (sPolyLang != null) {
            String sVariant = Polyglossia.getEntry(variantMap, sLocale, sLang);
            sVariant = sVariant != null ? "[variant=" + sVariant + "]" : "";
            if (this.languages.size() == 0) {
                this.declarations.add("\\usepackage{polyglossia}");
                this.declarations.add("\\setdefaultlanguage" + sVariant + "{" + sPolyLang + "}");
                this.languages.add(sPolyLang);
                sVariant = "";
            } else if (!this.languages.contains(sPolyLang)) {
                this.declarations.add("\\setotherlanguage" + sVariant + "{" + sPolyLang + "}");
                this.languages.add(sPolyLang);
                sVariant = "";
            }
            String[] sCommand = new String[3];
            sCommand[0] = "\\text" + sPolyLang + sVariant;
            if ("arabic".equals(sPolyLang)) {
                sPolyLang = "Arabic";
            }
            sCommand[1] = "\\begin{" + sPolyLang + "}" + sVariant;
            sCommand[2] = "\\end{" + sPolyLang + "}";
            this.commands.put(sLocale, sCommand);
            return sCommand;
        }
        String[] sCommand = new String[]{"", "", ""};
        this.commands.put(sLocale, sCommand);
        return sCommand;
    }

    static {
        languageMap.put("am", "amharic");
        languageMap.put("ar", "arabic");
        languageMap.put("ast", "asturian");
        languageMap.put("bg", "bulgarian");
        languageMap.put("bn", "bengali");
        languageMap.put("br", "breton");
        languageMap.put("ca", "catalan");
        languageMap.put("cop", "coptic");
        languageMap.put("cs", "czech");
        languageMap.put("cy", "welsh");
        languageMap.put("da", "danish");
        languageMap.put("de", "german");
        languageMap.put("dsb", "lsorbian");
        languageMap.put("dv", "divehi");
        languageMap.put("el", "greek");
        languageMap.put("en", "english");
        languageMap.put("eo", "esperanto");
        languageMap.put("es", "spanish");
        languageMap.put("et", "estonian");
        languageMap.put("eu", "basque");
        languageMap.put("fa", "farsi");
        languageMap.put("fi", "finnish");
        languageMap.put("fr", "french");
        languageMap.put("ga", "irish");
        languageMap.put("gd", "scottish");
        languageMap.put("gl", "galician");
        languageMap.put("grc", "greek");
        languageMap.put("he", "hebrew");
        languageMap.put("hi", "hindi");
        languageMap.put("hr", "croatian");
        languageMap.put("hsb", "usorbian");
        languageMap.put("hu", "magyar");
        languageMap.put("hy", "armenian");
        languageMap.put("id", "bahasai");
        languageMap.put("ie", "interlingua");
        languageMap.put("is", "icelandic");
        languageMap.put("it", "italian");
        languageMap.put("la", "latin");
        languageMap.put("lo", "lao");
        languageMap.put("lt", "lithuanian");
        languageMap.put("lv", "latvian");
        languageMap.put("ml", "malayalam");
        languageMap.put("mr", "marathi");
        languageMap.put("ms", "bahasam");
        languageMap.put("nb", "norsk");
        languageMap.put("nl", "dutch");
        languageMap.put("nn", "nynorsk");
        languageMap.put("oc", "occitan");
        languageMap.put("pl", "polish");
        languageMap.put("pt", "portuges");
        languageMap.put("pt-BR", "brazilian");
        languageMap.put("ro", "romanian");
        languageMap.put("ru", "russian");
        languageMap.put("sa", "sanskrit");
        languageMap.put("sk", "slovak");
        languageMap.put("sl", "slovenian");
        languageMap.put("sq", "albanian");
        languageMap.put("sr", "serbian");
        languageMap.put("sv", "swedish");
        languageMap.put("syr", "syriac");
        languageMap.put("ta", "tamil");
        languageMap.put("te", "telugu");
        languageMap.put("th", "thai");
        languageMap.put("tk", "turkmen");
        languageMap.put("tr", "turkish");
        languageMap.put("uk", "ukrainian");
        languageMap.put("ur", "urdu");
        languageMap.put("vi", "vietnamese");
        variantMap = new HashMap<String, String>();
        variantMap.put("en-US", "american");
        variantMap.put("en-GB", "british");
        variantMap.put("en-AU", "australian");
        variantMap.put("en-NZ", "newzealand");
        variantMap.put("el", "monotonic");
        variantMap.put("grc", "ancient");
    }
}

