/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.JobEnvironment;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="ExecuteProcess", category="Tools", toolTipText="Execute either static or dynamic processes. Dynamic processes can have commands, arguments and working directories specified in the values of incoming string/nominal attributes in data-based or environment connections.", iconPath="weka/gui/knowledgeflow/icons/ExecuteProcess.gif")
public class ExecuteProcess
extends BaseStep {
    private static final long serialVersionUID = -9153714279540182885L;
    protected Process m_runningProcess;
    protected String m_staticExecCmd = "";
    protected String m_staticArgs = "";
    protected String m_staticWorkingDir = "";
    protected boolean m_useDynamic;
    protected boolean m_raiseAnExceptionOnCommandFailure = true;
    protected String m_fieldCmd = "";
    protected String m_fieldArgs = "";
    protected String m_fieldWorkingDir = "";
    protected int m_cmdFieldIndex = -1;
    protected int m_argsFieldIndex = -1;
    protected int m_workingDirFieldIndex = -1;
    protected StringBuffer m_stdOutbuffer;
    protected StringBuffer m_stdErrBuffer;
    protected Instances m_instanceOutHeader;
    protected boolean m_structureCheckComplete;

    public boolean getRaiseExceptionOnCommandFailure() {
        return this.m_raiseAnExceptionOnCommandFailure;
    }

    public void setRaiseExceptionOnCommandFailure(boolean raiseExceptionOnCommandFailure) {
        this.m_raiseAnExceptionOnCommandFailure = raiseExceptionOnCommandFailure;
    }

    public boolean getUseDynamic() {
        return this.m_useDynamic;
    }

    public void setUseDynamic(boolean useDynamic) {
        this.m_useDynamic = useDynamic;
    }

    public String getStaticCmd() {
        return this.m_staticExecCmd;
    }

    public void setStaticCmd(String cmd) {
        this.m_staticExecCmd = cmd;
    }

    public String getStaticArgs() {
        return this.m_staticArgs;
    }

    public void setStaticArgs(String args) {
        this.m_staticArgs = args;
    }

    public String getStaticWorkingDir() {
        return this.m_staticWorkingDir;
    }

    public void setStaticWorkingDir(String workingDir) {
        this.m_staticWorkingDir = workingDir;
    }

    public String getDynamicCmdField() {
        return this.m_fieldCmd;
    }

    public void setDynamicCmdField(String cmdField) {
        this.m_fieldCmd = cmdField;
    }

    public String getDynamicArgsField() {
        return this.m_fieldArgs;
    }

    public void setDynamicArgsField(String argsField) {
        this.m_fieldArgs = argsField;
    }

    public String getDynamicWorkingDirField() {
        return this.m_fieldWorkingDir;
    }

    public void setDynamicWorkingDirField(String workingDirField) {
        this.m_fieldWorkingDir = workingDirField;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_runningProcess = null;
        this.m_structureCheckComplete = false;
        Environment currentEnv = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        if (currentEnv != null && !(currentEnv instanceof JobEnvironment)) {
            currentEnv = new JobEnvironment(currentEnv);
            this.getStepManager().getExecutionEnvironment().setEnvironmentVariables(currentEnv);
        }
        if (!this.m_useDynamic && this.m_staticExecCmd.length() == 0) {
            throw new WekaException("No command to execute specified!");
        }
        if (this.m_useDynamic) {
            if (this.m_fieldCmd.length() == 0) {
                throw new WekaException("No incoming attribute specified for obtaining command to execute!");
            }
            if (this.getStepManager().numIncomingConnections() == 0) {
                throw new WekaException("Dynamic command to execute specified, but there are no incoming connections!");
            }
            if (this.getStepManager().numIncomingConnectionsOfType("instance") == 0 && this.getStepManager().numIncomingConnectionsOfType("environment") == 0 && this.getStepManager().numIncomingConnectionsOfType("dataSet") == 0 && this.getStepManager().numIncomingConnectionsOfType("trainingSet") == 0 && this.getStepManager().numIncomingConnectionsOfType("testSet") == 0) {
                throw new WekaException("Dynamic command execution can only be executed on incoming instance, environment, dataset, trainingset or testset connections");
            }
        }
        if (this.getStepManager().numOutgoingConnectionsOfType("instance") > 0 || this.getStepManager().numOutgoingConnectionsOfType("environment") > 0) {
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("ExitStatus"));
            atts.add(new Attribute("StdOut", (List<String>)null));
            atts.add(new Attribute("StdErr", (List<String>)null));
            this.m_instanceOutHeader = new Instances("ProcessResults", atts, 0);
        }
    }

    @Override
    public void start() throws WekaException {
        if (this.getStepManager().numIncomingConnections() == 0) {
            try {
                ProcessBuilder builder = this.makeStaticProcess();
                this.getStepManager().processing();
                this.runProcess(builder, null, null, null);
            }
            catch (Exception e) {
                throw new WekaException(e);
            }
            finally {
                this.getStepManager().finished();
            }
        }
    }

    protected ProcessBuilder makeStaticProcess() throws Exception {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.environmentSubstitute(this.m_staticExecCmd));
        String[] args = Utils.splitOptions(this.environmentSubstitute(this.m_staticArgs));
        cmdList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(cmdList.toArray(new String[cmdList.size()]));
        if (this.m_staticWorkingDir.length() > 0) {
            builder.directory(new File(this.environmentSubstitute(this.m_staticWorkingDir)));
        }
        return builder;
    }

    protected ProcessBuilder makeDynamicProcess(Instance incoming) throws Exception {
        if (!incoming.isMissing(this.m_cmdFieldIndex)) {
            String dynamicCommandVal = this.environmentSubstitute(incoming.stringValue(this.m_cmdFieldIndex));
            String dynamicOpts = "";
            String dynamicWorkingDir = "";
            if (this.m_argsFieldIndex >= 0 && !incoming.isMissing(this.m_argsFieldIndex)) {
                dynamicOpts = this.environmentSubstitute(incoming.stringValue(this.m_argsFieldIndex));
            }
            if (this.m_workingDirFieldIndex >= 0 && !incoming.isMissing(this.m_workingDirFieldIndex)) {
                dynamicWorkingDir = this.environmentSubstitute(incoming.stringValue(this.m_workingDirFieldIndex));
            }
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(dynamicCommandVal);
            String[] args = Utils.splitOptions(dynamicOpts);
            cmdList.addAll(Arrays.asList(args));
            ProcessBuilder builder = new ProcessBuilder(cmdList.toArray(new String[cmdList.size()]));
            if (dynamicWorkingDir.length() > 0) {
                builder.directory(new File(dynamicWorkingDir));
            }
            return builder;
        }
        this.getStepManager().logWarning("Value of command to execute is missing in incoming instance");
        return null;
    }

    protected void runProcess(ProcessBuilder builder, Map<String, String> varsToSet, Map<String, Map<String, String>> propsToSet, Map<String, LinkedHashSet<Data>> results) throws IOException, InterruptedException, WekaException {
        Map<String, String> env = builder.environment();
        Environment flowEnv = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        if (flowEnv != null) {
            Set<String> vars = flowEnv.getVariableNames();
            for (String var : vars) {
                env.put(var, flowEnv.getVariableValue(var));
            }
        }
        StringWriter stdOutWriter = new StringWriter();
        StringWriter stdErrWriter = new StringWriter();
        try {
            this.m_stdOutbuffer = new StringBuffer();
            this.m_stdErrBuffer = new StringBuffer();
            this.m_runningProcess = builder.start();
            ExecuteProcess.copy(this.m_runningProcess.getInputStream(), stdOutWriter);
            ExecuteProcess.copy(this.m_runningProcess.getErrorStream(), stdErrWriter);
            int status = this.m_runningProcess.waitFor();
            this.m_stdOutbuffer = stdOutWriter.getBuffer();
            this.m_stdErrBuffer = stdErrWriter.getBuffer();
            if (status == 0) {
                this.handleOutputSuccess(varsToSet, propsToSet, results, Utils.joinOptions(builder.command().toArray(new String[0])));
            } else {
                this.handleOutputFailure(status, varsToSet, propsToSet, results, Utils.joinOptions(builder.command().toArray(new String[0])));
            }
        }
        catch (IOException ex) {
            if (this.m_raiseAnExceptionOnCommandFailure) {
                throw ex;
            }
            this.getStepManager().logWarning("Command: " + Utils.joinOptions(builder.command().toArray(new String[0])) + " failed with exception:\n" + LogManager.stackTraceToString(ex));
            this.handleOutputFailure(1, varsToSet, propsToSet, results, Utils.joinOptions(builder.command().toArray(new String[0])));
        }
    }

    protected void handleOutputSuccess(Map<String, String> varsToSet, Map<String, Map<String, String>> propsToSet, Map<String, LinkedHashSet<Data>> results, String command) throws WekaException {
        if (this.getStepManager().numOutgoingConnectionsOfType("jobSuccess") > 0) {
            Data success = new Data("jobSuccess", this.m_stdOutbuffer.length() > 0 ? this.m_stdOutbuffer.toString() : "Process completed successfully: " + command);
            success.setPayloadElement("incremental_stream", true);
            this.addAuxToData(success, varsToSet, propsToSet, results);
            this.getStepManager().outputData(success);
        }
        if (this.getStepManager().numOutgoingConnectionsOfType("instance") > 0) {
            this.m_instanceOutHeader.attribute(1).setStringValue(this.m_stdOutbuffer.length() > 0 ? this.m_stdOutbuffer.toString() : "Process completed successfully");
            this.m_instanceOutHeader.attribute(2).setStringValue(this.m_stdErrBuffer.length() > 0 ? this.m_stdErrBuffer.toString() : "");
            double[] vals = new double[3];
            vals[0] = 0.0;
            DenseInstance outputInst = new DenseInstance(1.0, vals);
            outputInst.setDataset(this.m_instanceOutHeader);
            Data instOut = new Data("instance", outputInst);
            this.getStepManager().outputData(instOut);
        }
        if (this.getStepManager().numOutgoingConnectionsOfType("text") > 0) {
            Data textOut = new Data("text", this.m_stdOutbuffer.toString());
            textOut.setPayloadElement("aux_textTitle", "Process completed successfully: " + command);
            this.getStepManager().outputData(textOut);
        }
    }

    protected void handleOutputFailure(int returnCode, Map<String, String> varsToSet, Map<String, Map<String, String>> propsToSet, Map<String, LinkedHashSet<Data>> results, String command) throws WekaException {
        if (this.getStepManager().numOutgoingConnectionsOfType("jobFailure") > 0) {
            Data failure = new Data("jobFailure", this.m_stdErrBuffer.length() > 0 ? this.m_stdErrBuffer.toString() : "Process did not complete successfully - return code " + returnCode);
            failure.setPayloadElement("incremental_stream", true);
            this.addAuxToData(failure, varsToSet, propsToSet, results);
            this.getStepManager().outputData(failure);
        }
        if (this.getStepManager().numOutgoingConnectionsOfType("instance") > 0) {
            this.m_instanceOutHeader.attribute(1).setStringValue(this.m_stdOutbuffer.length() > 0 ? this.m_stdOutbuffer.toString() : "");
            this.m_instanceOutHeader.attribute(2).setStringValue(this.m_stdErrBuffer.length() > 0 ? this.m_stdErrBuffer.toString() : "Process did not complete successfully");
            double[] vals = new double[3];
            vals[0] = returnCode;
            DenseInstance outputInst = new DenseInstance(1.0, vals);
            outputInst.setDataset(this.m_instanceOutHeader);
            Data instOut = new Data("instance", outputInst);
            this.getStepManager().outputData(instOut);
        }
        if (this.getStepManager().numOutgoingConnectionsOfType("text") > 0) {
            Data textOut = new Data("text", this.m_stdErrBuffer.toString());
            textOut.setPayloadElement("aux_textTitle", "Process did not complete successfully: " + command);
            this.getStepManager().outputData(textOut);
        }
    }

    protected void addAuxToData(Data data, Map<String, String> varsToSet, Map<String, Map<String, String>> propsToSet, Map<String, LinkedHashSet<Data>> results) {
        if (varsToSet != null) {
            data.setPayloadElement("env_variables", varsToSet);
        }
        if (propsToSet != null) {
            data.setPayloadElement("env_properties", propsToSet);
        }
        if (results != null) {
            data.setPayloadElement("env_results", results);
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (!this.m_structureCheckComplete) {
            this.m_structureCheckComplete = true;
            Instances structure = null;
            structure = data.getConnectionName().equals("instance") ? ((Instance)data.getPrimaryPayload()).dataset() : (data.getConnectionName().equals("environment") ? ((Instance)data.getPayloadElement("aux_instance")).dataset() : (Instances)data.getPrimaryPayload());
            this.checkStructure(structure);
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
            return;
        }
        if (data.isIncremental()) {
            if (this.getStepManager().isStreamFinished(data)) {
                Data finished = new Data(data.getConnectionName());
                if (data.getConnectionName().equals("environment") || data.getConnectionName().equals("jobSuccess") || data.getConnectionName().equals("jobFailure")) {
                    finished.setPayloadElement("env_variables", data.getPayloadElement("env_variables"));
                    finished.setPayloadElement("env_properties", data.getPayloadElement("env_properties"));
                }
                if (data.getConnectionName().equals("jobSuccess") || data.getConnectionName().equals("jobFailure")) {
                    finished.setPayloadElement("env_results", data.getPayloadElement("env_results"));
                }
                this.getStepManager().throughputFinished(finished);
                return;
            }
            Map envVars = (Map)data.getPayloadElement("env_variables");
            Map propsToSet = (Map)data.getPayloadElement("env_properties");
            Map results = (Map)data.getPayloadElement("env_results");
            if (!this.m_useDynamic) {
                this.getStepManager().throughputUpdateStart();
                try {
                    ProcessBuilder builder = this.makeStaticProcess();
                    this.runProcess(builder, envVars, propsToSet, results);
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
                this.getStepManager().throughputUpdateEnd();
            } else if (data.getConnectionName().equals("instance") || data.getConnectionName().equals("environment")) {
                Instance toProcess = (Instance)(data.getConnectionName().equals("instance") ? data.getPrimaryPayload() : data.getPayloadElement("aux_instance"));
                this.getStepManager().throughputUpdateStart();
                try {
                    ProcessBuilder builder = this.makeDynamicProcess(toProcess);
                    this.runProcess(builder, envVars, propsToSet, results);
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
                this.getStepManager().throughputUpdateEnd();
            }
        } else {
            this.getStepManager().processing();
            Instances toProcess = (Instances)data.getPrimaryPayload();
            for (Instance inst : toProcess) {
                try {
                    if (this.isStopRequested()) {
                        this.getStepManager().interrupted();
                        return;
                    }
                    ProcessBuilder builder = this.makeDynamicProcess(inst);
                    this.runProcess(builder, null, null, null);
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
            if (this.getStepManager().numOutgoingConnectionsOfType("instance") > 0) {
                Data finished = new Data("instance");
                this.getStepManager().throughputFinished(finished);
            }
            this.getStepManager().finished();
        }
    }

    protected void checkStructure(Instances structure) throws WekaException {
        Attribute cmdAtt = structure.attribute(this.m_fieldCmd);
        if (cmdAtt == null) {
            throw new WekaException("Unable to find attribute (" + this.m_fieldCmd + ") holding command to execute in the incoming instance structure");
        }
        this.m_cmdFieldIndex = cmdAtt.index();
        if (this.m_fieldArgs != null && this.m_fieldArgs.length() > 0) {
            Attribute argsAtt = structure.attribute(this.m_fieldArgs);
            if (argsAtt == null) {
                throw new WekaException("Unable to find attribute (" + this.m_fieldArgs + ") holding command args in the incoming instance structure");
            }
            this.m_argsFieldIndex = argsAtt.index();
        }
        if (this.m_fieldWorkingDir != null && this.m_fieldWorkingDir.length() > 0) {
            Attribute workingAtt = structure.attribute(this.m_fieldWorkingDir);
            if (workingAtt == null) {
                throw new WekaException("Unable to find attribute (" + this.m_fieldWorkingDir + ") holding the working directory in the incoming instance stream");
            }
            this.m_workingDirFieldIndex = workingAtt.index();
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("instance", "dataSet", "trainingSet", "testSet", "environment", "jobSuccess", "jobFailure");
        }
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return Arrays.asList("instance", "jobSuccess", "jobFailure", "text");
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().numIncomingConnections() == 0 || !connectionName.equals("instance") && !connectionName.equals("environment")) {
            return null;
        }
        return this.getStepManager().getIncomingStructureForConnectionType(connectionName);
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.ExecuteProcessStepEditorDialog";
    }

    protected static void copy(InputStream input, Writer out) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        int n = 0;
        char[] buffer = new char[4096];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
    }
}

