## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----message = FALSE----------------------------------------------------------
library(SeedMaker)
library(dplyr)
library(tibble)
library(tidyr)
library(rlang)

n_sims <- 5
n_subjects <- 10
mu <- 25
sigma <- 5

params <- tibble(
  n_subjects = !!n_subjects,
  mu = !!mu,
  sigma = !!sigma
)

y_gen <- function(n_subjects, mu, sigma) {
  rnorm(n_subjects, mu, sigma)
}

vsrs1 <- params %>%
  bind_cols(tibble(sim = paste0("sim", 1:!!n_sims))) %>%
  relocate(sim) %>%
  rowwise() %>%
  mutate(y = list(y_gen(!!n_subjects, !!mu, !!sigma))) %>%
  ungroup()

str(vsrs1)

## -----------------------------------------------------------------------------
vsrs1_save <- vsrs1

vsrs1 <- params %>%
  bind_cols(tibble(sim = paste0("sim", 1:!!n_sims))) %>%
  relocate(sim) %>%
  rowwise() %>%
  mutate(y = list(y_gen(!!n_subjects, !!mu, !!sigma))) %>%
  ungroup()

str(vsrs1)

identical(vsrs1_save, vsrs1)

## -----------------------------------------------------------------------------
set.seed(1234)

vsrs2 <- params %>%
  bind_cols(tibble(sim = paste0("sim", 1:!!n_sims))) %>%
  relocate(sim) %>%
  rowwise() %>%
  mutate(y = list(y_gen(!!n_subjects, !!mu, !!sigma))) %>%
  ungroup()

str(vsrs2)

## -----------------------------------------------------------------------------
vsrs2_save <- vsrs2

set.seed(1234)

vsrs2 <- params %>%
  bind_cols(tibble(sim = paste0("sim", 1:!!n_sims))) %>%
  relocate(sim) %>%
  rowwise() %>%
  mutate(y = list(y_gen(!!n_subjects, !!mu, !!sigma))) %>%
  ungroup()

str(vsrs2)

identical(vsrs2_save, vsrs2)

## -----------------------------------------------------------------------------
seeds <- seed_maker(
  seed = 1234,
  level_names = "sim",
  n_per_level = n_sims
)

print(seeds)

vsrs3 <- params %>%
  bind_cols(enframe(seeds, name = "sim", value = "seed")) %>%
  relocate(sim) %>%
  unnest("seed") %>%
  rowwise() %>%
  mutate(y = list(exec(
    .fn = function(n_subjects, mu, sigma, seed) {
      set.seed(seed)
      y_gen(n_subjects, mu, sigma)
    },
    n_subjects = .data$n_subjects,
    mu = .data$mu,
    sigma = .data$sigma,
    seed = .data$seed
  ))) %>%
  ungroup()

str(vsrs3)

## -----------------------------------------------------------------------------
set.seed(seeds[["sim5"]])

y_sim5 <- y_gen(n_subjects, mu, sigma)

print(y_sim5)

identical(
  vsrs3 %>%
    filter(sim == "sim5") %>%
    unnest(y) %>%
    pull(y),
  y_sim5
)

## -----------------------------------------------------------------------------
n_treats <- 2
mu1 <- 25
mu2 <- 35

params_complex <- tibble(
  treat_id = seq_len(!!n_treats),
  mu = c(!!mu1, !!mu2),
  sigma = rep(!!sigma, !!n_treats)
)

vsrs4 <- params_complex %>%
  nest(params = everything()) %>%
  bind_cols(enframe(seeds, name = "sim", value = "seed")) %>%
  relocate(sim) %>%
  unnest("seed") %>%
  mutate(n_subjects = !!n_subjects) %>%
  relocate(n_subjects, .after = sim) %>%
  rowwise() %>%
  mutate(y = list(exec(
    .fn = function(n_subjects, params, seed) {
      set.seed(seed)
      vsrs <-
        tibble(
          treat_id = sapply(
            seq_len(n_subjects),
            function(x) sample(params %>% pull(treat_id), 1)
          )
        ) %>%
        left_join(
          params,
          by = "treat_id"
        ) %>%
        rowwise() %>%
        mutate(y = y_gen(1, mu, sigma)) %>%
        ungroup() %>%
        mutate(replicate = paste0("replicate", row_number())) %>%
        relocate(replicate)
    },
    n_subjects = .data$n_subjects,
    params = .data$params,
    seed = .data$seed
  ))) %>%
  ungroup() %>%
  select(- params)

str(vsrs4)

## -----------------------------------------------------------------------------
set.seed(seeds[["sim5"]])

y_complex_sim5 <-
  tibble(
    treat_id = sapply(
      seq_len(!!n_subjects),
      function(x) sample(params_complex %>% pull(treat_id), 1)
    )
  ) %>%
  left_join(
    params_complex,
    by = "treat_id"
  ) %>%
  rowwise() %>%
  mutate(y = y_gen(1, mu, sigma)) %>%
  ungroup() %>%
  mutate(replicate = paste0("replicate", row_number())) %>%
  select(replicate, treat_id, y)

print(y_complex_sim5)

identical(
  vsrs4 %>%
    filter(sim == "sim5") %>%
    unnest(y) %>%
    select(replicate, treat_id, y),
  y_complex_sim5
)

## -----------------------------------------------------------------------------
seeds_complex <- seed_maker(
  seed = 1234,
  level_names = c("sim", "replicate"),
  n_per_level = c(n_sims, n_subjects)
)

str(seeds_complex)

vsrs5 <- enframe(seeds_complex, name = "sim", value = "seeds") %>%
  rowwise() %>%
  mutate(int = list(enframe(seeds, name = "replicate", value = "seed"))) %>%
  ungroup() %>%
  unnest(int) %>%
  select(- seeds) %>%
  rowwise() %>%
  mutate(y = list(exec(
    .fn = function(seed) {
      set.seed(seed)
      vsrs <-
        tibble(
          treat_id = sample(!!params_complex %>% pull(treat_id), 1)
        )  %>%
        left_join(
          !!params_complex,
          by = "treat_id"
        ) %>%
        mutate(y = y_gen(1, mu, sigma))
    },
    seed = .data$seed
  ))) %>%
  ungroup() %>%
  unnest("y") %>%
  nest(y = c("replicate", "seed", "treat_id", "mu", "sigma", "y"), .by = "sim")

str(vsrs5)

## -----------------------------------------------------------------------------
set.seed(seeds_complex[["sim5"]][["replicate10"]])

y_complex_sep_sim5 <-
  tibble(
    treat_id = sample(params_complex %>% pull(treat_id), 1)
  )  %>%
  left_join(
    params_complex,
    by = "treat_id"
  ) %>%
  mutate(y = y_gen(1, mu, sigma)) %>%
  select(treat_id, y)

print(y_complex_sep_sim5)

identical(
  vsrs5 %>%
    filter(sim == "sim5") %>%
    unnest(y) %>%
    filter(replicate == "replicate10") %>%
    select(treat_id, y),
  y_complex_sep_sim5
)

