/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class FatigueLifeDist
extends ContinuousDistribution {
    protected double mu;
    protected double beta;
    protected double gamma;

    public FatigueLifeDist(double mu, double beta, double gamma) {
        this.setParams(mu, beta, gamma);
    }

    public double density(double x) {
        return FatigueLifeDist.density(this.mu, this.beta, this.gamma, x);
    }

    public double cdf(double x) {
        return FatigueLifeDist.cdf(this.mu, this.beta, this.gamma, x);
    }

    public double barF(double x) {
        return FatigueLifeDist.barF(this.mu, this.beta, this.gamma, x);
    }

    public double inverseF(double u) {
        return FatigueLifeDist.inverseF(this.mu, this.beta, this.gamma, u);
    }

    public double getMean() {
        return FatigueLifeDist.getMean(this.mu, this.beta, this.gamma);
    }

    public double getVariance() {
        return FatigueLifeDist.getVariance(this.mu, this.beta, this.gamma);
    }

    public double getStandardDeviation() {
        return FatigueLifeDist.getStandardDeviation(this.mu, this.beta, this.gamma);
    }

    public static double density(double mu, double beta, double gamma, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (x <= mu) {
            return 0.0;
        }
        double y = (Math.sqrt((x - mu) / beta) - Math.sqrt(beta / (x - mu))) / gamma;
        return (Math.sqrt((x - mu) / beta) + Math.sqrt(beta / (x - mu))) / (2.0 * gamma * (x - mu)) * NormalDist.density(0.0, 1.0, y);
    }

    public static double cdf(double mu, double beta, double gamma, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (x <= mu) {
            return 0.0;
        }
        return NormalDist.cdf01((Math.sqrt((x - mu) / beta) - Math.sqrt(beta / (x - mu))) / gamma);
    }

    public static double barF(double mu, double beta, double gamma, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (x <= mu) {
            return 1.0;
        }
        return NormalDist.barF01((Math.sqrt((x - mu) / beta) - Math.sqrt(beta / (x - mu))) / gamma);
    }

    public static double inverseF(double mu, double beta, double gamma, double u) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return mu;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double w = gamma * NormalDist.inverseF01(u);
        double sqrtZ = 0.5 * (w + Math.sqrt(w * w + 4.0));
        return mu + sqrtZ * sqrtZ * beta;
    }

    public static double[] getMLE(double[] x, int n, double mu) {
        double sum = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[3];
        double[] xpls = new double[3];
        double[] param = new double[3];
        double[] fpls = new double[3];
        double[] gpls = new double[3];
        int[] itrcmd = new int[2];
        double[][] h = new double[3][3];
        double[] udiag = new double[3];
        Optim system = new Optim(x, n, mu);
        double mean = 0.0;
        for (int i = 0; i < n; ++i) {
            mean += x[i];
        }
        mean /= (double)n;
        double var = 0.0;
        for (int i = 0; i < n; ++i) {
            var += (x[i] - mean) * (x[i] - mean);
        }
        double loc2 = (mean - mu) * (mean - mu);
        double a = 0.25 * ((var /= (double)n) - 5.0 * loc2);
        double b = var - loc2;
        double c = var;
        double delta = b * b - 4.0 * a * c;
        double gamma2 = (-b - Math.sqrt(delta)) / (2.0 * a);
        param[2] = Math.sqrt(gamma2);
        param[1] = (mean - mu) / (1.0 + gamma2 / 2.0);
        Uncmin_f77.optif0_f77((int)2, (double[])param, (Uncmin_methods)system, (double[])xpls, (double[])fpls, (double[])gpls, (int[])itrcmd, (double[][])h, (double[])udiag);
        for (int i = 1; i < 3; ++i) {
            parameters[i] = xpls[i];
        }
        parameters[0] = mu;
        return parameters;
    }

    public static double getMean(double mu, double beta, double gamma) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return mu + beta * (1.0 + 0.5 * gamma * gamma);
    }

    public static double getVariance(double mu, double beta, double gamma) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return beta * beta * gamma * gamma * (1.0 + 1.25 * gamma * gamma);
    }

    public static double getStandardDeviation(double mu, double beta, double gamma) {
        return Math.sqrt(FatigueLifeDist.getVariance(mu, beta, gamma));
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getMu() {
        return this.mu;
    }

    public void setParams(double mu, double beta, double gamma) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        this.mu = mu;
        this.beta = beta;
        this.gamma = gamma;
        this.supportA = mu;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.beta, this.gamma};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : mu = " + this.mu + ", beta = " + this.beta + ", gamma = " + this.gamma;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;
        private double mu;

        public Optim(double[] x, int n, double min) {
            this.n = n;
            this.mu = min;
            this.xi = new double[n];
            System.arraycopy(x, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] p) {
            double sum = 0.0;
            if (p[1] <= 0.0 || p[2] <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                sum -= Math.log(FatigueLifeDist.density(this.mu, p[1], p[2], this.xi[i]));
            }
            return sum;
        }

        public void gradient(double[] x, double[] g) {
        }

        public void hessian(double[] x, double[][] h) {
        }
    }
}

