/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import java.util.Arrays;

public class StatisticUtils {
    public static int sum(int ... values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static long sum(long ... values) {
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double sum(double ... values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double mean(int ... values) {
        return StatisticUtils.sum(values) / values.length;
    }

    public static float mean(long ... values) {
        return StatisticUtils.sum(values) / (long)values.length;
    }

    public static double mean(double ... values) {
        return StatisticUtils.sum(values) / (double)values.length;
    }

    public static double standarddeviation(int ... values) {
        double mean = StatisticUtils.mean(values);
        double[] psd = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            psd[i] = Math.pow((double)values[i] - mean, 2.0);
        }
        return Math.sqrt(StatisticUtils.mean(psd));
    }

    public static double standarddeviation(long ... values) {
        double mean = StatisticUtils.mean(values);
        double[] psd = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            psd[i] = Math.pow((double)values[i] - mean, 2.0);
        }
        return Math.sqrt(StatisticUtils.mean(psd));
    }

    public static int[] prepare(int ... values) {
        Arrays.sort(values);
        int[] back = new int[values.length - 2];
        System.arraycopy(values, 1, back, 0, back.length);
        return back;
    }

    public static long[] prepare(long ... values) {
        Arrays.sort(values);
        long[] back = new long[values.length - 2];
        System.arraycopy(values, 1, back, 0, back.length);
        return back;
    }
}

