/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.algo;

import java.util.BitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffAC;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class AlgoAllDiffACFast
extends AlgoAllDiffAC {
    private final BitSet distinction;

    public AlgoAllDiffACFast(IntVar[] variables, Propagator<IntVar> cause) {
        super(variables, cause);
        this.n = this.vars.length;
        this.distinction = new BitSet(this.n2);
    }

    @Override
    protected void makeDigraph() {
        this.digraph = new DirectedGraph(this.n2, SetType.BITSET, false);
    }

    @Override
    void distinguish() {
        this.distinction.clear();
        int indexFirst = 0;
        int indexLast = 0;
        int i = this.free.nextSetBit(this.n);
        while (i >= this.n && i < this.n2) {
            this.distinction.set(i);
            ISetIterator predece = this.digraph.getPredecessorsOf(i).iterator();
            while (predece.hasNext()) {
                int x = predece.nextInt();
                if (this.distinction.get(x)) continue;
                this.fifo[indexLast++] = x;
                this.distinction.set(x);
            }
            while (indexFirst != indexLast) {
                int y = this.fifo[indexFirst++];
                int v = this.matching[y];
                this.distinction.set(v);
                predece = this.digraph.getPredecessorsOf(v).iterator();
                while (predece.hasNext()) {
                    int x = predece.nextInt();
                    if (this.distinction.get(x)) continue;
                    this.fifo[indexLast++] = x;
                    this.distinction.set(x);
                }
            }
            i = this.free.nextSetBit(i + 1);
        }
    }

    @Override
    void buildSCC() {
        this.SCCfinder.findAllSCC(this.distinction);
        this.nodeSCC = this.SCCfinder.getNodesSCC();
    }

    @Override
    boolean filterVar(int i) throws ContradictionException {
        boolean filter = false;
        IntVar v = this.vars[i];
        if (v.getDomainSize() > 1) {
            int ub = v.getUB();
            int k = v.getLB();
            while (k <= ub) {
                int j = this.map.get(k);
                if (!this.distinction.get(j)) {
                    if (this.distinction.get(i)) {
                        filter |= v.removeValue(k, (ICause)this.aCause);
                        this.digraph.removeEdge(i, j);
                    } else {
                        filter |= this.filterVar(i, j, v, k);
                    }
                }
                k = v.nextValue(k);
            }
        }
        return filter;
    }
}

