/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramoseats.extractors;

import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovDiagnostics;
import jdplus.tramoseats.base.core.seats.SeatsTests;

public class SeatsDiagnosticsExtractor
extends InformationMapping<SeatsTests> {
    public static final String CUTOFF = "parameters_cutoff";
    public static final String CHANGED = "model_changed";
    public static final String SEAS = "seasonality";
    public static final String AR_ROOT = "ar_root";
    public static final String MA_ROOT = "ma_root";
    public static final String TVAR_ESTIMATE = "tvar-estimate";
    public static final String TVAR_ESTIMATOR = "tvar-estimator";
    public static final String TVAR_PVALUE = "tvar-pvalue";
    public static final String SAVAR_ESTIMATE = "savar-estimate";
    public static final String SAVAR_ESTIMATOR = "savar-estimator";
    public static final String SAVAR_PVALUE = "savar-pvalue";
    public static final String SVAR_ESTIMATE = "svar-estimate";
    public static final String SVAR_ESTIMATOR = "svar-estimator";
    public static final String SVAR_PVALUE = "svar-pvalue";
    public static final String IVAR_ESTIMATE = "ivar-estimate";
    public static final String IVAR_ESTIMATOR = "ivar-estimator";
    public static final String IVAR_PVALUE = "ivar-pvalue";
    public static final String SAAC1_ESTIMATE = "saac1-estimate";
    public static final String SAAC1_ESTIMATOR = "saac1-estimator";
    public static final String SAAC1_PVALUE = "saac1-pvalue";
    public static final String IAC1_ESTIMATE = "iac1-estimate";
    public static final String IAC1_ESTIMATOR = "iac1-estimator";
    public static final String IAC1_PVALUE = "iac1-pvalue";
    public static final String TICORR_ESTIMATE = "ticorr-estimate";
    public static final String TICORR_ESTIMATOR = "ticorr-estimator";
    public static final String TICORR_PVALUE = "ticorr-pvalue";
    public static final String SICORR_ESTIMATE = "sicorr-estimate";
    public static final String SICORR_ESTIMATOR = "sicorr-estimator";
    public static final String SICORR_PVALUE = "sicorr-pvalue";
    public static final String TSCORR_ESTIMATE = "tscorr-estimate";
    public static final String TSCORR_ESTIMATOR = "tscorr-estimator";
    public static final String TSCORR_PVALUE = "tscorr-pvalue";
    private static final int T_CMP = 0;
    private static final int SA_CMP = 1;
    private static final int I_CMP = 3;
    private static final int S_CMP = 2;

    public SeatsDiagnosticsExtractor() {
        this.set(CUTOFF, Boolean.class, source -> source.isParametersCutOff());
        this.set(CHANGED, Boolean.class, source -> source.isModelChanged());
        this.set(SEAS, Boolean.class, source -> !source.ucarimaModel().getComponent(1).isNull());
        this.setArray(AR_ROOT, 1, 3, Complex.class, (source, i) -> {
            Complex[] ar = source.finalModel().getRegularAR().roots();
            if (i > ar.length) {
                return null;
            }
            return ar[i - 1].inv();
        });
        this.setArray(MA_ROOT, 1, 3, Complex.class, (source, i) -> {
            Complex[] ma = source.finalModel().getRegularMA().roots();
            if (i > ma.length) {
                return null;
            }
            return ma[i - 1].inv();
        });
        this.set(TVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(0));
        });
        this.set(TVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(0));
        });
        this.set(TVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0));
        });
        this.set(SAVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(1));
        });
        this.set(SAVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(1));
        });
        this.set(SAVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(1));
        });
        this.set(SVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(2));
        });
        this.set(SVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(2));
        });
        this.set(SVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(2));
        });
        this.set(IVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(3));
        });
        this.set(IVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(3));
        });
        this.set(IVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(3));
        });
        this.set(TSCORR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorCrossCorrelation(0, 2));
        });
        this.set(TSCORR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateCrossCorrelation(0, 2));
        });
        this.set(TSCORR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0, 2));
        });
        this.set(TICORR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorCrossCorrelation(0, 3));
        });
        this.set(TICORR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateCrossCorrelation(0, 3));
        });
        this.set(TICORR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0, 3));
        });
        this.set(SICORR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorCrossCorrelation(2, 3));
        });
        this.set(SICORR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateCrossCorrelation(2, 3));
        });
        this.set(SICORR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.wkDiagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(2, 3));
        });
    }

    public Class<SeatsTests> getSourceClass() {
        return SeatsTests.class;
    }
}

