/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.featureranking;

import java.util.HashMap;
import moa.classifiers.rules.featureranking.AbstractFeatureRanking;
import moa.classifiers.rules.featureranking.messages.ChangeDetectedMessage;
import moa.classifiers.rules.featureranking.messages.RuleExpandedMessage;
import moa.classifiers.rules.multilabel.core.ObservableMOAObject;
import moa.core.DoubleVector;

public class BasicFeatureRanking
extends AbstractFeatureRanking {
    private static final long serialVersionUID = 1L;
    protected DoubleVector attributeImportance = new DoubleVector();
    protected HashMap<ObservableMOAObject, RuleInformation> ruleInformation = new HashMap();

    @Override
    public void update(ObservableMOAObject o, Object arg) {
        if (arg instanceof RuleExpandedMessage) {
            RuleInformation ri = this.ruleInformation.get(o);
            if (ri == null) {
                ri = new RuleInformation();
                this.ruleInformation.put(o, ri);
            }
            RuleExpandedMessage msg = (RuleExpandedMessage)arg;
            int index = msg.getAttributeIndex();
            if (!msg.isSpecialization()) {
                ri.addMerit(index, 1.0);
                this.attributeImportance.addToValue(index, 1.0);
            }
        } else if (arg instanceof ChangeDetectedMessage) {
            RuleInformation ri = this.ruleInformation.get(o);
            DoubleVector accumulatedMerit = ri.getAccumulatedMerit();
            this.attributeImportance.subtractValues(accumulatedMerit);
            this.ruleInformation.remove(o);
        }
    }

    @Override
    public DoubleVector getFeatureRankings() {
        if (this.attributeImportance == null) {
            return new DoubleVector();
        }
        return this.attributeImportance;
    }

    public class RuleInformation {
        private DoubleVector accumulatedMerit = new DoubleVector();

        public void addMerit(int index, double value) {
            this.accumulatedMerit.addToValue(index, value);
        }

        public DoubleVector getAccumulatedMerit() {
            return this.accumulatedMerit;
        }
    }
}

