/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.analysis;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.ohdsi.analysis.versioning.VersionedDeserializerModifier;
import org.ohdsi.analysis.versioning.VersionedSerializerModifier;

public class Utils {
    private static final Set<Module> OBJECT_MAPPER_MODULES = ConcurrentHashMap.newKeySet();
    private static HandlerInstantiator OBJECT_MAPPER_HANDLER_INSTANTIATOR = null;
    private static final Map<ObjectMapperConfig, ObjectMapper> OBJECT_MAPPER = new ConcurrentHashMap<ObjectMapperConfig, ObjectMapper>();

    public static void registerObjectMapperModule(Module module) {
        OBJECT_MAPPER_MODULES.add(module);
        OBJECT_MAPPER.clear();
    }

    public static void unregisterObjectMapperModule(Module module) {
        OBJECT_MAPPER_MODULES.remove(module);
        OBJECT_MAPPER.clear();
    }

    public static void setObjectMapperHandlerInstantiator(HandlerInstantiator instantiator) {
        OBJECT_MAPPER_HANDLER_INSTANTIATOR = instantiator;
        OBJECT_MAPPER.clear();
    }

    private static ObjectMapper getObjectMapper() {
        return Utils.getObjectMapper(ObjectMapperConfig.newInstance().withIncludeNulls(false));
    }

    private static ObjectMapper getObjectMapper(ObjectMapperConfig objectMapperConfig) {
        return OBJECT_MAPPER.computeIfAbsent(objectMapperConfig, config -> Utils.buildObjectMapper(objectMapperConfig));
    }

    private static ObjectMapper buildObjectMapper(ObjectMapperConfig config) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS, MapperFeature.AUTO_DETECT_GETTERS, MapperFeature.AUTO_DETECT_IS_GETTERS});
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        if (!config.isIncludeNulls()) {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        objectMapper.registerModule((Module)new SimpleModule().setSerializerModifier((BeanSerializerModifier)new VersionedSerializerModifier()).setDeserializerModifier((BeanDeserializerModifier)new VersionedDeserializerModifier()));
        OBJECT_MAPPER_MODULES.forEach(arg_0 -> ((ObjectMapper)objectMapper).registerModule(arg_0));
        if (OBJECT_MAPPER_HANDLER_INSTANTIATOR != null) {
            objectMapper.setHandlerInstantiator(OBJECT_MAPPER_HANDLER_INSTANTIATOR);
        }
        return objectMapper;
    }

    public static String serializePretty(Object object) throws JsonProcessingException {
        return Utils.serializePretty(object, false);
    }

    public static String serializePretty(Object object, Boolean includeNulls) throws JsonProcessingException {
        ObjectMapper objectMapper = Utils.getObjectMapper(ObjectMapperConfig.newInstance().withIncludeNulls(includeNulls));
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter(){

            public DefaultPrettyPrinter createInstance() {
                return this;
            }

            public DefaultPrettyPrinter withSeparators(Separators separators) {
                this._separators = separators;
                this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
                return this;
            }
        };
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        return objectMapper.writer((PrettyPrinter)prettyPrinter).writeValueAsString(object);
    }

    public static String serialize(Object object) {
        return Utils.serialize(object, false);
    }

    public static String serialize(Object object, Boolean includeNulls) {
        try {
            ObjectMapper objectMapper = Utils.getObjectMapper(ObjectMapperConfig.newInstance().withIncludeNulls(includeNulls));
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T deserialize(String data, TypeReference<T> typeRef) {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        if (data == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(data, typeRef);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T deserialize(String data, JavaType typeRef) {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        if (data == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(data, typeRef);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T deserialize(String data, Function<TypeFactory, JavaType> typeFunction) {
        Objects.requireNonNull(typeFunction);
        ObjectMapper objectMapper = Utils.getObjectMapper();
        JavaType type = typeFunction.apply(objectMapper.getTypeFactory());
        if (data == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(data, type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T deserialize(String data, Class<T> objectClass) {
        Objects.requireNonNull(objectClass);
        ObjectMapper objectMapper = Utils.getObjectMapper();
        if (data == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(data, objectClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isAlphaNumeric(String str) {
        Pattern p = Pattern.compile("^[a-zA-Z0-9.]+$");
        Matcher m = p.matcher(str);
        return m.find();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String GetResourceAsString(String resource) {
        try (InputStream inputStream = Utils.class.getResourceAsStream(resource);){
            String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Resource not found: " + resource);
        }
    }

    protected static class ObjectMapperConfig {
        private boolean includeNulls;

        protected ObjectMapperConfig() {
        }

        public static ObjectMapperConfig newInstance() {
            return new ObjectMapperConfig();
        }

        public ObjectMapperConfig withIncludeNulls(boolean includeNulls) {
            this.includeNulls = includeNulls;
            return this;
        }

        public boolean isIncludeNulls() {
            return this.includeNulls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectMapperConfig that = (ObjectMapperConfig)o;
            return this.includeNulls == that.includeNulls;
        }

        public int hashCode() {
            return Objects.hash(this.includeNulls);
        }
    }
}

