/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Vector;
import org.rosuda.util.Global;

public class GlobalConfig {
    static GlobalConfig current;
    String configFile = "plugins.cfg";
    Vector par = new Vector();
    Vector val = new Vector();
    Vector pst = new Vector();
    Integer pst_level = null;

    public GlobalConfig() {
        if (File.separatorChar == '/') {
            this.loadSettings("/etc/plugins.cfg");
        }
        this.pst_level = new Integer(1);
        String uh = System.getProperty("user.home");
        if (uh == null && System.getProperty("os.name").indexOf("indows") > 0) {
            uh = "C:\\";
        }
        this.configFile = uh + File.separator + ".plugins.cfg";
        this.loadSettings();
        this.setParS("GlobalConfig.userConfigFile", this.configFile);
    }

    public static GlobalConfig getGlobalConfig() {
        if (current == null) {
            current = new GlobalConfig();
        }
        return current;
    }

    public static String getS(String Par) {
        return GlobalConfig.getGlobalConfig().getParS(Par);
    }

    public String getParS(String Par) {
        int i = this.par.indexOf(Par);
        return i < 0 ? null : (String)this.val.elementAt(i);
    }

    public Object[] getAllParameters() {
        return this.par.toArray();
    }

    public boolean setParS(String Par, String Val) {
        boolean r = this.internal_setParS(Par, Val);
        if (r) {
            this.saveSettings();
        }
        return r;
    }

    boolean internal_setParS(String pn, String Val) {
        int i = this.par.indexOf(pn);
        if (i < 0) {
            this.par.addElement(pn);
            this.val.addElement(Val);
            this.pst.addElement(this.pst_level);
        } else {
            this.val.setElementAt(Val, i);
            this.pst.setElementAt(this.pst_level, i);
        }
        return true;
    }

    public boolean saveSettings() {
        if (Global.DEBUG > 0) {
            System.out.println("Save to config file \"" + this.configFile + "\" ...");
        }
        try {
            PrintStream p = new PrintStream(new FileOutputStream(this.configFile));
            p.println("<globalSettings ver=100>");
            for (int i = 0; i < this.par.size(); ++i) {
                if (this.pst.elementAt(i) == null) continue;
                p.println("<setting name=" + this.par.elementAt(i) + ">");
                p.println(this.val.elementAt(i));
                p.println("</setting>");
                if (Global.DEBUG <= 0) continue;
                System.out.println("saveSettings.save: " + this.par.elementAt(i) + " -> " + this.val.elementAt(i));
            }
            p.println("</globalSettings>");
            p.close();
            return true;
        }
        catch (Exception e) {
            if (Global.DEBUG > 0) {
                System.out.println("GlobalConfig.saveSettings ERR: " + e.getMessage());
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean loadSettings() {
        return this.loadSettings(this.configFile);
    }

    public boolean loadSettings(String fName) {
        if (fName == null) {
            fName = this.configFile;
        }
        if (Global.DEBUG > 0) {
            System.out.println("Processing config file \"" + fName + "\" ...");
        }
        try {
            BufferedReader b = new BufferedReader(new FileReader(fName));
            boolean isVal = false;
            String curPar = null;
            String curCont = null;
            while (b.ready()) {
                String s = b.readLine();
                int cf = s.indexOf("</setting>");
                int of = s.indexOf("<setting name=");
                if (Global.DEBUG > 0) {
                    System.out.println("LoadSetting: cf=" + cf + ", of=" + of + ", isVal=" + isVal + ", curPar=" + curPar + ", ln=" + s);
                }
                if (isVal) {
                    if (cf >= 0) {
                        if (curCont != null) {
                            this.internal_setParS(curPar, curCont);
                        }
                        curCont = null;
                        isVal = false;
                    } else {
                        curCont = curCont == null ? s : curCont + "\n" + s;
                    }
                }
                if (of < 0) continue;
                int cc = (s = s.substring(of + 14)).indexOf(">");
                if (cc >= 0) {
                    s = s.substring(0, cc);
                }
                curPar = s;
                isVal = true;
            }
            b.close();
            return true;
        }
        catch (Exception e) {
            if (Global.DEBUG > 0) {
                System.out.println("GlobalConfig.loadSettings(\"" + fName + "\") ERR: " + e.getMessage());
                e.printStackTrace();
            }
            return false;
        }
    }
}

