/*
 * Decompiled with CFR 0.152.
 */
package jd2.information;

import ec.tstoolkit.utilities.WildCards;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import jd2.information.InformationExtractor;

class InformationExtractors {
    static final String LSTART = "(";
    static final String LEND = ")";

    InformationExtractors() {
    }

    static String listKey(String prefix, int item) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append(LSTART).append(item).append(LEND);
        return builder.toString();
    }

    static String wcKey(String prefix, char wc) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append(LSTART);
        builder.append(wc).append(LEND);
        return builder.toString();
    }

    static class ArrayExtractorDelegate<S, T>
    implements InformationExtractor<S> {
        final String name;
        final BiFunction<S, Integer, T> fn;
        final InformationExtractor<T> extractor;
        final int start;
        final int end;

        ArrayExtractorDelegate(String name, int start, int end, InformationExtractor<T> extractor, BiFunction<S, Integer, T> fn) {
            this.name = name;
            this.fn = fn;
            this.extractor = extractor;
            this.start = start;
            this.end = end;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            String item = InformationExtractors.wcKey(this.name, this.start == this.end ? (char)'?' : '*');
            this.extractor.fillDictionary(InformationExtractor.concatenate(prefix, item), dic, compact);
        }

        @Override
        public boolean contains(String id) {
            if (this.start == this.end) {
                return ArrayExtractorDelegate.isIParamItem(this.name, id) && this.extractor.contains(ArrayExtractorDelegate.detail(id));
            }
            int idx = ArrayExtractorDelegate.listItem(this.name, id);
            if (idx >= this.start && idx < this.end) {
                return this.extractor.contains(ArrayExtractorDelegate.detail(id));
            }
            return false;
        }

        @Override
        public <Q> Q getData(S source, String id, Class<Q> qclass) {
            if (source == null) {
                return null;
            }
            int idx = ArrayExtractorDelegate.listItem(this.name, id);
            if (idx == Integer.MIN_VALUE) {
                return null;
            }
            Object t = null;
            if (this.start == this.end) {
                t = this.fn.apply(source, idx);
            } else if (idx >= this.start && idx < this.end) {
                t = this.fn.apply(source, idx);
            }
            if (t == null) {
                return null;
            }
            String detail = ArrayExtractorDelegate.detail(id);
            return this.extractor.getData(t, detail, qclass);
        }

        static int listItem(String prefix, String key) {
            if (!key.startsWith(prefix)) {
                return Integer.MIN_VALUE;
            }
            int start = prefix.length() + InformationExtractors.LSTART.length();
            int end = key.indexOf(InformationExtractors.LEND);
            if (end <= start) {
                return Integer.MIN_VALUE;
            }
            String s = key.substring(start, end);
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                return Integer.MIN_VALUE;
            }
        }

        static String detail(String key) {
            int pos = key.indexOf(InformationExtractors.LEND);
            if (pos <= 0) {
                return null;
            }
            return key.substring(pos + 2);
        }

        static boolean isIParamItem(String prefix, String key) {
            if (!key.startsWith(prefix)) {
                return false;
            }
            int start = prefix.length() + InformationExtractors.LSTART.length();
            int end = key.indexOf(InformationExtractors.LEND);
            if (end <= start) {
                return false;
            }
            String s = key.substring(start, end);
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        @Override
        public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class ExtractorDelegate<S, T>
    implements InformationExtractor<S> {
        final String name;
        final Function<S, T> fn;
        final InformationExtractor<T> extractor;

        ExtractorDelegate(String name, InformationExtractor<T> extractor, Function<S, T> fn) {
            this.name = name;
            this.fn = fn;
            this.extractor = extractor;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            if (this.name == null) {
                this.extractor.fillDictionary(prefix, dic, compact);
            } else {
                this.extractor.fillDictionary(InformationExtractor.concatenate(prefix, this.name), dic, compact);
            }
        }

        @Override
        public boolean contains(String id) {
            if (this.name == null) {
                return this.extractor.contains(id);
            }
            if (id.length() <= this.name.length()) {
                return false;
            }
            if (id.startsWith(this.name) && id.charAt(this.name.length()) == '.') {
                return this.extractor.contains(id.substring(this.name.length() + 1));
            }
            return false;
        }

        @Override
        public <Q> Q getData(S source, String id, Class<Q> qclass) {
            if (source == null) {
                return null;
            }
            String subitem = this.name == null ? id : id.substring(this.name.length() + 1);
            T t = this.fn.apply(source);
            if (t == null) {
                return null;
            }
            return this.extractor.getData(t, subitem, qclass);
        }

        @Override
        public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> map) {
            this.extractor.searchAll(this.fn.apply(source), wc, tclass, map);
        }
    }

    static class ArrayExtractor<S>
    implements InformationExtractor<S> {
        final String name;
        final Class<?> targetClass;
        final BiFunction<S, Integer, ?> fn;
        final int start;
        final int end;

        <T> ArrayExtractor(String name, int start, int end, Class<T> targetClass, BiFunction<S, Integer, T> fn) {
            this.name = name;
            this.targetClass = targetClass;
            this.fn = fn;
            this.start = start;
            this.end = end;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            String item = InformationExtractors.wcKey(this.name, this.start == this.end ? (char)'?' : '*');
            dic.put(InformationExtractor.concatenate(prefix, item), this.targetClass);
        }

        @Override
        public boolean contains(String id) {
            if (this.start == this.end) {
                return ArrayExtractor.isIParamItem(this.name, id);
            }
            int idx = ArrayExtractor.listItem(this.name, id);
            return idx >= this.start && idx < this.end;
        }

        @Override
        public <T> T getData(S source, String id, Class<T> tclass) {
            if (source == null) {
                return null;
            }
            if (tclass.isAssignableFrom(this.targetClass)) {
                int idx = ArrayExtractor.listItem(this.name, id);
                if (idx == Integer.MIN_VALUE) {
                    return null;
                }
                if (this.start == this.end) {
                    return (T)this.fn.apply(source, idx);
                }
                if (idx >= this.start && idx < this.end) {
                    return (T)this.fn.apply(source, idx);
                }
            }
            return null;
        }

        static int listItem(String prefix, String key) {
            if (!key.startsWith(prefix)) {
                return Integer.MIN_VALUE;
            }
            int start = prefix.length() + InformationExtractors.LSTART.length();
            int end = key.length() - InformationExtractors.LEND.length();
            if (end <= start) {
                return Integer.MIN_VALUE;
            }
            String s = key.substring(start, end);
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                return Integer.MIN_VALUE;
            }
        }

        static boolean isIParamItem(String prefix, String key) {
            if (!key.startsWith(prefix)) {
                return false;
            }
            int start = prefix.length() + InformationExtractors.LSTART.length();
            int end = key.length() - InformationExtractors.LEND.length();
            if (end <= start) {
                return false;
            }
            String s = key.substring(start, end);
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        @Override
        public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> map) {
            if (tclass.isAssignableFrom(this.targetClass)) {
                for (int i = this.start; i <= this.end; ++i) {
                    String key = InformationExtractors.listKey(this.name, i);
                    if (!wc.match(key)) continue;
                    map.put(key, this.fn.apply(source, i));
                }
            }
        }
    }

    static class AtomicExtractor<S>
    implements InformationExtractor<S> {
        final String name;
        final Class<?> targetClass;
        final Function<S, ?> fn;

        <T> AtomicExtractor(String name, Class<T> targetClass, Function<S, T> fn) {
            this.name = name;
            this.targetClass = targetClass;
            this.fn = fn;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            dic.put(InformationExtractor.concatenate(prefix, this.name), this.targetClass);
        }

        @Override
        public boolean contains(String id) {
            return id.equals(this.name);
        }

        @Override
        public <T> T getData(S source, String id, Class<T> tclass) {
            if (source == null) {
                return null;
            }
            if (tclass.isAssignableFrom(this.targetClass) && id.equals(this.name)) {
                return (T)this.fn.apply(source);
            }
            return null;
        }

        @Override
        public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> map) {
            if (wc.match(this.name) && tclass.isAssignableFrom(this.targetClass)) {
                map.put(this.name, this.fn.apply(source));
            }
        }
    }
}

