/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.tramo.TramoException;
import java.util.Map;

public class EasterSpec
implements Cloneable,
InformationSetSerializable {
    public static final String DURATION = "duration";
    public static final String TYPE = "type";
    public static final String TEST = "test";
    public static final String JULIAN = "julian";
    private boolean test_;
    private int duration_ = 6;
    private Type type_ = Type.Unused;
    private boolean julian = DEF_JULIAN;
    public static final int DEF_IDUR = 6;
    public static boolean DEF_JULIAN = false;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, TYPE), String.class);
        dic.put(InformationSet.item(prefix, DURATION), Integer.class);
        dic.put(InformationSet.item(prefix, TEST), String.class);
        dic.put(InformationSet.item(prefix, JULIAN), Boolean.class);
    }

    public void reset() {
        this.test_ = false;
        this.duration_ = 6;
        this.type_ = Type.Unused;
    }

    public boolean isTest() {
        return this.test_;
    }

    public void setTest(boolean value) {
        this.test_ = value;
    }

    public int getDuration() {
        return this.duration_;
    }

    public void setDuration(int value) {
        if (value <= 0 || value > 15) {
            throw new TramoException("Duration", "Should be inside [1, 15]");
        }
        this.duration_ = value;
    }

    public Type getOption() {
        return this.type_;
    }

    public boolean isUsed() {
        return this.type_ != Type.Unused;
    }

    public boolean isDefined() {
        return this.type_ != Type.Unused && !this.test_;
    }

    public void setOption(Type type) {
        this.type_ = type;
    }

    public boolean isJulian() {
        return this.julian;
    }

    public void setJulian(boolean julian) {
        this.julian = julian;
    }

    public boolean isDefault() {
        return this.type_ == Type.Unused;
    }

    public EasterSpec clone() {
        try {
            EasterSpec spec = (EasterSpec)super.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof EasterSpec && this.equals((EasterSpec)obj);
    }

    private boolean equals(EasterSpec other) {
        return this.duration_ == other.duration_ && this.test_ == other.test_ && this.type_ == other.type_ && this.julian == other.julian;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.duration_;
        hash = 67 * hash + this.type_.hashCode();
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.duration_ != 6) {
            info.add(DURATION, Integer.valueOf(this.duration_));
        }
        if (verbose || this.type_ != Type.Unused) {
            info.add(TYPE, this.type_.name());
        }
        if (verbose || this.test_) {
            info.add(TEST, Boolean.valueOf(this.test_));
        }
        if (verbose || this.julian != DEF_JULIAN) {
            info.add(JULIAN, Boolean.valueOf(this.julian));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean jul;
            Boolean test;
            String type;
            this.reset();
            Integer d = info.get(DURATION, Integer.class);
            if (d != null) {
                this.duration_ = d;
            }
            if ((type = info.get(TYPE, String.class)) != null) {
                this.type_ = Type.valueOf(type);
            }
            if ((test = info.get(TEST, Boolean.class)) != null) {
                this.test_ = test;
            }
            if ((jul = info.get(JULIAN, Boolean.class)) != null) {
                this.julian = jul;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum Type {
        Unused,
        Standard,
        IncludeEaster,
        IncludeEasterMonday;


        public boolean containsEaster() {
            return this == IncludeEaster || this == IncludeEasterMonday;
        }

        public boolean containsEasterMonday() {
            return this == IncludeEasterMonday;
        }
    }
}

