/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTable;

public class ArffTableCellRenderer
extends DefaultTableCellRenderer {
    static final long serialVersionUID = 9195794493301191171L;
    private Color missingColor;
    private Color missingColorSelected;
    private Color highlightColor;
    private Color highlightColorSelected;

    public ArffTableCellRenderer() {
        this(new Color(223, 223, 223), new Color(192, 192, 192));
    }

    public ArffTableCellRenderer(Color color, Color color2) {
        this(color, color2, Color.RED, Color.RED.darker());
    }

    public ArffTableCellRenderer(Color color, Color color2, Color color3, Color color4) {
        this.missingColor = color;
        this.missingColorSelected = color2;
        this.highlightColor = color3;
        this.highlightColorSelected = color4;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        String string = jTable instanceof ArffTable ? ((ArffTable)jTable).getSearchString() : null;
        boolean bl3 = string != null && !string.equals("") ? string.equals(object.toString()) : false;
        if (jTable.getModel() instanceof ArffSortedTableModel) {
            ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)jTable.getModel();
            if (n >= 0) {
                if (arffSortedTableModel.isMissingAt(n, n2)) {
                    this.setToolTipText("missing");
                    if (bl3) {
                        if (bl) {
                            component.setBackground(this.highlightColorSelected);
                        } else {
                            component.setBackground(this.highlightColor);
                        }
                    } else if (bl) {
                        component.setBackground(this.missingColorSelected);
                    } else {
                        component.setBackground(this.missingColor);
                    }
                } else {
                    this.setToolTipText(null);
                    if (bl3) {
                        if (bl) {
                            component.setBackground(this.highlightColorSelected);
                        } else {
                            component.setBackground(this.highlightColor);
                        }
                    } else if (bl) {
                        component.setBackground(jTable.getSelectionBackground());
                    } else {
                        component.setBackground(Color.WHITE);
                    }
                }
                if (arffSortedTableModel.getType(n, n2) == 0) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
            } else {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                if (jTable.getColumnModel().getSelectionModel().isSelectedIndex(n2)) {
                    component.setBackground(UIManager.getColor("TableHeader.background").darker());
                } else {
                    component.setBackground(UIManager.getColor("TableHeader.background"));
                }
            }
        }
        return component;
    }
}

