/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.beans.AbstractTrainingSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;

public class TrainingSetMaker
extends AbstractTrainingSetProducer
implements DataSourceListener,
TestSetListener,
EventConstraints,
Serializable,
StructureProducer {
    private static final long serialVersionUID = -6152577265471535786L;
    protected boolean m_receivedStopNotification = false;

    public TrainingSetMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TrainingSetMaker.gif", "weka/gui/beans/icons/TrainingSetMaker_animated.gif");
        this.m_visual.setText("TrainingSetMaker");
    }

    @Override
    public Instances getStructure(String eventName) {
        if (!eventName.equals("dataSet")) {
            return null;
        }
        if (this.m_listenee == null) {
            return null;
        }
        if (this.m_listenee != null && this.m_listenee instanceof StructureProducer) {
            return ((StructureProducer)this.m_listenee).getStructure("dataSet");
        }
        return null;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Designate an incoming data set as a training set.";
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        this.m_receivedStopNotification = false;
        TrainingSetEvent tse = new TrainingSetEvent(this, e.getDataSet());
        tse.m_setNumber = 1;
        tse.m_maxSetNumber = 1;
        this.notifyTrainingSetProduced(tse);
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        this.m_receivedStopNotification = false;
        TrainingSetEvent tse = new TrainingSetEvent(this, e.getTestSet());
        tse.m_setNumber = 1;
        tse.m_maxSetNumber = 1;
        this.notifyTrainingSetProduced(tse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent tse) {
        Vector l;
        TrainingSetMaker trainingSetMaker = this;
        synchronized (trainingSetMaker) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                if (this.m_receivedStopNotification) {
                    if (this.m_logger != null) {
                        this.m_logger.logMessage("T[rainingSetMaker] " + this.statusMessagePrefix() + " stopping.");
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "INTERRUPTED");
                    }
                    this.m_receivedStopNotification = false;
                    break;
                }
                System.err.println("Notifying listeners (training set maker)");
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(tse);
            }
        }
    }

    @Override
    public void stop() {
        this.m_receivedStopNotification = true;
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("dataSet");
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

