/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class TestOfRuns {
    private final DescriptiveStatistics stats;
    private boolean mean = true;
    private double refValue;
    private int plus;
    private int above;
    private int nruns;
    private int[] runLengths;
    private double[] obs;

    public TestOfRuns(DoubleSeq data) {
        this.stats = DescriptiveStatistics.of(data);
    }

    public TestOfRuns(DescriptiveStatistics stats) {
        this.stats = stats;
    }

    public TestOfRuns useMean(boolean mean) {
        if (this.mean == mean) {
            return this;
        }
        this.clear();
        this.mean = mean;
        return this;
    }

    public boolean isUsingMean() {
        return this.mean;
    }

    public int getBelowNormalCount() {
        return this.above;
    }

    public int getAboveNormalCount() {
        return this.plus;
    }

    public double getReferenceValue() {
        return this.refValue;
    }

    private void clear() {
        this.plus = 0;
        this.above = 0;
        this.nruns = 0;
        this.obs = null;
        this.runLengths = null;
    }

    private void races() {
        boolean prev;
        if (this.runLengths != null) {
            return;
        }
        this.refValue = this.mean ? this.stats.getAverage() : this.stats.getMedian();
        this.obs = this.stats.observations().toArray();
        this.runLengths = new int[this.obs.length];
        int n = this.obs.length;
        if (n == 0) {
            throw new StatException("No data");
        }
        boolean bl = prev = this.obs[0] >= this.refValue;
        if (prev) {
            ++this.plus;
        } else {
            ++this.above;
        }
        this.nruns = 1;
        int curlength = 1;
        for (int i = 1; i < n; ++i) {
            boolean cur;
            boolean bl2 = cur = this.obs[i] >= this.refValue;
            if (cur) {
                ++this.plus;
            } else {
                ++this.above;
            }
            if (cur != prev) {
                ++this.nruns;
                prev = cur;
                int n2 = curlength - 1;
                this.runLengths[n2] = this.runLengths[n2] + 1;
                curlength = 1;
                continue;
            }
            ++curlength;
        }
        int n3 = curlength - 1;
        this.runLengths[n3] = this.runLengths[n3] + 1;
    }

    public int runsCount(int length) {
        return length <= 0 ? this.nruns : this.runLengths[length - 1];
    }

    public StatisticalTest testLength() {
        this.races();
        int n = this.obs.length;
        double x = 0.0;
        double p = this.plus;
        double m = this.above;
        double fp = p / (double)n;
        double fm = m / (double)n;
        double e = (double)n / (p / m + m / p);
        double xp = fm;
        double xm = fp;
        for (int i = 0; i < n; ++i) {
            double ei = e * ((xp *= fp) + (xm *= fm));
            if (this.runLengths[i] == 0) {
                x += ei;
                continue;
            }
            if (ei != 0.0) {
                x += ((double)this.runLengths[i] - ei) / ei * ((double)this.runLengths[i] - ei);
                continue;
            }
            x += 999999.0;
        }
        Chi2 dist = new Chi2(n);
        return TestsUtility.testOf(x, dist, TestType.Upper);
    }

    public StatisticalTest testNumber() {
        this.races();
        double n = this.obs.length;
        double mp = this.above * this.plus;
        double E = 1.0 + 2.0 * mp / n;
        double V = 2.0 * mp * (2.0 * mp - n) / (n * n * (n - 1.0));
        if (V < 1.0E-9) {
            V = 1.0E-9;
        }
        Normal dist = new Normal();
        return TestsUtility.testOf(((double)this.nruns - E) / Math.sqrt(V), dist, TestType.TwoSided);
    }
}

