/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.tramoseats.base.core.seats.BurmanEstimates;
import jdplus.tramoseats.base.core.seats.IComponentsEstimator;
import jdplus.tramoseats.base.core.seats.SeatsModel;

public class WienerKolmogorovEstimator
implements IComponentsEstimator {
    private final int nfcasts;
    private final int nbcasts;

    public WienerKolmogorovEstimator(int nbcasts, int nfcasts) {
        this.nfcasts = nfcasts;
        this.nbcasts = nbcasts;
    }

    @Override
    public SeriesDecomposition decompose(SeatsModel model) {
        SeriesDecomposition.Builder decomposition = SeriesDecomposition.builder((DecompositionMode)DecompositionMode.Additive);
        UcarimaModel ucm = model.getUcarimaModel();
        ucm = ucm.compact(2, 2);
        TsData s = model.getTransformedSeries();
        int nf = model.extrapolationCount(this.nfcasts);
        int nb = model.extrapolationCount(this.nbcasts);
        TsPeriod start = s.getStart();
        TsPeriod bstart = start.plus((long)(-nb));
        TsPeriod fstart = s.getEnd();
        BurmanEstimates burman = BurmanEstimates.builder().data(s.getValues()).forecastsCount(nf).backcastsCount(nb).mean(model.isMeanCorrection()).ucarimaModel(ucm).innovationStdev(Math.sqrt(model.getInnovationVariance())).build();
        int ncmps = ucm.getComponentsCount();
        DoubleSeq[] cmps = new DoubleSeq[ncmps];
        DoubleSeq[] fcmps = new DoubleSeq[ncmps];
        DoubleSeq[] ecmps = new DoubleSeq[ncmps];
        DoubleSeq[] efcmps = new DoubleSeq[ncmps];
        DoubleSeq[] bcmps = new DoubleSeq[ncmps];
        DoubleSeq[] ebcmps = new DoubleSeq[ncmps];
        for (int i = 0; i < ncmps; ++i) {
            if (i != 0 && ucm.getComponent(i).isNull()) continue;
            cmps[i] = burman.estimates(i, true);
            ecmps[i] = burman.stdevEstimates(i);
            fcmps[i] = burman.forecasts(i, true);
            efcmps[i] = burman.stdevForecasts(i, true);
            bcmps[i] = burman.backcasts(i, true);
            ebcmps[i] = burman.stdevBackcasts(i, true);
        }
        DoubleSeq fs = burman.getSeriesForecasts();
        DoubleSeq efs = null;
        DoubleSeq efsa = null;
        for (int i = 0; i < efcmps.length; ++i) {
            if (efcmps[i] == null) continue;
            DoubleSeq var = efcmps[i].fn(z -> z * z);
            efs = DoublesMath.add(efs, (DoubleSeq[])new DoubleSeq[]{var});
            if (i == 1) continue;
            efsa = DoublesMath.add(efsa, (DoubleSeq[])new DoubleSeq[]{var});
        }
        DoubleSeq bs = burman.getSeriesBackcasts();
        DoubleSeq ebs = null;
        DoubleSeq ebsa = null;
        for (int i = 0; i < ebcmps.length; ++i) {
            if (ebcmps[i] == null) continue;
            DoubleSeq var = ebcmps[i].fn(z -> z * z);
            ebs = DoublesMath.add(ebs, (DoubleSeq[])new DoubleSeq[]{var});
            if (i == 1) continue;
            ebsa = DoublesMath.add(ebsa, (DoubleSeq[])new DoubleSeq[]{var});
        }
        decomposition.add(s, ComponentType.Series);
        if (fs != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)fs), ComponentType.Series, ComponentInformation.Forecast);
        }
        if (efs != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)efs.fn(z -> z <= 0.0 ? 0.0 : Math.sqrt(z))), ComponentType.Series, ComponentInformation.StdevForecast);
        }
        if (bs != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)bs), ComponentType.Series, ComponentInformation.Backcast);
        }
        if (ebs != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)ebs.fn(z -> z <= 0.0 ? 0.0 : Math.sqrt(z))), ComponentType.Series, ComponentInformation.StdevBackcast);
        }
        if (cmps[0] != null) {
            decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)cmps[0]), ComponentType.Trend);
        }
        if (cmps[1] != null) {
            decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)cmps[1]), ComponentType.Seasonal);
        }
        if (fcmps[0] != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)fcmps[0]), ComponentType.Trend, ComponentInformation.Forecast);
        }
        if (fcmps[1] != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)fcmps[1]), ComponentType.Seasonal, ComponentInformation.Forecast);
        }
        decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)DoublesMath.subtract((DoubleSeq)fs, (DoubleSeq)fcmps[1])), ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        if (ecmps[0] != null) {
            decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)ecmps[0]), ComponentType.Trend, ComponentInformation.Stdev);
        }
        if (efcmps[0] != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)efcmps[0]), ComponentType.Trend, ComponentInformation.StdevForecast);
        }
        decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)DoublesMath.subtract((DoubleSeq)s.getValues(), (DoubleSeq)cmps[1])), ComponentType.SeasonallyAdjusted);
        if (ecmps[1] != null) {
            decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)ecmps[1]), ComponentType.Seasonal, ComponentInformation.Stdev);
            decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)ecmps[1]), ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        }
        if (efcmps[1] != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)efcmps[1]), ComponentType.Seasonal, ComponentInformation.StdevForecast);
        }
        decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)cmps[2]), ComponentType.Irregular);
        if (fcmps[2] != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)fcmps[2]), ComponentType.Irregular, ComponentInformation.Forecast);
        }
        if (ecmps[2] != null) {
            decomposition.add(TsData.of((TsPeriod)start, (DoubleSeq)ecmps[2]), ComponentType.Irregular, ComponentInformation.Stdev);
        }
        if (efcmps[2] != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)efcmps[2]), ComponentType.Irregular, ComponentInformation.StdevForecast);
        }
        if (bcmps[0] != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)bcmps[0]), ComponentType.Trend, ComponentInformation.Backcast);
        }
        if (bcmps[1] != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)bcmps[1]), ComponentType.Seasonal, ComponentInformation.Backcast);
        }
        if (efsa != null) {
            decomposition.add(TsData.of((TsPeriod)fstart, (DoubleSeq)efsa.fn(z -> z <= 0.0 ? 0.0 : Math.sqrt(z))), ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        }
        decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)DoublesMath.subtract((DoubleSeq)bs, (DoubleSeq)bcmps[1])), ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast);
        if (ebcmps[0] != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)ebcmps[0]), ComponentType.Trend, ComponentInformation.StdevBackcast);
        }
        if (ebcmps[1] != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)ebcmps[1]), ComponentType.Seasonal, ComponentInformation.StdevBackcast);
        }
        if (bcmps[2] != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)bcmps[2]), ComponentType.Irregular, ComponentInformation.Backcast);
        }
        if (ebcmps[2] != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)ebcmps[2]), ComponentType.Irregular, ComponentInformation.StdevBackcast);
        }
        if (ebsa != null) {
            decomposition.add(TsData.of((TsPeriod)bstart, (DoubleSeq)ebsa.fn(z -> z <= 0.0 ? 0.0 : Math.sqrt(z))), ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast);
        }
        return decomposition.build();
    }
}

