/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import jdplus.tramoseats.base.core.tramo.ModelComparator;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.ModelStatistics;
import jdplus.tramoseats.base.core.tramo.TramoContext;

class RegularUnderDifferencingTest2
extends ModelController {
    RegularUnderDifferencingTest2() {
    }

    @Override
    ProcessingResult process(RegSarimaModelling modelling, TramoContext context) {
        ModelDescription desc = modelling.getDescription();
        if (desc.getAnnualFrequency() <= 2) {
            return ProcessingResult.Unprocessed;
        }
        ModelStatistics stats = ModelStatistics.of(modelling.getDescription(), (ConcentratedLikelihood)modelling.getEstimation().getConcentratedLikelihood());
        if (stats.getLjungBoxPvalue() >= 0.005) {
            return ProcessingResult.Unchanged;
        }
        if (!this.needProcessing(modelling)) {
            return ProcessingResult.Unchanged;
        }
        RegSarimaModelling ncontext = this.buildNewModel(modelling);
        ModelComparator cmp = ModelComparator.builder().build();
        if (cmp.compare(ncontext, modelling) < 0) {
            this.transferInformation(ncontext, modelling);
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    private boolean needProcessing(RegSarimaModelling context) {
        DoubleSeq y = context.getEstimation().getConcentratedLikelihood().e();
        int npos0 = 0;
        int imax = Math.min(24, y.length() - 1);
        double[] ac = AutoCovariances.autoCovariancesWithZeroMean((DoubleSeq)y, (int)imax);
        for (int i = 0; i < 12; ++i) {
            if (!(ac[i] > 0.0)) continue;
            ++npos0;
        }
        int npos1 = npos0;
        for (int i = 12; i < ac.length; ++i) {
            if (!(ac[i] > 0.0)) continue;
            ++npos1;
        }
        return npos0 >= context.getDescription().getAnnualFrequency() || npos0 >= 9 || npos1 >= 17;
    }

    private RegSarimaModelling buildNewModel(RegSarimaModelling modelling) {
        ModelDescription desc = modelling.getDescription();
        ModelDescription ndesc = ModelDescription.copyOf((ModelDescription)desc);
        SarimaOrders spec = desc.specification();
        if (spec.getD() == 2) {
            if (spec.getP() == 3) {
                return null;
            }
            spec.setP(spec.getP() + 1);
            ndesc.setSpecification(spec);
            ndesc.setMean(true);
        } else {
            if (spec.getQ() == 3) {
                return null;
            }
            spec.setQ(spec.getQ() + 1);
            spec.setD(spec.getD() + 1);
            ndesc.setSpecification(spec);
            ndesc.setMean(false);
        }
        RegSarimaModelling ncontext = RegSarimaModelling.of((ModelDescription)ndesc);
        if (!this.estimate(ncontext, true)) {
            return null;
        }
        return ncontext;
    }
}

