/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo.internal;

import java.util.Optional;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.FastKalmanFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IDifferencingModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.HannanRissanen;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.tramoseats.base.core.tramo.TramoException;
import jdplus.tramoseats.base.core.tramo.internal.TramoUtility;

public class DifferencingModule
implements IDifferencingModule {
    public static final int MAXD = 2;
    public static final int MAXBD = 1;
    private DoubleSeq y;
    private SarimaOrders spec;
    private SarimaModel lastModel;
    private double rmax;
    private double rsmax;
    private double c;
    private double din;
    private double tmean;
    private int iter;
    private boolean ml;
    private boolean useml;
    private boolean mlused;
    private final int maxd;
    private final int maxbd;
    private final double ub1;
    private final double ub2;
    private final double cancel;
    private final double eps;
    private final boolean seasonal;
    private final boolean initial;

    static boolean comespd(int freq, int nz, boolean seas) {
        SarimaOrders spec = new SarimaOrders(freq);
        spec.setD(2);
        if (seas) {
            spec.setBd(1);
        }
        return TramoUtility.autlar(nz, spec) >= 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static double removeMean(DataBlock x) {
        double m = x.average();
        x.sub(m);
        return m;
    }

    private DifferencingModule(int maxd, int maxbd, double ub1, double ub2, double cancel, double eps, boolean seasonal, boolean initial) {
        this.maxd = maxd;
        this.maxbd = seasonal ? maxbd : 0;
        this.ub1 = ub1;
        this.ub2 = ub2;
        this.cancel = cancel;
        this.eps = eps;
        this.seasonal = seasonal;
        this.initial = initial;
    }

    private boolean calc() {
        if (this.y == null) {
            return false;
        }
        this.c = this.cancel;
        this.useml = false;
        this.mlused = false;
        this.rsmax = 0.0;
        this.rmax = 0.0;
        this.din = 0.0;
        this.step0();
        this.iter = 0;
        while (this.nextstep() && this.iter < 5) {
            ++this.iter;
        }
        this.computeTMean();
        return true;
    }

    public void clear() {
        this.lastModel = null;
        this.spec = null;
        this.y = null;
        this.useml = false;
        this.tmean = 0.0;
    }

    private int cond1(int icon) {
        if (this.spec.getD() + this.spec.getBd() != 0) {
            return icon;
        }
        double ar = this.lastModel.phi(1);
        double ma = this.lastModel.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.maxbd > 0) {
            sar = this.lastModel.bphi(1);
            sma = this.lastModel.btheta(1);
        }
        if ((Math.abs(ar - ma) < this.c || this.maxbd > 0 && Math.abs(sar - sma) < this.c) && (this.rmax >= 0.9 || this.rsmax >= 0.9)) {
            if (this.useml && icon == 1) {
                this.useml = false;
            } else {
                ++icon;
            }
            if (this.rmax > this.rsmax) {
                this.spec.setD(this.spec.getD() + 1);
            } else {
                this.spec.setBd(this.spec.getBd() + 1);
            }
        }
        return icon;
    }

    private int finalcond(int icon) {
        if (icon == 2) {
            this.spec.setD(this.spec.getD() - 1);
            this.spec.setBd(this.spec.getBd() - 1);
            if (this.mlused) {
                if (this.lastModel.phi(1) < this.lastModel.bphi(1)) {
                    this.spec.setD(this.spec.getD() + 1);
                } else {
                    this.spec.setBd(this.spec.getBd() + 1);
                }
            } else if (this.rmax > this.rsmax) {
                if (this.rmax > 0.0) {
                    this.spec.setD(this.spec.getD() + 1);
                }
            } else if (this.rsmax > 0.0) {
                this.spec.setBd(this.spec.getBd() + 1);
            }
        }
        if (this.spec.getD() > this.maxd) {
            this.spec.setD(this.maxd);
            icon = 0;
        }
        if (this.spec.getBd() > this.maxbd) {
            this.spec.setBd(this.maxbd);
            icon = 0;
        }
        return icon;
    }

    public double getTMean() {
        return this.tmean;
    }

    public boolean isMeanCorrection() {
        double vct = 2.5;
        int n = this.y.length();
        if (n <= 80) {
            vct = 1.96;
        } else if (n <= 155) {
            vct = 1.98;
        } else if (n <= 230) {
            vct = 2.1;
        } else if (n <= 320) {
            vct = 2.3;
        }
        return Math.abs(this.tmean) > vct;
    }

    public int getD() {
        return this.spec.getD();
    }

    public int getBd() {
        return this.spec.getBd();
    }

    private void initstep(boolean bstart) {
        boolean usedefault;
        DataBlock data;
        BackFilter ur;
        if (this.spec.getD() == 0 && this.spec.getBd() == 0 && bstart) {
            if (this.spec.getPeriod() != 2) {
                this.spec.setP(2);
            } else {
                this.spec.setP(1);
            }
            this.spec.setQ(0);
            this.spec.setBq(0);
            if (this.seasonal) {
                this.spec.setBp(1);
            }
        } else {
            this.spec.setP(1);
            this.spec.setQ(1);
            if (this.maxbd > 0) {
                this.spec.setBp(1);
                this.spec.setBq(1);
            }
        }
        if ((ur = RegArimaUtility.differencingFilter((int)this.spec.getPeriod(), (int)this.spec.getD(), (int)this.spec.getBd())).getDegree() > 0) {
            data = DataBlock.make((int)(this.y.length() - ur.getDegree()));
            ur.apply(DataBlock.of((DoubleSeq)this.y), data);
        } else {
            data = DataBlock.of((DoubleSeq)this.y);
        }
        DifferencingModule.removeMean(data);
        HannanRissanen hr = HannanRissanen.builder().build();
        boolean bl = usedefault = !hr.process((DoubleSeq)data, this.spec.doStationary());
        if (!usedefault) {
            this.lastModel = hr.getModel();
            if (bstart && !this.lastModel.isStable(true)) {
                if (this.spec.getP() > 1 || this.spec.getP() == 1 && Math.abs(this.lastModel.phi(1)) > 1.02 || this.spec.getBp() == 1 && Math.abs(this.lastModel.bphi(1)) > 1.02) {
                    usedefault = true;
                } else {
                    this.lastModel = SarimaMapping.stabilize((SarimaModel)this.lastModel);
                }
            }
        }
        if (usedefault) {
            this.lastModel = SarimaModel.builder((SarmaOrders)this.spec.doStationary()).setDefault().build();
        }
        if (usedefault || this.ml || this.useml) {
            this.lastModel = SarimaMapping.stabilize((SarimaModel)this.lastModel);
            IRegArimaComputer<SarimaModel> processor = TramoUtility.processor(true, this.eps);
            SarimaModel arima = SarimaModel.builder((SarimaOrders)this.spec).parameters(this.lastModel.parameters()).build();
            RegArimaModel regarima = RegArimaModel.builder().y(this.y).arima((IArimaModel)arima).meanCorrection(true).build();
            RegArimaEstimation rslt = processor.optimize(regarima, null);
            if (rslt == null) {
                throw new TramoException("Non convergence in ESPDIF");
            }
            this.lastModel = (SarimaModel)((SarimaModel)rslt.getModel().arima()).stationaryTransformation().getStationaryModel();
            this.mlused = true;
        } else {
            this.mlused = false;
        }
        this.useml = false;
    }

    private int maincondition() {
        double ar = this.lastModel.phi(1);
        double ma = this.lastModel.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.maxbd > 0) {
            sar = this.lastModel.bphi(1);
            sma = this.lastModel.btheta(1);
        }
        this.c -= 0.002;
        this.din = 1.005 - this.ub2;
        int icon = 0;
        if (Math.abs(ar + 1.0) <= this.din) {
            if (-ar > 1.02) {
                icon = 1;
                this.useml = true;
            } else if (Math.abs(ar - ma) > this.c) {
                ++icon;
                this.spec.setD(this.spec.getD() + 1);
            }
        } else if (Math.abs(ar) > 1.12) {
            icon = 1;
            this.useml = true;
        }
        if (this.maxbd > 0) {
            if (Math.abs(sar + 1.0) <= this.din) {
                if (-sar > 1.02) {
                    this.useml = true;
                    icon = 1;
                } else if (this.spec.getBd() == 0 && Math.abs(sar - sma) > this.c) {
                    ++icon;
                    this.spec.setBd(this.spec.getBd() + 1);
                    if (this.useml) {
                        --icon;
                        this.useml = false;
                    }
                }
            } else if (Math.abs(sar) > 1.12) {
                icon = 1;
                this.useml = true;
            }
        }
        return icon;
    }

    private boolean nextstep() {
        this.initstep(false);
        int icon = this.maincondition();
        if (this.iter == 0) {
            icon = this.cond1(icon);
        }
        return this.finalcond(icon) != 0;
    }

    public boolean process(DoubleSeq data, int period, int d, int bd, boolean seasonal) {
        this.clear();
        this.y = data;
        this.spec = new SarimaOrders(period);
        this.spec.setD(d);
        if (seasonal) {
            this.spec.setBd(bd);
        }
        return this.calc();
    }

    private int searchur(Complex[] r, double val, boolean regular) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        double vmax = 0.0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (vcur >= val && cdim <= 0.05 && r[i].getRe() > 0.0) {
                ++n;
                continue;
            }
            if (!(cdim <= 0.02) || !(r[i].getRe() > 0.0) || !(vcur > vmax)) continue;
            vmax = vcur;
        }
        if (regular) {
            this.rmax = vmax;
        } else {
            this.rsmax = vmax;
        }
        return n;
    }

    private void step0() {
        this.initstep(true);
        if (this.spec.getD() != 0 || this.spec.getBd() != 0) {
            this.rmax = this.lastModel.phi(1);
            if (this.maxbd > 0) {
                this.rsmax = this.lastModel.bphi(1);
            }
        }
        Complex[] rar = this.lastModel.getRegularAR().mirror().roots();
        this.spec.setD(this.spec.getD() + this.searchur(rar, this.ub1, true));
        if (this.maxbd > 0) {
            Complex[] rsar = this.lastModel.getSeasonalAR().mirror().roots();
            this.spec.setBd(this.spec.getBd() + this.searchur(rsar, this.ub1, false));
        }
    }

    private void computeTMean() {
        DataBlock res = null;
        if (this.spec.getD() == 0 && this.spec.getBd() == 0) {
            res = DataBlock.of((DoubleSeq)this.y);
        } else {
            if (this.lastModel == null) {
                throw new TramoException("Failure in the identification of the differencing orders");
            }
            this.lastModel = SarimaMapping.stabilize((SarimaModel)this.lastModel);
            FastKalmanFilter kf = new FastKalmanFilter((IArimaModel)this.lastModel);
            BackFilter D = RegArimaUtility.differencingFilter((int)this.spec.getPeriod(), (int)this.spec.getD(), (int)this.spec.getBd());
            res = DataBlock.make((int)(this.y.length() - D.getDegree()));
            D.apply(DataBlock.of((DoubleSeq)this.y), res);
            res = kf.fastFilter((DoubleSeq)res);
        }
        double s = res.sum();
        double s2 = res.ssq();
        int n = res.length();
        this.tmean = s / Math.sqrt((s2 * (double)n - s * s) / (double)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling context) {
        ModelDescription desc = context.getDescription();
        if (context.needEstimation()) {
            context.estimate(this.eps);
        }
        RegArimaEstimation estimation = context.getEstimation();
        int freq = desc.getAnnualFrequency();
        ProcessingLog log = context.getLog();
        log.push("differencing selection");
        try {
            DoubleSeq outs;
            if (!DifferencingModule.comespd(freq, desc.regarima().getObservationsCount(), this.seasonal)) {
                log.remark("default model selected (not enough obs.)");
                ProcessingResult processingResult = this.airline(context);
                return processingResult;
            }
            int nvars = (int)desc.variables().filter(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true)).count();
            DoubleSeq res = RegArimaUtility.interpolatedData((RegArimaModel)desc.regarima(), (ConcentratedLikelihoodWithMissing)estimation.getConcentratedLikelihood());
            if (nvars > 0) {
                Optional<Variable> first = desc.variables().filter(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true)).findFirst();
                outs = RegArimaUtility.regressionEffect((RegArimaModel)desc.regarima(), (ConcentratedLikelihoodWithMissing)estimation.getConcentratedLikelihood(), (int)desc.findPosition(first.orElseThrow().getCore()), (int)nvars);
                res = res.op(outs, (a, b) -> a - b);
            }
            SarimaOrders curspec = desc.specification();
            if (!this.process(res, freq, this.initial ? 0 : curspec.getD(), this.initial ? 0 : curspec.getBd(), this.seasonal)) {
                log.remark("differencing selection failed");
                outs = this.airline(context);
                return outs;
            }
            boolean nmean = this.isMeanCorrection();
            boolean changed = false;
            if (this.spec.getD() != curspec.getD() || this.spec.getBd() != curspec.getBd()) {
                changed = true;
                desc.setSpecification(this.spec);
                context.clearEstimation();
            }
            if (nmean != desc.isMean()) {
                changed = true;
                desc.setMean(nmean);
                context.clearEstimation();
            }
            log.info("differencing selection", (Object)IDifferencingModule.Info.of((IDifferencingModule)this));
            ProcessingResult processingResult = changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
            return processingResult;
        }
        catch (RuntimeException err) {
            log.remark("differencing selection failed");
            ProcessingResult processingResult = this.airline(context);
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    private ProcessingResult airline(RegSarimaModelling context) {
        ModelDescription desc = context.getDescription();
        if (!desc.specification().isAirline(this.seasonal)) {
            desc.setAirline(this.seasonal);
            desc.setMean(false);
            context.clearEstimation();
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unprocessed;
    }

    public static class Builder {
        private int maxd = 2;
        private int maxbd = 1;
        private double eps = 1.0E-5;
        private double ub1 = 0.97;
        private double ub2 = 0.88;
        private double cancel = 0.1;
        private boolean seasonal = true;
        private boolean initial = true;

        private Builder() {
        }

        public Builder maxD(int maxd) {
            this.maxd = maxd;
            return this;
        }

        public Builder maxBD(int maxbd) {
            this.maxbd = maxbd;
            return this;
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder ub1(double ub1) {
            this.ub1 = ub1;
            return this;
        }

        public Builder ub2(double ub2) {
            this.ub2 = ub2;
            return this;
        }

        public Builder cancel(double cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder seasonal(boolean seasonal) {
            this.seasonal = seasonal;
            return this;
        }

        public Builder initial(boolean initial) {
            this.initial = initial;
            return this;
        }

        public DifferencingModule build() {
            return new DifferencingModule(this.maxd, this.maxbd, this.ub1, this.ub2, this.cancel, this.eps, this.seasonal, this.initial);
        }
    }
}

