/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.TsContextVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.regarima.EasterSpec;
import jdplus.x13.base.api.regarima.MeanSpec;
import jdplus.x13.base.api.regarima.TradingDaysSpec;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegressionSpec
implements Validatable<RegressionSpec> {
    public static final double DEF_AICCDIFF = 0.0;
    public static final RegressionSpec DEFAULT = (RegressionSpec)RegressionSpec.builder().build();
    private final double aicDiff;
    @NonNull
    private final MeanSpec mean;
    @NonNull
    private final TradingDaysSpec tradingDays;
    @NonNull
    private final EasterSpec easter;
    private final List<Variable<IOutlier>> outliers;
    private final List<Variable<TsContextVariable>> userDefinedVariables;
    private final List<Variable<InterventionVariable>> interventionVariables;
    private final List<Variable<Ramp>> ramps;
    public static final RegressionSpec DEFAULT_UNUSED = (RegressionSpec)RegressionSpec.builder().build();
    public static final RegressionSpec DEFAULT_CONST = (RegressionSpec)RegressionSpec.builder().mean(MeanSpec.DEFAULT_USED).build();

    public static Builder builder() {
        return new Builder().mean(MeanSpec.DEFAULT_UNUSED).aicDiff(0.0).easter(EasterSpec.DEFAULT_UNUSED).tradingDays(TradingDaysSpec.none());
    }

    public boolean isUsed() {
        return this.mean.isUsed() || this.tradingDays.isUsed() || this.easter.isUsed() || !this.outliers.isEmpty() || !this.userDefinedVariables.isEmpty() || !this.ramps.isEmpty() || !this.interventionVariables.isEmpty();
    }

    public int getOutliersCount() {
        return this.outliers.size();
    }

    public int getRampsCount() {
        return this.ramps.size();
    }

    public int getInterventionVariablesCount() {
        return this.interventionVariables.size();
    }

    public int getUserDefinedVariablesCount() {
        return this.userDefinedVariables.size();
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public RegressionSpec validate() throws IllegalArgumentException {
        this.tradingDays.validate();
        return this;
    }

    public boolean hasFixedCoefficients() {
        if (!this.isUsed()) {
            return false;
        }
        return this.mean.hasFixedCoefficient() || this.tradingDays.hasFixedCoefficients() || this.easter.hasFixedCoefficient() || this.outliers.stream().anyMatch(var -> !var.isFree()) || this.ramps.stream().anyMatch(var -> !var.isFree()) || this.interventionVariables.stream().anyMatch(var -> !var.isFree()) || this.userDefinedVariables.stream().anyMatch(var -> !var.isFree());
    }

    @Generated
    RegressionSpec(double aicDiff, @NonNull MeanSpec mean, @NonNull TradingDaysSpec tradingDays, @NonNull EasterSpec easter, List<Variable<IOutlier>> outliers, List<Variable<TsContextVariable>> userDefinedVariables, List<Variable<InterventionVariable>> interventionVariables, List<Variable<Ramp>> ramps) {
        if (mean == null) {
            throw new NullPointerException("mean is marked non-null but is null");
        }
        if (tradingDays == null) {
            throw new NullPointerException("tradingDays is marked non-null but is null");
        }
        if (easter == null) {
            throw new NullPointerException("easter is marked non-null but is null");
        }
        this.aicDiff = aicDiff;
        this.mean = mean;
        this.tradingDays = tradingDays;
        this.easter = easter;
        this.outliers = outliers;
        this.userDefinedVariables = userDefinedVariables;
        this.interventionVariables = interventionVariables;
        this.ramps = ramps;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().aicDiff(this.aicDiff).mean(this.mean).tradingDays(this.tradingDays).easter(this.easter);
        if (this.outliers != null) {
            builder.outliers(this.outliers);
        }
        if (this.userDefinedVariables != null) {
            builder.userDefinedVariables(this.userDefinedVariables);
        }
        if (this.interventionVariables != null) {
            builder.interventionVariables(this.interventionVariables);
        }
        if (this.ramps != null) {
            builder.ramps(this.ramps);
        }
        return builder;
    }

    @Generated
    public double getAicDiff() {
        return this.aicDiff;
    }

    @NonNull
    @Generated
    public MeanSpec getMean() {
        return this.mean;
    }

    @NonNull
    @Generated
    public TradingDaysSpec getTradingDays() {
        return this.tradingDays;
    }

    @NonNull
    @Generated
    public EasterSpec getEaster() {
        return this.easter;
    }

    @Generated
    public List<Variable<IOutlier>> getOutliers() {
        return this.outliers;
    }

    @Generated
    public List<Variable<TsContextVariable>> getUserDefinedVariables() {
        return this.userDefinedVariables;
    }

    @Generated
    public List<Variable<InterventionVariable>> getInterventionVariables() {
        return this.interventionVariables;
    }

    @Generated
    public List<Variable<Ramp>> getRamps() {
        return this.ramps;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegressionSpec)) {
            return false;
        }
        RegressionSpec other = (RegressionSpec)o;
        if (Double.compare(this.getAicDiff(), other.getAicDiff()) != 0) {
            return false;
        }
        MeanSpec this$mean = this.getMean();
        MeanSpec other$mean = other.getMean();
        if (this$mean == null ? other$mean != null : !((Object)this$mean).equals(other$mean)) {
            return false;
        }
        TradingDaysSpec this$tradingDays = this.getTradingDays();
        TradingDaysSpec other$tradingDays = other.getTradingDays();
        if (this$tradingDays == null ? other$tradingDays != null : !((Object)this$tradingDays).equals(other$tradingDays)) {
            return false;
        }
        EasterSpec this$easter = this.getEaster();
        EasterSpec other$easter = other.getEaster();
        if (this$easter == null ? other$easter != null : !((Object)this$easter).equals(other$easter)) {
            return false;
        }
        List<Variable<IOutlier>> this$outliers = this.getOutliers();
        List<Variable<IOutlier>> other$outliers = other.getOutliers();
        if (this$outliers == null ? other$outliers != null : !((Object)this$outliers).equals(other$outliers)) {
            return false;
        }
        List<Variable<TsContextVariable>> this$userDefinedVariables = this.getUserDefinedVariables();
        List<Variable<TsContextVariable>> other$userDefinedVariables = other.getUserDefinedVariables();
        if (this$userDefinedVariables == null ? other$userDefinedVariables != null : !((Object)this$userDefinedVariables).equals(other$userDefinedVariables)) {
            return false;
        }
        List<Variable<InterventionVariable>> this$interventionVariables = this.getInterventionVariables();
        List<Variable<InterventionVariable>> other$interventionVariables = other.getInterventionVariables();
        if (this$interventionVariables == null ? other$interventionVariables != null : !((Object)this$interventionVariables).equals(other$interventionVariables)) {
            return false;
        }
        List<Variable<Ramp>> this$ramps = this.getRamps();
        List<Variable<Ramp>> other$ramps = other.getRamps();
        return !(this$ramps == null ? other$ramps != null : !((Object)this$ramps).equals(other$ramps));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $aicDiff = Double.doubleToLongBits(this.getAicDiff());
        result = result * 59 + (int)($aicDiff >>> 32 ^ $aicDiff);
        MeanSpec $mean = this.getMean();
        result = result * 59 + ($mean == null ? 43 : ((Object)$mean).hashCode());
        TradingDaysSpec $tradingDays = this.getTradingDays();
        result = result * 59 + ($tradingDays == null ? 43 : ((Object)$tradingDays).hashCode());
        EasterSpec $easter = this.getEaster();
        result = result * 59 + ($easter == null ? 43 : ((Object)$easter).hashCode());
        List<Variable<IOutlier>> $outliers = this.getOutliers();
        result = result * 59 + ($outliers == null ? 43 : ((Object)$outliers).hashCode());
        List<Variable<TsContextVariable>> $userDefinedVariables = this.getUserDefinedVariables();
        result = result * 59 + ($userDefinedVariables == null ? 43 : ((Object)$userDefinedVariables).hashCode());
        List<Variable<InterventionVariable>> $interventionVariables = this.getInterventionVariables();
        result = result * 59 + ($interventionVariables == null ? 43 : ((Object)$interventionVariables).hashCode());
        List<Variable<Ramp>> $ramps = this.getRamps();
        result = result * 59 + ($ramps == null ? 43 : ((Object)$ramps).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "RegressionSpec(aicDiff=" + this.getAicDiff() + ", mean=" + String.valueOf(this.getMean()) + ", tradingDays=" + String.valueOf(this.getTradingDays()) + ", easter=" + String.valueOf(this.getEaster()) + ", outliers=" + String.valueOf(this.getOutliers()) + ", userDefinedVariables=" + String.valueOf(this.getUserDefinedVariables()) + ", interventionVariables=" + String.valueOf(this.getInterventionVariables()) + ", ramps=" + String.valueOf(this.getRamps()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<RegressionSpec> {
        @Generated
        private double aicDiff;
        @Generated
        private MeanSpec mean;
        @Generated
        private TradingDaysSpec tradingDays;
        @Generated
        private EasterSpec easter;
        @Generated
        private ArrayList<Variable<IOutlier>> outliers;
        @Generated
        private ArrayList<Variable<TsContextVariable>> userDefinedVariables;
        @Generated
        private ArrayList<Variable<InterventionVariable>> interventionVariables;
        @Generated
        private ArrayList<Variable<Ramp>> ramps;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder aicDiff(double aicDiff) {
            this.aicDiff = aicDiff;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder mean(@NonNull MeanSpec mean) {
            if (mean == null) {
                throw new NullPointerException("mean is marked non-null but is null");
            }
            this.mean = mean;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tradingDays(@NonNull TradingDaysSpec tradingDays) {
            if (tradingDays == null) {
                throw new NullPointerException("tradingDays is marked non-null but is null");
            }
            this.tradingDays = tradingDays;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder easter(@NonNull EasterSpec easter) {
            if (easter == null) {
                throw new NullPointerException("easter is marked non-null but is null");
            }
            this.easter = easter;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outlier(Variable<IOutlier> outlier) {
            if (this.outliers == null) {
                this.outliers = new ArrayList();
            }
            this.outliers.add(outlier);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outliers(@org.jspecify.annotations.NonNull Collection<? extends Variable<IOutlier>> outliers) {
            if (outliers == null) {
                throw new NullPointerException("outliers cannot be null");
            }
            if (this.outliers == null) {
                this.outliers = new ArrayList();
            }
            this.outliers.addAll(outliers);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearOutliers() {
            if (this.outliers != null) {
                this.outliers.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder userDefinedVariable(Variable<TsContextVariable> userDefinedVariable) {
            if (this.userDefinedVariables == null) {
                this.userDefinedVariables = new ArrayList();
            }
            this.userDefinedVariables.add(userDefinedVariable);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder userDefinedVariables(@org.jspecify.annotations.NonNull Collection<? extends Variable<TsContextVariable>> userDefinedVariables) {
            if (userDefinedVariables == null) {
                throw new NullPointerException("userDefinedVariables cannot be null");
            }
            if (this.userDefinedVariables == null) {
                this.userDefinedVariables = new ArrayList();
            }
            this.userDefinedVariables.addAll(userDefinedVariables);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearUserDefinedVariables() {
            if (this.userDefinedVariables != null) {
                this.userDefinedVariables.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder interventionVariable(Variable<InterventionVariable> interventionVariable) {
            if (this.interventionVariables == null) {
                this.interventionVariables = new ArrayList();
            }
            this.interventionVariables.add(interventionVariable);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder interventionVariables(@org.jspecify.annotations.NonNull Collection<? extends Variable<InterventionVariable>> interventionVariables) {
            if (interventionVariables == null) {
                throw new NullPointerException("interventionVariables cannot be null");
            }
            if (this.interventionVariables == null) {
                this.interventionVariables = new ArrayList();
            }
            this.interventionVariables.addAll(interventionVariables);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearInterventionVariables() {
            if (this.interventionVariables != null) {
                this.interventionVariables.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ramp(Variable<Ramp> ramp) {
            if (this.ramps == null) {
                this.ramps = new ArrayList();
            }
            this.ramps.add(ramp);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ramps(@org.jspecify.annotations.NonNull Collection<? extends Variable<Ramp>> ramps) {
            if (ramps == null) {
                throw new NullPointerException("ramps cannot be null");
            }
            if (this.ramps == null) {
                this.ramps = new ArrayList();
            }
            this.ramps.addAll(ramps);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearRamps() {
            if (this.ramps != null) {
                this.ramps.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull RegressionSpec buildWithoutValidation() {
            return new RegressionSpec(this.aicDiff, this.mean, this.tradingDays, this.easter, switch (this.outliers == null ? 0 : this.outliers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.outliers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<IOutlier>>(this.outliers));
            }, switch (this.userDefinedVariables == null ? 0 : this.userDefinedVariables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.userDefinedVariables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<TsContextVariable>>(this.userDefinedVariables));
            }, switch (this.interventionVariables == null ? 0 : this.interventionVariables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.interventionVariables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<InterventionVariable>>(this.interventionVariables));
            }, switch (this.ramps == null ? 0 : this.ramps.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.ramps.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<Ramp>>(this.ramps));
            });
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "RegressionSpec.Builder(aicDiff=" + this.aicDiff + ", mean=" + String.valueOf(this.mean) + ", tradingDays=" + String.valueOf(this.tradingDays) + ", easter=" + String.valueOf(this.easter) + ", outliers=" + String.valueOf(this.outliers) + ", userDefinedVariables=" + String.valueOf(this.userDefinedVariables) + ", interventionVariables=" + String.valueOf(this.interventionVariables) + ", ramps=" + String.valueOf(this.ramps) + ")";
        }
    }
}

