
<!-- README.md is generated from README.Rmd. Please edit that file -->

# BayesCPclust

<!-- badges: start -->

<!-- badges: end -->

BayesCPclust aims to estimate the change points in constant-wise data
sequences while simultaneously performing clustering. A Gibbs sampler
algorithm was developed to estimate the number of clusters, cluster
assignments, number of change points, their positions, and constant
levels.

For more details see paper in [arXiv paper
link](https://arxiv.org/abs/2305.17631v3)

## Installation

You can install the development version of BayesCPclust from
[GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("acarolcruz/BayesCPclust")
```

## Example

The following example illustrate the process of performing clustering
and estimations for constant-wise change-point data using the data
example ‘data’. When there is no prior knowledge of the number of change
points and their locations, we suggest to initialize the algortihm with
zero change points for all clusters and the position for the change
points (Tl) should be defined as the number of observations (M).

``` r
d = 2 # two clusters
N = 5 # 5 data sequences
M = 50 # 50 observations for each data sequence
maxIter = 10 # number of Gibbs sampler iterations

data(data)

# initial values for each paramter and each cluster
par.values <- list(K = c(0, 0), Tl = list(50, 50), alpha = list(5, 10))

#cluster assignment for each data sequence
cluster <- kmeans(t(data), 2)$cluster

# variance for each data sequence
sigma2 <- apply(data, 2, var)

res <- run_gibbs(M, N, w = 10, d, as = 2, bs = 100, al = 2, bl = 1000, a = 2, 
b = 1000, alpha0 = 1/100, lambda = 2, maxIter = 10, par.values,
data, cluster, sigma2)

res$clusters[maxIter,]
# 3 7 7 7 7
```
