# R Package `BayesMoFo`

Carry out Bayesian estimation and forecasting of a variety of stochastic mortality models using vague prior distributions. 
The structure of mortality data that we focus on analysing is a three-dimensional array of dimension $p \times A \times T$ (strata $\times$ age $\times$ year), i.e., stratified mortality data. 
The stratification can be based on various factors such as: causes of death, countries, deprivation levels, gender/sex, geographical locations/regions, insurance products, marital statuses, socioeconomic groups, smoking behaviours, etc. 
While the primary focus of the package is on stratified mortality data ($p > 1$), it is also capable of analysing unstratified mortality data defined over age and time only (i.e., $p = 1$). 
Model selection, using Deviance Information Criterion (DIC), is also supported within the package.

## Documentation

The PDF documentation containing descriptions of all data and functions in the package is in the manual "BayesMoFo.pdf". The vignette file also contains a general tutorial on how to use the package.

## Installation guide

To install the latest *stable release* of the `BayesMoFo` package from CRAN:

`install.packages("BayesMoFo")`

To install the *development version* with the latest (possibly unstable) updates from GitHub:

`install.packages("devtools")`

`devtools::install_github("jstw1g09/Rpackage-BayesMoFo")`

Note that the GitHub version may contain experimental features or be under active development. For practical use, we recommend the CRAN stable release.

The package can then be loaded as:

`library(BayesMoFo)`

## Some limitations

- Current version does not allow user-specified prior distributions.
- The projection models for time and cohort effects ($\kappa_t$ and $\gamma_c$) are pre-defined. It might be more appropriate to allow customisations or to perform model selection.
- It is not optimised in terms of computational speed and memory management (can occupy considerable RAM).
