test.Mack1993 <- function() {
  ## by Eric Dal Moro
  ## Check the additional Skewness elements addedto MachChainLadder function on the Mack 1993 triangles
  ## Results are in the paper by Eric Dal Moro:
  ## "An approximation of the non-life reserve risk distribution using the Cornish-Fisher expansion"
  ## available at SSRN: https://ssrn.com/abstract=2965384
  Test <- MackChainLadder(GenIns, est.sigma="Mack")
  q <- quantile(Test,0.65)
  ## Table 1 in the above paper
  
  Skewness <- c(0, 0, -0.029, -0.043, -0.001, 0.180, 0.055, 0.267, 0.286, 0.314)
  OverSkew <- 0.214
  
  ## test output from MackChainLadder
  checkEquals(q$ByOrigin$Skewness, Skewness,tol=0.0015, checkNames = FALSE)
  checkEquals(q$Totals$Totals[1], OverSkew,tol=0.0015, checkNames = FALSE)
}

test.SCORLiabProp <- function() {
  ## by Eric Dal Moro
  ## Check the additional Skewness elements addedto MachChainLadder function on the Mack 1993 triangles
  ## Results are in the paper by Eric Dal Moro:
  ## "An approximation of the non-life reserve risk distribution using the Cornish-Fisher expansion"
  ## available at SSRN: https://ssrn.com/abstract=2965384
  
  SCORLiabProp <- structure(
    list(V1 = c(1235909L, 1377332L, 2227264L, 6063523L, 
                17046209L, 19133946L, 15294531L, 18460498L, 23542477L, 17341979L, 
                19850416L, 16449001L, 27153648L, 30745977L, 14911754L), V2 = c(28084788L, 
                                                                               35709204L, 38477741L, 77188565L, 118335598L, 129368180L, 146782533L, 
                                                                               117030644L, 113067832L, 122713595L, 134682628L, 125616958L, 144171990L, 
                                                                               141700503L, NA), V3 = c(36277376L, 43213075L, 50151725L, 106217291L, 
                                                                                                       149317461L, 158428296L, 181032613L, 146526379L, 125103424L, 142017246L, 
                                                                                                       163649787L, 155143936L, 164553451L, NA, NA), V4 = c(40475255L, 
                                                                                                                                                           51753287L, 53966008L, 113964643L, 158231476L, 161509739L, 182220943L, 
                                                                                                                                                           132681719L, 143385679L, 154409430L, 168464316L, 158477086L, NA, 
                                                                                                                                                           NA, NA), V5 = c(43219640L, 56669470L, 54671130L, 120412934L, 
                                                                                                                                                                           169819782L, 164007156L, 171358201L, 130134713L, 143172588L, 144452872L, 
                                                                                                                                                                           170525178L, NA, NA, NA, NA), V6 = c(44663902L, 57444929L, 57692644L, 
                                                                                                                                                                                                               126472874L, 171982468L, 161788099L, 171997288L, 124721542L, 130016839L, 
                                                                                                                                                                                                               134267844L, NA, NA, NA, NA, NA), V7 = c(45326054L, 59800911L, 
                                                                                                                                                                                                                                                       60487201L, 124422859L, 171861629L, 163095804L, 170664146L, 133009259L, 
                                                                                                                                                                                                                                                       125328953L, NA, NA, NA, NA, NA, NA), V8 = c(48497970L, 61566321L, 
                                                                                                                                                                                                                                                                                                   61814232L, 128806243L, 180041898L, 160465113L, 171561713L, 136533267L, 
                                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA), V9 = c(49233469L, 62121477L, 61750678L, 
                                                                                                                                                                                                                                                                                                                                       127982137L, 178223074L, 165298176L, 169645162L, NA, NA, NA, NA, 
                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA), V10 = c(49550622L, 62876588L, 62642901L, 125512850L, 
                                                                                                                                                                                                                                                                                                                                                                178218074L, 166467315L, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
         V11 = structure(c(4L, 6L, 5L, 2L, 3L, 1L, 1L, 1L, 1L, 1L, 
                           1L, 1L, 1L, 1L, 1L), .Label = c("", "134339552", "180474109", 
                                                           "49690989.5", "62622432", "62731073"), class = "factor"), 
         V12 = c(49831357L, 63128635L, 61843626L, 135190968L, NA, 
                 NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), V13 = c(50360419L, 
                                                                  63478522L, 62208577L, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
                                                                  NA, NA, NA), V14 = c(49973713L, 63123300L, NA, NA, NA, NA, 
                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA), V15 = c(49862952L, NA, 
                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA)), class = "data.frame", row.names = c(NA, 
                                                                                                                                                                                                                              -15L))
  Test <- MackChainLadder(SCORLiabProp, est.sigma="Mack")
  q<-quantile(Test,0.65)
  ## Table 1 in the above paper
  
  Skewness <- c(0, 0, -0.032, 0.157, -0.416, 0.542, 0.418, 0.392, 0.203, 0.226, 0.036, 0.048, 0.015, 0.060, 0.925)
  OverSkew <- 0.534
  
  ## test output from MackChainLadder
  checkEquals(q$ByOrigin$Skewness, Skewness,tol=0.0015, checkNames = FALSE)
  checkEquals(q$Totals$Totals[1], OverSkew,tol=0.0015, checkNames = FALSE)
}

test.SCORMotorNP <- function() {
  ## by Eric Dal Moro
  ## Check the additional Skewness elements addedto MachChainLadder function on the Mack 1993 triangles
  ## Results are in the paper by Eric Dal Moro:
  ## "An approximation of the non-life reserve risk distribution using the Cornish-Fisher expansion"
  ## available at SSRN: https://ssrn.com/abstract=2965384
  
  SCORMotorNP <- structure(list(V1 = c(10423937L, 19822329L, 16289990L, 17124281L, 
                                       20515740L, 33482519L, 27392045L, 19607049L, 14194503L, 19089137L, 
                                       22663556L, 24538834L, 19272742L, 14389656L, 17306007L), V2 = c(38199157L, 
                                                                                                      62295888L, 85826755L, 57203907L, 74875340L, 92014269L, 96643323L, 
                                                                                                      61499050L, 36060482L, 53803738L, 54418824L, 71839634L, 54901732L, 
                                                                                                      45362116L, NA), V3 = c(56447001L, 67897838L, 104560866L, 88346499L, 
                                                                                                                             112483709L, 129305456L, 123004812L, 81282483L, 42749759L, 66496545L, 
                                                                                                                             73046329L, 88048826L, 68136199L, NA, NA), V4 = c(65220946L, 78668550L, 
                                                                                                                                                                              121691315L, 109965887L, 132861474L, 150572754L, 144947690L, 88308523L, 
                                                                                                                                                                              48177878L, 76630418L, 82194820L, 99525306L, NA, NA, NA), V5 = c(69971047L, 
                                                                                                                                                                                                                                              87437467L, 142404493L, 118628540L, 155637649L, 163499855L, 145787570L, 
                                                                                                                                                                                                                                              91759024L, 56986475L, 87210128L, 89086080L, NA, NA, NA, NA), 
                                V6 = c(75438044L, 101244678L, 148725556L, 126194567L, 169622852L, 
                                       165457892L, 148529812L, 92962986L, 61193539L, 93216641L, 
                                       NA, NA, NA, NA, NA), V7 = c(82032154L, 105098260L, 153628342L, 
                                                                   135670962L, 178165835L, 172624920L, 151376613L, 92866952L, 
                                                                   61669910L, NA, NA, NA, NA, NA, NA), V8 = c(88917308L, 106590001L, 
                                                                                                              160474637L, 137597240L, 184091134L, 174772280L, 153343145L, 
                                                                                                              92770919L, NA, NA, NA, NA, NA, NA, NA), V9 = c(90783545L, 
                                                                                                                                                             113349293L, 165538675L, 139736825L, 191246803L, 182143897L, 
                                                                                                                                                             156330256L, NA, NA, NA, NA, NA, NA, NA, NA), V10 = c(95891585L, 
                                                                                                                                                                                                                  115150660L, 169936112L, 139880019L, 195323123L, 184582942L, 
                                                                                                                                                                                                                  NA, NA, NA, NA, NA, NA, NA, NA, NA), V11 = c(96943325L, 117761459L, 
                                                                                                                                                                                                                                                               173201144L, 142610492L, 203866747L, NA, NA, NA, NA, NA, NA, 
                                                                                                                                                                                                                                                               NA, NA, NA, NA), V12 = c(99646098L, 119647411L, 176369649L, 
                                                                                                                                                                                                                                                                                        145133035L, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
                                V13 = c(104075520L, 125137281L, 177284240L, NA, NA, NA, NA, 
                                        NA, NA, NA, NA, NA, NA, NA, NA), V14 = c(105688533L, 128007498L, 
                                                                                 NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), V15 = c(107081042L, 
                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA)), class = "data.frame", row.names = c(NA, 
                                                                                                                                                                                                                                            -15L))
  Test <- MackChainLadder(SCORMotorNP, est.sigma="Mack")
  q<-quantile(Test,0.65)
  ## Table 1 in the above paper
  
  Skewness <- c(0, 0, -0.037, -0.138, -0.115, -0.026, 0.059, 0.101, 0.236, 0.185, 0.271, 0.142, 0.174, 0.278, 1.001)
  OverSkew <- 0.333
  
  ## test output from MackChainLadder
  checkEquals(q$ByOrigin$Skewness, Skewness,tol=0.0015, checkNames = FALSE)
  checkEquals(q$Totals$Totals[1], OverSkew,tol=0.0015, checkNames = FALSE)
}

test.EverestLiabProp <- function() {
  ## by Eric Dal Moro
  ## Check the additional Skewness elements addedto MachChainLadder function on the Mack 1993 triangles
  ## Results are in the paper by Eric Dal Moro:
  ## "An approximation of the non-life reserve risk distribution using the Cornish-Fisher expansion"
  ## available at SSRN: https://ssrn.com/abstract=2965384
  EverestLiabProp <- 
    structure(list(V1 = structure(c(14L, 12L, 7L, 5L, 8L, 13L, 6L, 
                                    4L, 11L, 1L, 15L, 2L, 3L, 9L, 10L), .Label = c("10246.43364", 
                                                                                   "11966.76086", "12389.8289", "14989.26158", "15034.82007", "17052.61259", 
                                                                                   "19800.40144", "22740.82325", "23208.95429", "23597.23168", "26036.49293", 
                                                                                   "30331.90775", "30487.559", "36876.5904", "9095.21897"), class = "factor"), 
                   V2 = structure(c(4L, 5L, 13L, 8L, 2L, 6L, 3L, 12L, 15L, 11L, 
                                    14L, 7L, 10L, 9L, 1L), .Label = c("", "106402.1415", "112551.2839", 
                                                                      "140848.3857", "157220.7398", "179295.6903", "75167.85228", 
                                                                      "77036.98736", "80971.43469", "81222.54378", "82892.07045", 
                                                                      "86528.25398", "87915.79907", "91460.21805", "96951.10339"
                                    ), class = "factor"), V3 = structure(c(11L, 13L, 5L, 2L, 
                                                                           7L, 14L, 10L, 9L, 8L, 6L, 12L, 4L, 3L, 1L, 1L), .Label = c("", 
                                                                                                                                      "110772.902", "157514.838", "163572.4168", "173819.4772", 
                                                                                                                                      "179779.8443", "183879.5461", "184718.5317", "189239.0202", 
                                                                                                                                      "190082.4979", "196020.3914", "200206.9786", "231052.1068", 
                                                                                                                                      "266713.4487"), class = "factor"), V4 = structure(c(3L, 10L, 
                                                                                                                                                                                          7L, 2L, 5L, 13L, 8L, 6L, 9L, 11L, 12L, 4L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                             "141775.4169", "217210.7681", "228819.5142", "231279.1431", 
                                                                                                                                                                                                                                                             "242857.9138", "247546.6685", "254535.9137", "260475.7492", 
                                                                                                                                                                                                                                                             "266469.9219", "275120.2921", "302001.2452", "322505.5772"
                                                                                                                                                                                          ), class = "factor"), V5 = structure(c(3L, 8L, 5L, 2L, 4L, 
                                                                                                                                                                                                                                 12L, 6L, 7L, 9L, 11L, 10L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                        "162717.2621", "241180.0026", "270510.6505", "287608.1862", 
                                                                                                                                                                                                                                                                                        "292175.5239", "302521.43", "307192.5355", "314292.0504", 
                                                                                                                                                                                                                                                                                        "345288.0338", "345622.7611", "358495.8164"), class = "factor"), 
                   V6 = structure(c(3L, 7L, 6L, 2L, 4L, 11L, 5L, 8L, 9L, 10L, 
                                    1L, 1L, 1L, 1L, 1L), .Label = c("", "170209.8253", "260293.4868", 
                                                                    "289426.7806", "309153.7089", "318432.9035", "330973.5113", 
                                                                    "336121.9976", "370283.8048", "385155.3338", "388816.7237"
                                    ), class = "factor"), V7 = structure(c(3L, 8L, 6L, 2L, 4L, 
                                                                           10L, 5L, 7L, 9L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                "175176.8713", "269774.398", "298728.9968", "347308.4394", 
                                                                                                                                "353917.4185", "355555.9263", "366930.7128", "373355.5652", 
                                                                                                                                "400856.4437"), class = "factor"), V8 = structure(c(3L, 8L, 
                                                                                                                                                                                    7L, 2L, 4L, 9L, 5L, 6L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                    "181045.1928", "280547.3895", "317636.005", "350355.6888", 
                                                                                                                                                                                                                                                    "362170.5627", "365497.5958", "397231.3802", "409483.8956"
                                                                                                                                                                                    ), class = "factor"), V9 = structure(c(3L, 7L, 6L, 2L, 4L, 
                                                                                                                                                                                                                           8L, 5L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", "188111.0313", 
                                                                                                                                                                                                                                                                               "285868.2907", "318600.5707", "352107.614", "373239.2429", 
                                                                                                                                                                                                                                                                               "400229.8033", "414233.5787"), class = "factor"), V10 = structure(c(3L, 
                                                                                                                                                                                                                                                                                                                                                   6L, 5L, 2L, 4L, 7L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                       "189062.0699", "285422.4511", "319543.6974", "371967.3318", 
                                                                                                                                                                                                                                                                                                                                                                                                                       "401874.2856", "421622.0302"), class = "factor"), V11 = structure(c(3L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           6L, 5L, 2L, 4L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "192628.1888", "287229.4003", "321864.6556", "357969.3852", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "402541.3146"), class = "factor"), V12 = structure(c(3L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    5L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        "193112.6453", "288844.1791", "362053.5247", "406851.5549"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ), class = "factor"), V13 = structure(c(2L, 4L, 3L, 1L, 1L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", "292834.6376", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "362610.3615", "407249.6905"), class = "factor"), V14 = structure(c(2L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        "293091.3643", "401579.9039"), class = "factor"), V15 = structure(c(2L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "293894.6895"), class = "factor")), class = "data.frame", row.names = c(NA, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        -15L))
  Test <- MackChainLadder(EverestLiabProp, est.sigma="Mack")
  q<-quantile(Test,0.65)
  ## Table 1 in the above paper
  
  Skewness <- c(0, 0, 0.042, 0.087, 0.065, -0.268, -0.234, -0.164, 0.075, 0.157, 0.245, 0.289, 0.168, 0.231, 0.547)
  OverSkew <- 0.321
  
  ## test output from MackChainLadder
  checkEquals(q$ByOrigin$Skewness, Skewness,tol=0.0015, checkNames = FALSE)
  checkEquals(q$Totals$Totals[1], OverSkew,tol=0.0015, checkNames = FALSE)
}

test.EverestLiabNP <- function() {
  ## by Eric Dal Moro
  ## Check the additional Skewness elements addedto MachChainLadder function on the Mack 1993 triangles
  ## Results are in the paper by Eric Dal Moro:
  ## "An approximation of the non-life reserve risk distribution using the Cornish-Fisher expansion"
  ## available at SSRN: https://ssrn.com/abstract=2965384
  
  EverestLiabNP <-
    structure(list(V1 = structure(c(12L, 5L, 1L, 9L, 3L, 11L, 14L, 
                                    2L, 15L, 13L, 8L, 4L, 10L, 6L, 7L), .Label = c("13487.22446", 
                                                                                   "13601.21197", "14156.05241", "15008.1105", "16277.70345", "17061.02818", 
                                                                                   "17290.72214", "18237.28932", "20508.30826", "21591.94393", "30721.08172", 
                                                                                   "46760.60193", "7085.357535", "7305.207426", "9656.973343"), class = "factor"), 
                   V2 = structure(c(2L, 15L, 11L, 14L, 12L, 13L, 3L, 7L, 5L, 
                                    4L, 9L, 8L, 10L, 6L, 1L), .Label = c("", "111719.3417", "38247.68233", 
                                                                         "48158.19048", "48466.35934", "50129.18197", "54170.45943", 
                                                                         "56672.38118", "57128.59988", "62379.84002", "64108.57119", 
                                                                         "64518.4658", "71996.15154", "76554.87292", "98774.76192"
                                    ), class = "factor"), V3 = structure(c(8L, 7L, 5L, 6L, 4L, 
                                                                           12L, 9L, 10L, 13L, 2L, 3L, 14L, 11L, 1L, 1L), .Label = c("", 
                                                                                                                                    "103903.4474", "108752.239", "118329.7139", "137044.5158", 
                                                                                                                                    "158876.1332", "199365.1559", "200320.1304", "67827.27694", 
                                                                                                                                    "76370.26183", "88974.99053", "91632.6811", "96303.45733", 
                                                                                                                                    "96719.5756"), class = "factor"), V4 = structure(c(11L, 10L, 
                                                                                                                                                                                       9L, 8L, 7L, 2L, 12L, 13L, 4L, 6L, 5L, 3L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                         "122357.4179", "122553.9778", "128290.0558", "148642.6167", 
                                                                                                                                                                                                                                                         "149927.1491", "161614.475", "205166.6118", "225561.7252", 
                                                                                                                                                                                                                                                         "300592.385", "307924.4259", "92922.00769", "96750.2668"), class = "factor"), 
                   V5 = structure(c(12L, 11L, 10L, 9L, 8L, 5L, 2L, 3L, 4L, 6L, 
                                    7L, 1L, 1L, 1L, 1L), .Label = c("", "110462.8506", "117890.6472", 
                                                                    "150367.2558", "151180.1638", "167151.7234", "177825.2832", 
                                                                    "190324.306", "289669.705", "294301.0502", "386756.2697", 
                                                                    "390393.5155"), class = "factor"), V6 = structure(c(10L, 
                                                                                                                        11L, 9L, 8L, 7L, 5L, 2L, 3L, 4L, 6L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                             "119865.282", "128013.3674", "156742.0401", "172285.9609", 
                                                                                                                                                                                             "186972.1784", "222191.2372", "341325.6987", "348384.9662", 
                                                                                                                                                                                             "447214.7594", "450659.4391"), class = "factor"), V7 = structure(c(9L, 
                                                                                                                                                                                                                                                                10L, 7L, 8L, 6L, 5L, 3L, 2L, 4L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                     "127441.7619", "128818.542", "164004.4024", "176968.5872", 
                                                                                                                                                                                                                                                                                                                                     "253620.8479", "381020.7083", "396566.8562", "478440.6414", 
                                                                                                                                                                                                                                                                                                                                     "503910.8058"), class = "factor"), V8 = structure(c(8L, 9L, 
                                                                                                                                                                                                                                                                                                                                                                                         6L, 7L, 5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                         "133228.798", "133455.1831", "185704.0347", "271621.4606", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                         "396413.1669", "412016.2346", "496763.0668", "532179.1653"
                                                                                                                                                                                                                                                                                                                                                                                         ), class = "factor"), V9 = structure(c(7L, 8L, 5L, 6L, 4L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                3L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", "140558.7505", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "183775.9392", "284278.1226", "409978.4846", "426038.9289", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "515705.6548", "559183.434"), class = "factor"), V10 = structure(c(6L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       7L, 4L, 5L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           "186713.7108", "290607.9122", "415996.405", "437417.0563", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           "528866.4506", "598937.7059"), class = "factor"), V11 = structure(c(5L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               6L, 3L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   "295659.6674", "417044.4002", "455037.9521", "537367.3064", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   "629929.7835"), class = "factor"), V12 = structure(c(4L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        5L, 2L, 3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            "421067.7427", "461282.2011", "546360.2662", "643214.2754"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ), class = "factor"), V13 = structure(c(3L, 4L, 2L, 1L, 1L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", "425868.262", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "554378.5544", "655053.977"), class = "factor"), V14 = structure(c(2L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       3L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           "558865.8598", "666091.3122"), class = "factor"), V15 = structure(c(2L, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c("", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   "559492.5341"), class = "factor")), class = "data.frame", row.names = c(NA, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           -15L))
  
  Test <- MackChainLadder(EverestLiabNP, est.sigma="Mack")
  q<-quantile(Test,0.65)
  ## Table 1 in the above paper
  
  Skewness <- c(0, 0, -0.024, -0.016, -0.008, 0.100, 0.399, 0.241, 0.229, 0.129, 0.034, 0.224, 0.340, 0.017, 0.485)
  OverSkew <- 0.318
  
  ## test output from MackChainLadder
  checkEquals(q$ByOrigin$Skewness, Skewness,tol=0.0015, checkNames = FALSE)
  checkEquals(q$Totals$Totals[1], OverSkew,tol=0.0015, checkNames = FALSE)
}
