/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.randvar.StudentGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class StudentPolarGen
extends StudentGen {
    private int n;
    private boolean available = false;
    private double[] variates = new double[2];
    private static double[] staticVariates = new double[2];

    public StudentPolarGen(RandomStream randomStream, StudentDist studentDist) {
        super(randomStream, studentDist);
        this.n = studentDist.getN();
    }

    public double nextDouble() {
        if (this.available) {
            this.available = false;
            return this.variates[1];
        }
        StudentPolarGen.polar(this.stream, this.n, this.variates);
        this.available = true;
        return this.variates[0];
    }

    public static double nextDouble(RandomStream randomStream, int n) {
        StudentPolarGen.polar(randomStream, n, staticVariates);
        return staticVariates[0];
    }

    private static void polar(RandomStream randomStream, int n, double[] dArray) {
        double d;
        double d2;
        double d3;
        while ((d3 = (d2 = 2.0 * randomStream.nextDouble() - 1.0) * d2 + (d = 2.0 * randomStream.nextDouble() - 1.0) * d) > 1.0) {
        }
        double d4 = Math.sqrt((double)n * (Math.exp(-2.0 / (double)n * Math.log(d3)) - 1.0) / d3);
        dArray[0] = d2 * d4;
        dArray[1] = d * d4;
    }
}

