/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.analysis;

import ec.tstoolkit.timeseries.analysis.DiagnosticTsFunction;
import ec.tstoolkit.timeseries.simplets.TsDataFunction;

public enum DiagnosticInfo {
    AbsoluteDifference,
    RelativeDifference,
    PeriodToPeriodGrowthDifference,
    PeriodToPeriodDifference,
    AnnualGrowthDifference,
    AnnualDifference;


    public DiagnosticTsFunction asFunction() {
        switch (this.ordinal()) {
            case 0: {
                return (ref, s, pos) -> ref.get(pos) - s.get(pos);
            }
            case 1: {
                return (ref, s, pos) -> {
                    double T2 = ref.get(pos);
                    return 100.0 * (T2 - s.get(pos)) / T2;
                };
            }
            case 2: {
                return (ref, s, pos) -> 100.0 * (ref.get(pos) / ref.get(pos - 1) - s.get(pos) / s.get(pos - 1));
            }
            case 3: {
                return (ref, s, pos) -> ref.get(pos) - ref.get(pos - 1) - (s.get(pos) - s.get(pos - 1));
            }
            case 4: {
                return (ref, s, pos) -> {
                    int lag = ref.getFrequency().intValue();
                    return 100.0 * (ref.get(pos) / ref.get(pos - lag) - s.get(pos) / s.get(pos - lag));
                };
            }
            case 5: {
                return (ref, s, pos) -> {
                    int lag = ref.getFrequency().intValue();
                    return ref.get(pos) - ref.get(pos - lag) - (s.get(pos) - s.get(pos - lag));
                };
            }
        }
        return (ref, s, pos) -> Double.NaN;
    }

    public TsDataFunction asTsDataFunction() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return (s, pos) -> s.get(pos);
            }
            case 2: {
                return (s, pos) -> 100.0 * (s.get(pos) / s.get(pos - 1) - 1.0);
            }
            case 3: {
                return (s, pos) -> s.get(pos) - s.get(pos - 1);
            }
            case 4: {
                return (s, pos) -> 100.0 * (s.get(pos) / s.get(pos - s.getFrequency().intValue()) - 1.0);
            }
            case 5: {
                return (s, pos) -> s.get(pos) - s.get(pos - s.getFrequency().intValue());
            }
        }
        return (s, pos) -> Double.NaN;
    }

    public DiagnosticInfo adaptForNegativeValues() {
        switch (this.ordinal()) {
            case 1: {
                return AbsoluteDifference;
            }
            case 2: {
                return PeriodToPeriodDifference;
            }
            case 4: {
                return AnnualDifference;
            }
        }
        return this;
    }

    public boolean isRelative() {
        return this == RelativeDifference || this == PeriodToPeriodGrowthDifference || this == AnnualGrowthDifference;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "Absolute differences";
            }
            case 1: {
                return "Relative differences (%)";
            }
            case 2: {
                return "Period to period growth differences (%)";
            }
            case 3: {
                return "Period to period differences";
            }
            case 4: {
                return "Annual growth differences (%)";
            }
            case 5: {
                return "Annual differences";
            }
        }
        return null;
    }
}

