
## `StabilityApp`: Stability Analysis App for Genotype by Environment Interaction (GEI) in Multi-Environment Trials

###### Version : [0.1.0](https://myaseen208.com/StabilityApp/); Copyright (C) 2024: License: [GPL-2\|GPL-3](https://www.r-project.org/Licenses/)

##### *Muhammad Yaseen<sup>1,2</sup>, and Kent M. Eskridge<sup>3</sup>*

1.  [School of Mathematical & Statistical Sciences, Clemson University,
    Clemson, South Carolina,
    USA](https://www.clemson.edu/science/academics/departments/mathstat/about/profiles/myaseen)
2.  Department of Mathematics and Statistics, University of Agriculture
    Faisalabad, Pakistan
3.  [Department of Statistics, University of Nebraska Lincoln, NE,
    USA](https://statistics.unl.edu/kent-m-eskridge)

------------------------------------------------------------------------

[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.5.0-6666ff.svg)](https://cran.r-project.org/)
[![License: GPL
v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version-last-release/StabilityApp)](https://cran.r-project.org/package=StabilityApp)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/StabilityApp?color=green)](https://CRAN.R-project.org/package=StabilityApp)
<!-- [![packageversion](https://img.shields.io/badge/Package%20version-0.2.3.3-orange.svg)](https://github.com/myaseen208/StabilityApp) -->

<!-- [![GitHub Download Count](https://github-basic-badges.herokuapp.com/downloads/myaseen208/StabilityApp/total.svg)] -->

[![Project Status:
WIP](https://www.repostatus.org/badges/latest/inactive.svg)](https://www.repostatus.org/#inactive)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![Last-changedate](https://img.shields.io/badge/last%20change-2024--10--26-yellowgreen.svg)](https://github.com/myaseen208/StabilityApp)
\*\*\*

## Description

Provides tools for Genotype by Environment Interaction (GEI) analysis,
using statistical models and visualizations to assess genotype
performance across environments. It helps researchers explore
interaction effects, stability, and adaptability in multi-environment
trials, identifying the best-performing genotypes in different
conditions. Which Win Where!

## Installation

The package can be installed from CRAN as follows:

``` r
install.packages("StabilityApp", dependencies = TRUE)
```

The development version can be installed from github as follows:

``` r
if (!require("remotes")) install.packages("remotes")
remotes::install_github("myaseen208/StabilityApp")
```

## What’s new

To know whats new in this version type:

``` r
news(package = "StabilityApp")
```

## Links

[Shiny App](https://myaseen208.shinyapps.io/StabilityApp/)

[CRAN page](https://cran.r-project.org/package=StabilityApp)

[Github page](https://github.com/myaseen208/StabilityApp)

[Documentation website](https://myaseen208.com/StabilityApp/)

## Citing `StabilityApp`

To cite the methods in the package use:

``` r
citation("StabilityApp")
Warning in citation("StabilityApp"): could not determine year for
'StabilityApp' from package DESCRIPTION file
To cite package 'StabilityApp' in publications use:

  Yaseen M, Eskridge KM (????). _StabilityApp: Stability Analysis App
  for Genotype by Environment Interaction (GEI) in Multi-Environment
  Trials_. R package version 0.1.0.

A BibTeX entry for LaTeX users is

  @Manual{,
    title = {StabilityApp: Stability Analysis App for Genotype by Environment Interaction (GEI) in Multi-Environment Trials},
    author = {Muhammad Yaseen and Kent M. Eskridge},
    note = {R package version 0.1.0},
  }
```
