
## `baystability`: Bayesian Stability Analysis of Genotype by Environment Interaction (GEI)

###### Version : [0.1.0](https://myaseen208.com/baystability/); Copyright (C) 2018-2024: License: [GPL-2\|GPL-3](https://www.r-project.org/Licenses/)

##### *Muhammad Yaseen<sup>1,2</sup>, Diego Jarquin<sup>3</sup>, Sergio Perez-Elizalde<sup>4</sup>, Juan Burgueño<sup>5</sup>, Jose Crossa<sup>6,7,8,9</sup>*

1.  School of Mathematical & Statistical Sciences, Clemson University,
    Clemson, South Carolina, USA
2.  Department of Mathematics & Statistics, University of Agriculture
    Faisalabad, Pakistan
3.  Agronomy Department, University of Florida, Gainesville, FL, United
    States
4.  Colegio de Postgraduados, Montecillo,Estado de México 56230, México
5.  Consultative Group on International Agricultural Research: CGIAR
6.  Department of Statistics and Operations Research, and Distinguish
    Scientist Fellowship Program, King Saud University, Riyah, Saudi
    Arabia
7.  AgCenter, Louisiana State University, Baton Rouge, Louisiana, USA
8.  Colegio de Postgraduados, Montecillos, Mexico
9.  International Maize and Wheat Improvement Center (CIMMYT),
    Mexico-Veracruz, Mexico

------------------------------------------------------------------------

[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.5.0-6666ff.svg)](https://cran.r-project.org/)
[![License: GPL
v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version-last-release/baystability)](https://cran.r-project.org/package=baystability)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/baystability?color=green)](https://CRAN.R-project.org/package=baystability)
<!-- [![packageversion](https://img.shields.io/badge/Package%20version-0.2.3.3-orange.svg)](https://github.com/myaseen208/baystability) -->

[![develVersion](https://img.shields.io/badge/devel%20version-0.1.0-orange.svg)](https://github.com/myaseen208/baystability)

<!-- [![GitHub Download Count](https://github-basic-badges.herokuapp.com/downloads/myaseen208/baystability/total.svg)] -->

[![Project Status:
WIP](https://www.repostatus.org/badges/latest/inactive.svg)](https://www.repostatus.org/#inactive)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![Last-changedate](https://img.shields.io/badge/last%20change-2024--10--11-yellowgreen.svg)](https://github.com/myaseen208/baystability)
\*\*\*

## Description

Performs general Bayesian estimation method of linear–bilinear models
for genotype × environment interaction. The method is explained in
Perez-Elizalde, S., Jarquin, D., and Crossa, J. (2011)
([doi:10.1007/s13253-011-0063-9](https://doi.org/10.1007/s13253-011-0063-9)).

## Installation

The package can be installed from CRAN as follows:

``` r
install.packages("baystability", dependencies = TRUE)
```

The development version can be installed from github as follows:

``` r
if (!require("remotes")) install.packages("remotes")
remotes::install_github("myaseen208/baystability")
```

## What’s new

To know whats new in this version type:

``` r
news(package = "baystability")
```

## Links

[CRAN page](https://cran.r-project.org/package=baystability)

[Github page](https://github.com/myaseen208/baystability)

[Documentation website](https://myaseen208.com/baystability/)

## Citing `baystability`

To cite the methods in the package use:

``` r
citation("baystability")
To cite package 'baystability' in publications use:

  Muhammad Yaseen, Diego Jarquin, Sergio Perez-Elizalde, Juan Burgueño,
  Jose Crossa (2018). _baystability: Bayesian Stability Analysis of
  Genotype by Environment Interaction (GEI)_. R package version 0.1.0,
  <https://CRAN.R-project.org/package=baystability>.

A BibTeX entry for LaTeX users is

  @Manual{,
    title = {baystability: Bayesian Stability Analysis of Genotype by Environment
Interaction (GEI)},
    author = {{Muhammad Yaseen} and {Diego Jarquin} and {Sergio Perez-Elizalde} and {Juan Burgueño} and {Jose Crossa}},
    year = {2018},
    note = {R package version 0.1.0},
    url = {https://CRAN.R-project.org/package=baystability},
  }
```
