/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PrintInputAndTarget;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.SvmLight2FeatureVectorAndLabel;
import cc.mallet.pipe.iterator.SelectiveFileLineIterator;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Logger;

public class SvmLight2Vectors {
    private static Logger logger = MalletLogger.getLogger(SvmLight2Vectors.class.getName());
    static CommandOption.SpacedStrings inputFiles = new CommandOption.SpacedStrings(SvmLight2Vectors.class, "input", "FILE", true, null, "The files containing data to be classified, one instance per line", null);
    static CommandOption.SpacedStrings outputFiles = new CommandOption.SpacedStrings(SvmLight2Vectors.class, "output", "FILE", true, null, "Write the instance list to this file; Using - indicates stdout.", null);
    static CommandOption.File usePipeFromVectorsFile = new CommandOption.File(SvmLight2Vectors.class, "use-pipe-from", "FILE", true, new File("text.vectors"), "Use the pipe and alphabets from a previously created vectors file.\n   That previous file is *rewritten* to include any newly observed features.\n   Allows the creation, for example, of a test set of vectors that are\n   compatible with a previously created set of training vectors", null);
    static CommandOption.File usePipeFromVectorsFileNoRewrite = new CommandOption.File(SvmLight2Vectors.class, "use-pipe-from-without-rewrite", "FILE", true, new File("text.vectors"), "Use the pipe and alphabets from a previously created vectors file.\n   *No change* is made to that previous file.\n   Allows the creation, for example, of a test set of vectors that are\n   compatible with a previously created set of training vectors", null);
    static CommandOption.Boolean printOutput = new CommandOption.Boolean(SvmLight2Vectors.class, "print-output", "[TRUE|FALSE]", false, false, "If true, print a representation of the processed data\n   to standard output. This option is intended for debugging.", null);
    static CommandOption.String encoding = new CommandOption.String(SvmLight2Vectors.class, "encoding", "STRING", true, Charset.defaultCharset().displayName(), "Character encoding for input file", null);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        int fileIndex;
        Pipe instancePipe;
        CommandOption.setSummary(SvmLight2Vectors.class, "A tool for creating instance lists of feature vectors from comma-separated-values");
        CommandOption.process(SvmLight2Vectors.class, args);
        if (args.length == 0) {
            CommandOption.getList(SvmLight2Vectors.class).printUsage(false);
            System.exit(-1);
        }
        if (inputFiles == null) {
            throw new IllegalArgumentException("You must include `--input FILE FILE ...' in order to specify files containing the instances, one per line.");
        }
        InstanceList previousInstanceList = null;
        if (usePipeFromVectorsFile.wasInvoked()) {
            previousInstanceList = InstanceList.load(SvmLight2Vectors.usePipeFromVectorsFile.value);
            instancePipe = previousInstanceList.getPipe();
        } else if (usePipeFromVectorsFileNoRewrite.wasInvoked()) {
            previousInstanceList = InstanceList.load(SvmLight2Vectors.usePipeFromVectorsFileNoRewrite.value);
            instancePipe = previousInstanceList.getPipe();
        } else {
            ArrayList<Pipe> pipeList = new ArrayList<Pipe>();
            pipeList.add(new SvmLight2FeatureVectorAndLabel());
            if (SvmLight2Vectors.printOutput.value) {
                pipeList.add(new PrintInputAndTarget());
            }
            instancePipe = new SerialPipes(pipeList);
        }
        if (SvmLight2Vectors.inputFiles.value.length != SvmLight2Vectors.outputFiles.value.length) {
            throw new RuntimeException("Number of input and output files must be the same.");
        }
        InstanceList[] instances = new InstanceList[SvmLight2Vectors.inputFiles.value.length];
        for (fileIndex = 0; fileIndex < SvmLight2Vectors.inputFiles.value.length; ++fileIndex) {
            instances[fileIndex] = new InstanceList(instancePipe);
            InputStreamReader fileReader = SvmLight2Vectors.inputFiles.value[fileIndex].equals("-") ? new InputStreamReader(System.in) : new InputStreamReader((InputStream)new FileInputStream(SvmLight2Vectors.inputFiles.value[fileIndex]), SvmLight2Vectors.encoding.value);
            instances[fileIndex].addThruPipe(new SelectiveFileLineIterator(fileReader, "^\\s*#.+"));
        }
        for (fileIndex = 0; fileIndex < SvmLight2Vectors.inputFiles.value.length; ++fileIndex) {
            instances[fileIndex].save(new File(SvmLight2Vectors.outputFiles.value[fileIndex]));
        }
        if (usePipeFromVectorsFile.wasInvoked()) {
            logger.info(" Rewriting extended pipe from " + SvmLight2Vectors.usePipeFromVectorsFile.value);
            logger.info("  Instance ID = " + previousInstanceList.getPipe().getInstanceId());
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(SvmLight2Vectors.usePipeFromVectorsFile.value));
            oos.writeObject(previousInstanceList);
            oos.close();
        }
    }
}

