## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(npdsim)

## ----include=FALSE------------------------------------------------------------
library(ggplot2)

## ----eval=TRUE----------------------------------------------------------------
npd_data1 <- npd_data_sim(products_number=100,
                         periods_number=30,
                         shape_number=5,
                         level_number=20)

str(npd_data1)


## ----eval=TRUE, echo=FALSE, fig.dim = c(8, 4)---------------------------------

npd_data1bis <- dplyr::filter(npd_data1, product_id %in% c(1,2,3,4,5))

ggplot(data=npd_data1bis)+
  geom_line(mapping=aes(x=time, 
                        y=demand,
                        linetype=factor(product_id)))+
  theme_bw()

## ----eval=TRUE----------------------------------------------------------------

npd_data2 <- npd_data_sim(products_number=10,
               periods_number=40,
               shape_number=5,
               shape_type="bass",
               level_number=20,
               level_range=1000:10000,
               noise_cv=0.05,
               attribute_type="ind",
               attributes_number=15,
               shape_attributes_number=7,
               level_attributes_number=5)

str(npd_data2)


## ----eval=TRUE, echo=FALSE, fig.dim = c(8, 4)---------------------------------

npd_data2bis <- dplyr::filter(npd_data2, product_id %in% c(1,2,3,4,5))

ggplot(data=npd_data2bis)+
  geom_line(mapping=aes(x=time, 
                        y=demand,
                        linetype=factor(product_id)))+
  theme_bw()

## ----eval=TRUE----------------------------------------------------------------
demand1 <- demand_sim(products_number=100,
                      periods_number=20,
                      shape_number=5, 
                      shape_type="bass", 
                      level_number=20,
                      level_range=1000:10000,
                      noise_cv=0.05)

## ----eval=TRUE----------------------------------------------------------------
shape1 <- shape_sim(periods_number=20,
                    shape_number=5,
                    shape_type="trapezoid")

head(shape1)

## ----eval=TRUE, echo=FALSE, fig.dim = c(8, 4)---------------------------------
ggplot(data=shape1)+
  geom_line(mapping=aes(x=time, 
                        y=shape,
                        linetype=factor(assigned_shape)))+
  theme_bw()

## ----eval=TRUE----------------------------------------------------------------
shape2 <- shape_sim(periods_number=20,
                    shape_number=5,
                    shape_type="random") #random is the default value


## ----eval=TRUE, echo=FALSE, fig.dim = c(8, 4)---------------------------------
ggplot(data=shape2)+
  geom_line(mapping=aes(x=time, 
                        y=shape,
                        linetype=factor(assigned_shape)))

## ----eval=TRUE----------------------------------------------------------------
shape3 <- shape_sim(periods_number=20,
                    shape_number=5,
                    shape_type="intro & growth")


## ----eval=TRUE, echo=FALSE, fig.dim = c(8, 4)---------------------------------
ggplot(data=shape3)+
  geom_line(mapping=aes(x=time, 
                        y=shape,
                        linetype=factor(assigned_shape)))

