/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Planner;

import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.StreetEdgeInfo;
import com.conveyal.r5.api.util.StreetSegment;
import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.profile.StreetPath;
import com.conveyal.r5.streets.EdgeStore;
import com.conveyal.r5.streets.StreetRouter;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.TripPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.ipea.r5r.Utils.Utils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;

public class TripLeg {
    private String mode;
    private boolean isTransfer = false;
    private boolean isTransit = false;
    private int legDurationSeconds;
    private int legDistance;
    private int cumulativeFare;
    private int boardStop;
    private int alightStop;
    private String boardStopId = "";
    private String alightStopId = "";
    private int fromStop;
    private int toStop;
    private int boardStopPosition;
    private int alightStopPosition;
    private TripPattern pattern;
    private int waitTime;
    private String route;
    private LineString geometry;
    private List<StreetEdgeInfo> streetEdges;
    private LinkedHashSet<Integer> listEdgeId = new LinkedHashSet();
    private LinkedHashSet<Long> listOSMId = new LinkedHashSet();

    public void setPatternData(TripPattern pattern, int boardStopPosition, int alightStopPosition) {
        this.pattern = pattern;
        this.boardStopPosition = boardStopPosition;
        this.alightStopPosition = alightStopPosition;
    }

    public void setODStops(int fromStop, int toStop) {
        this.fromStop = fromStop;
        this.toStop = toStop;
    }

    public String getMode() {
        return this.mode;
    }

    public int getLegDurationSeconds() {
        return this.legDurationSeconds;
    }

    public int getLegDistance() {
        return this.legDistance;
    }

    public int getCumulativeFare() {
        return this.cumulativeFare;
    }

    public int getBoardStop() {
        return this.boardStop;
    }

    public String getBoardStopId() {
        return this.boardStopId;
    }

    public int getAlightStop() {
        return this.alightStop;
    }

    public String getAlightStopId() {
        return this.alightStopId;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public String getRoute() {
        return this.route;
    }

    public LinkedHashSet<Long> getListOSMId() {
        return this.listOSMId;
    }

    public LinkedHashSet<Integer> getListEdgeId() {
        return this.listEdgeId;
    }

    public LineString getGeometry() {
        return this.geometry;
    }

    public static TripLeg newDirectLeg(String mode, StreetSegment streetSegment, EdgeStore edgeStore) {
        TripLeg newLeg = new TripLeg();
        newLeg.mode = mode;
        newLeg.legDistance = streetSegment.distance;
        newLeg.legDurationSeconds = streetSegment.duration;
        newLeg.cumulativeFare = 0;
        newLeg.route = "";
        newLeg.geometry = streetSegment.geometry;
        newLeg.streetEdges = streetSegment.streetEdges;
        if (edgeStore != null) {
            LinkedHashSet<Long> listOSMId = new LinkedHashSet<Long>();
            LinkedHashSet<Integer> listEdgeId = new LinkedHashSet<Integer>();
            for (StreetEdgeInfo u : newLeg.streetEdges) {
                int edgeId = u.edgeId;
                long osmId = edgeStore.getCursor(edgeId).getOSMID();
                if (osmId <= 0L) continue;
                listOSMId.add(osmId);
                listEdgeId.add(edgeId);
            }
            newLeg.listEdgeId = listEdgeId;
            newLeg.listOSMId = listOSMId;
        }
        return newLeg;
    }

    public static TripLeg newTransferLeg(String mode, int duration, int fare, LineString geometry, StreetSegment streetSegment, EdgeStore edgeStore) {
        TripLeg newLeg = new TripLeg();
        newLeg.mode = mode;
        newLeg.isTransfer = true;
        newLeg.legDistance = (int)geometry.getLength();
        newLeg.legDurationSeconds = duration;
        newLeg.cumulativeFare = fare;
        newLeg.route = "";
        if (edgeStore != null && streetSegment != null) {
            LinkedHashSet<Long> listOSMId = new LinkedHashSet<Long>();
            LinkedHashSet<Integer> listEdgeId = new LinkedHashSet<Integer>();
            for (StreetEdgeInfo u : streetSegment.streetEdges) {
                int edgeId = u.edgeId;
                long osmId = edgeStore.getCursor(edgeId).getOSMID();
                if (osmId <= 0L) continue;
                listOSMId.add(osmId);
                listEdgeId.add(edgeId);
            }
            newLeg.listEdgeId = listEdgeId;
            newLeg.listOSMId = listOSMId;
        }
        newLeg.geometry = geometry;
        return newLeg;
    }

    public static TripLeg newTransitLeg(String mode, int duration, int fare, int waitTime, int boardStop, int alightStop, String route) {
        TripLeg newLeg = new TripLeg();
        newLeg.mode = mode;
        newLeg.isTransit = true;
        newLeg.legDurationSeconds = duration;
        newLeg.cumulativeFare = fare;
        newLeg.waitTime = waitTime;
        newLeg.boardStop = boardStop;
        newLeg.alightStop = alightStop;
        newLeg.route = route;
        newLeg.boardStopId = "";
        newLeg.alightStopId = "";
        return newLeg;
    }

    public void augmentTransitLeg(MultiKeyMap<Integer, StreetSegment> transferPaths, TransportNetwork network, ProfileRequest request, Boolean OSMLinkIds) {
        if (this.isTransit) {
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            List hops = this.pattern.getHopGeometries(network.transitLayer);
            for (int i = this.boardStopPosition; i < this.alightStopPosition; ++i) {
                LineString hop = (LineString)hops.get(i);
                coords.addAll(Arrays.asList(hop.getCoordinates()));
            }
            this.geometry = GeometryUtils.geometryFactory.createLineString(coords.toArray(new Coordinate[0]));
            this.legDistance = Utils.getLinestringLength(this.geometry);
            if (OSMLinkIds.booleanValue()) {
                this.alightStopId = (String)network.transitLayer.stopIdForIndex.get(this.alightStop);
                this.boardStopId = (String)network.transitLayer.stopIdForIndex.get(this.boardStop);
            }
        } else if (this.fromStop > 0 & this.toStop > 0) {
            StreetSegment streetSegment = (StreetSegment)transferPaths.get((Object)this.fromStop, (Object)this.toStop);
            if (streetSegment == null) {
                boolean prevReverseSearch = request.reverseSearch;
                request.reverseSearch = false;
                StreetRouter streetRouter = new StreetRouter(network.streetLayer);
                streetRouter.streetMode = StreetMode.WALK;
                streetRouter.profileRequest = request;
                streetRouter.distanceLimitMeters = 1000;
                int stopVertexId = network.transitLayer.streetVertexForStop.get(this.fromStop);
                streetRouter.setOrigin(stopVertexId);
                Coordinate destStopCoord = network.transitLayer.getCoordinateForStopFixed(this.toStop);
                streetRouter.setDestination(destStopCoord.getY() / 1.0E7, destStopCoord.getX() / 1.0E7);
                streetRouter.route();
                StreetRouter.State lastState = streetRouter.getState(destStopCoord.getY() / 1.0E7, destStopCoord.getX() / 1.0E7);
                if (lastState != null) {
                    StreetPath streetPath = new StreetPath(lastState, network, false);
                    streetSegment = new StreetSegment(streetPath, LegMode.WALK, network.streetLayer);
                    this.legDurationSeconds = streetSegment.duration;
                    this.fillDataTransitLeg(network, OSMLinkIds, streetSegment);
                    transferPaths.put((Object)this.fromStop, (Object)this.toStop, (Object)streetSegment);
                }
                request.reverseSearch = prevReverseSearch;
            } else {
                this.fillDataTransitLeg(network, OSMLinkIds, streetSegment);
            }
        } else {
            this.legDistance = Utils.getLinestringLength(this.geometry);
        }
    }

    private void fillDataTransitLeg(TransportNetwork network, Boolean OSMLinkIds, StreetSegment streetSegment) {
        this.geometry = streetSegment.geometry;
        this.streetEdges = streetSegment.streetEdges;
        if (OSMLinkIds.booleanValue()) {
            LinkedHashSet<Long> listOSMId = new LinkedHashSet<Long>();
            LinkedHashSet<Integer> listEdgeId = new LinkedHashSet<Integer>();
            for (StreetEdgeInfo u : this.streetEdges) {
                int edgeId = u.edgeId;
                long osmId = network.streetLayer.edgeStore.getCursor(edgeId).getOSMID();
                if (osmId <= 0L) continue;
                listOSMId.add(osmId);
                listEdgeId.add(edgeId);
            }
            this.listEdgeId = listEdgeId;
            this.listOSMId = listOSMId;
        }
        this.legDistance = Utils.getLinestringLength(this.geometry);
    }

    public int augmentDirectLeg() {
        this.legDistance = Utils.getLinestringLength(this.geometry);
        return this.legDistance;
    }
}

