/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Utils;

import ch.qos.logback.classic.LoggerContext;
import com.conveyal.osmlib.OSM;
import com.conveyal.osmlib.Way;
import com.conveyal.r5.point_to_point.builder.SpeedConfig;
import com.conveyal.r5.point_to_point.builder.SpeedUnit;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.measure.UnitConverter;
import org.ipea.r5r.Utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.uom.common.USCustomary;
import tech.units.indriya.unit.Units;

public class SpeedSetter {
    private static final Logger LOG = LoggerFactory.getLogger(SpeedSetter.class);
    private final Path outputFilePath;
    private float defaultValue = 1.0f;
    private final OSM osmRoadNetwork;
    private final HashMap<Long, Float> speedMap;
    private SpeedSetterMode mode = SpeedSetterMode.PERCENTAGE;
    private float defaultSpeedForNoHwyTag;
    private final HashMap<String, Float> highwayDefaultSpeedMap;

    public SpeedSetter(String pbfFile, HashMap<Long, Float> speedMap, String outputFolder, boolean verbose) throws IOException {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger speedSetterLogger = loggerContext.getLogger("org.ipea.r5r.Utils.SpeedSetter");
        ch.qos.logback.classic.Logger osmLogger = loggerContext.getLogger("com.conveyal.osmlib");
        if (verbose) {
            Utils.setLogModeOther("INFO");
            Utils.setLogModeJar("INFO");
        } else {
            Utils.setLogModeOther("OFF");
            Utils.setLogModeJar("WARN");
        }
        Path outputFolderPath = Paths.get(outputFolder, new String[0]);
        if (!Files.exists(outputFolderPath, new LinkOption[0]) || !Files.isDirectory(outputFolderPath, new LinkOption[0])) {
            LOG.error("Output folder does not exist or is not a directory: {}", (Object)outputFolder);
            throw new IOException("Output folder does not exist or is not a directory: " + outputFolder);
        }
        Path pbfFilePath = Paths.get(pbfFile, new String[0]);
        if (!Files.exists(pbfFilePath, new LinkOption[0])) {
            LOG.error("PBF file not found: {}", (Object)pbfFilePath.toAbsolutePath());
            throw new IOException("Speeds CSV not found: " + String.valueOf(pbfFilePath.toAbsolutePath()));
        }
        this.outputFilePath = this.createOutputFilePath(pbfFilePath, outputFolderPath);
        this.osmRoadNetwork = new OSM(null);
        this.osmRoadNetwork.readFromFile(pbfFilePath.toAbsolutePath().toString());
        LOG.info("Loaded OSM network from file {}", (Object)pbfFilePath.getFileName());
        this.speedMap = speedMap;
        LOG.info("Loaded desired road speeds from table.");
        this.highwayDefaultSpeedMap = this.createHighwayDefaultSpeedMap();
    }

    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void runSpeedSetter() {
        LOG.info("Setting maxspeed:motorcar tags in {} mode", (Object)this.mode);
        this.modifyWaySpeeds();
        this.osmRoadNetwork.writeToFile(this.outputFilePath.toAbsolutePath().toString());
        LOG.info("Wrote modified OSM file to: {}", (Object)this.outputFilePath.toAbsolutePath());
    }

    private Path createOutputFilePath(Path pbfFilePath, Path outputFolderPath) {
        String originalPbfName = pbfFilePath.getFileName().toString();
        String newFileName = "congested-" + originalPbfName;
        return outputFolderPath.resolve(newFileName);
    }

    public void setPercentageMode(boolean modePercentage) {
        this.mode = modePercentage ? SpeedSetterMode.PERCENTAGE : SpeedSetterMode.ABSOLUTE;
    }

    public String verifySpeedMap() {
        ArrayList<Long> badIds = new ArrayList<Long>();
        for (Long potentialWayId : this.speedMap.keySet()) {
            Way way = (Way)this.osmRoadNetwork.ways.get(potentialWayId);
            if (way != null) continue;
            badIds.add(potentialWayId);
        }
        return badIds.toString();
    }

    private void modifyWaySpeeds() {
        for (Map.Entry entry : this.osmRoadNetwork.ways.entrySet()) {
            float speedKph;
            long wayId = (Long)entry.getKey();
            Way way = (Way)entry.getValue();
            Float value = this.speedMap.getOrDefault(wayId, Float.valueOf(this.defaultValue));
            if (value.floatValue() == 1.0f) continue;
            if (value.floatValue() == 0.0f) {
                way.addOrReplaceTag("highway", "construction");
                continue;
            }
            if (this.mode == SpeedSetterMode.ABSOLUTE) {
                speedKph = value.floatValue();
            } else {
                String existingSpeed = way.getTag("maxspeed");
                if (existingSpeed == null) {
                    LOG.debug("Way id: {} has no maxspeed tag, falling back on highway defaults", (Object)wayId);
                    if (way.getTag("highway") != null) {
                        String highwayType = way.getTag("highway").toLowerCase().trim();
                        existingSpeed = String.valueOf(this.highwayDefaultSpeedMap.getOrDefault(highwayType, Float.valueOf(this.defaultSpeedForNoHwyTag)));
                    } else {
                        existingSpeed = String.valueOf(this.defaultSpeedForNoHwyTag);
                    }
                }
                try {
                    float base = Float.parseFloat(existingSpeed);
                    speedKph = base * value.floatValue();
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Cannot parse existing maxspeed='{}' for way {}, skipping", (Object)existingSpeed, (Object)wayId);
                    continue;
                }
            }
            way.addOrReplaceTag("maxspeed:motorcar", String.format("%1.1f kph", Float.valueOf(speedKph)));
        }
    }

    private HashMap<String, Float> createHighwayDefaultSpeedMap() {
        SpeedConfig speedConfig = SpeedConfig.defaultConfig();
        HashMap<String, Float> highwaySpeedMap = new HashMap<String, Float>(speedConfig.values.size() + 1);
        if (speedConfig.units != SpeedUnit.MPH) {
            LOG.error("speedConfig is expected to be in MPH. Something has changed; skipping without generating a default highwaySpeedMap.");
            this.defaultSpeedForNoHwyTag = 40.0f;
            return highwaySpeedMap;
        }
        UnitConverter unitConverter = USCustomary.MILE_PER_HOUR.getConverterTo(Units.KILOMETRE_PER_HOUR);
        for (Map.Entry highwaySpeed : speedConfig.values.entrySet()) {
            highwaySpeedMap.put((String)highwaySpeed.getKey(), Float.valueOf(unitConverter.convert((Number)highwaySpeed.getValue()).floatValue()));
        }
        this.defaultSpeedForNoHwyTag = (float)unitConverter.convert((double)speedConfig.defaultSpeed);
        return highwaySpeedMap;
    }

    public static enum SpeedSetterMode {
        ABSOLUTE,
        PERCENTAGE;

    }
}

