/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public abstract class ViewDeltaMonitor
implements IIntDeltaMonitor {
    private final IIntDeltaMonitor deltamonitor;
    private final TIntArrayList values;
    private final Filler filler;

    public ViewDeltaMonitor(IIntDeltaMonitor deltamonitor) {
        this.deltamonitor = deltamonitor;
        this.values = new TIntArrayList(8);
        this.filler = new Filler();
    }

    @Override
    public void startMonitoring() {
        this.deltamonitor.startMonitoring();
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        this.values.resetQuick();
        this.deltamonitor.forEachRemVal(this.filler);
        for (int i = 0; i < this.values.size(); ++i) {
            proc.execute(this.transform(this.values.getQuick(i)));
        }
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        this.values.resetQuick();
        this.deltamonitor.forEachRemVal(this.filler);
        for (int i = 0; i < this.values.size(); ++i) {
            proc.execute(this.transform(this.values.getQuick(i)));
        }
    }

    @Override
    public int sizeApproximation() {
        return this.deltamonitor.sizeApproximation();
    }

    protected abstract int transform(int var1);

    private class Filler
    implements SafeIntProcedure {
        private Filler() {
        }

        @Override
        public void execute(int i) {
            ViewDeltaMonitor.this.values.add(i);
        }
    }
}

