/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import lombok.NonNull;

public interface Range<E extends Comparable<? super E>> {
    @NonNull
    public E start();

    @NonNull
    public E end();

    default public boolean contains(@NonNull E element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.start().compareTo(element) <= 0 && element.compareTo(this.end()) < 0;
    }

    public static <E extends Comparable<? super E>> Range<E> of(final E start, final E end) {
        return new Range<E>(){

            @Override
            public E start() {
                return start;
            }

            @Override
            public E end() {
                return end;
            }
        };
    }
}

