/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdplus.toolkit.base.api.util.Id;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TreeOfIds {
    private final TreeNode root;
    private final Map<Id, TreeNode> nodes;

    public TreeOfIds(@NonNull List<Id> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.root = new TreeNode(null);
        this.nodes = new HashMap<Id, TreeNode>();
        for (Id id : items) {
            Id[] path = id.path();
            TreeNode prev = null;
            for (int i = 0; i < path.length; ++i) {
                TreeNode cur = this.nodes.get(path[i]);
                if (cur == null) {
                    cur = new TreeNode(path[i]);
                    if (prev == null) {
                        this.root.children.add(cur);
                    } else {
                        prev.children.add(cur);
                    }
                    this.nodes.put(path[i], cur);
                }
                prev = cur;
            }
        }
    }

    public boolean contains(Id id) {
        return this.nodes.containsKey(id);
    }

    @NonNull
    public Id[] roots() {
        return this.root.getChildrenIds();
    }

    @NonNull
    public Id[] children(@Nullable Id cur) {
        if (cur == null) {
            return this.roots();
        }
        TreeNode croot = this.nodes.get(cur);
        if (croot == null) {
            return new Id[0];
        }
        return croot.getChildrenIds();
    }

    private static final class TreeNode {
        public final Id id;
        public final List<TreeNode> children;

        TreeNode(@Nullable Id id) {
            this.id = id;
            this.children = new ArrayList<TreeNode>();
        }

        Id[] getChildrenIds() {
            Id[] result = new Id[this.children.size()];
            int i = 0;
            for (TreeNode node : this.children) {
                result[i++] = node.id;
            }
            return result;
        }
    }
}

