/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.regarima;

import java.util.Arrays;
import jdplus.sa.base.core.regarima.ModelBuilder;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.AICcComparator;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IModelComparator;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import lombok.Generated;

public class EasterDetectionModule
implements IRegressionModule {
    public static final String AED = "automatic easter selection";
    public static final String E_SEL = "selected easter variable: ";
    public static final String NOE_SEL = "no selected easter variable";
    public static final String AED_FAILED = "automatic easter selection failed";
    private final IModelComparator comparator;
    private final IEasterVariable[] easters;
    private final double eps;

    private String[] names(IEasterVariable[] easters) {
        return (String[])Arrays.stream(easters).map(var -> var.description(null)).toArray(String[]::new);
    }

    public static Builder builder() {
        return new Builder();
    }

    public EasterDetectionModule(Builder builder) {
        this.comparator = builder.comparator;
        this.easters = builder.easters;
        this.eps = builder.eps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult test(RegSarimaModelling context) {
        ProcessingLog log = context.getLog();
        log.push(AED);
        try {
            ModelDescription description = context.getDescription();
            if (description.getAnnualFrequency() <= 2) {
                log.info(NOE_SEL);
                ProcessingResult processingResult = ProcessingResult.Unprocessed;
                return processingResult;
            }
            int n = this.easters.length;
            int icur = -1;
            ModelDescription[] desc = new ModelDescription[n];
            RegArimaEstimation[] est = new RegArimaEstimation[n];
            IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.eps);
            ModelDescription refdesc = ModelDescription.copyOf((ModelDescription)description);
            refdesc.remove("easter");
            RegArimaEstimation refest = refdesc.estimate(processor);
            for (int i = 0; i < n; ++i) {
                ModelDescription curDesc = ModelDescription.copyOf((ModelDescription)refdesc);
                curDesc.addVariable(Variable.variable((String)"easter", (ITsVariable)this.easters[i], ModelBuilder.calendarAMI));
                desc[i] = curDesc;
                est[i] = curDesc.estimate(processor);
            }
            int imodel = this.comparator.compare(refest, est);
            if (imodel < 0) {
                context.set(refdesc, refest);
            } else {
                context.set(desc[imodel], est[imodel]);
            }
            Info info = new Info(this.names(this.easters), (LikelihoodStatistics[])Arrays.stream(est).map(e -> e == null ? null : e.statistics()).toArray(LikelihoodStatistics[]::new), refest.statistics(), imodel);
            String msg = imodel < 0 ? NOE_SEL : E_SEL + this.easters[imodel].description(null);
            log.info(msg, (Object)info);
            ProcessingResult processingResult = icur == imodel ? ProcessingResult.Unchanged : ProcessingResult.Changed;
            return processingResult;
        }
        catch (RuntimeException ex) {
            context.getLog().remark(AED_FAILED);
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    public static class Builder {
        private IEasterVariable[] easters;
        private IModelComparator comparator = new AICcComparator(0.0);
        private double eps = 1.0E-5;

        public Builder easters(IEasterVariable[] easters) {
            this.easters = easters;
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder modelComparator(IModelComparator comparator) {
            this.comparator = comparator;
            return this;
        }

        public EasterDetectionModule build() {
            return new EasterDetectionModule(this);
        }
    }

    public static class Info {
        final String[] names;
        final LikelihoodStatistics[] ll;
        final LikelihoodStatistics ll0;
        final int best;

        @Generated
        public String[] getNames() {
            return this.names;
        }

        @Generated
        public LikelihoodStatistics[] getLl() {
            return this.ll;
        }

        @Generated
        public LikelihoodStatistics getLl0() {
            return this.ll0;
        }

        @Generated
        public int getBest() {
            return this.best;
        }

        @Generated
        public Info(String[] names, LikelihoodStatistics[] ll, LikelihoodStatistics ll0, int best) {
            this.names = names;
            this.ll = ll;
            this.ll0 = ll0;
            this.best = best;
        }
    }
}

