/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class EasterSpec
implements Validatable<EasterSpec> {
    public static final int DEF_IDUR = 6;
    public static final boolean DEF_JULIAN = false;
    private final boolean test;
    private final int duration;
    private final Type type;
    private final boolean julian;
    private final Parameter coefficient;
    public static final EasterSpec DEFAULT_UNUSED = (EasterSpec)EasterSpec.builder().build();

    public static Builder builder() {
        return new Builder().test(false).julian(false).type(Type.Unused).duration(6);
    }

    public EasterSpec validate() throws IllegalArgumentException {
        if (this.duration <= 0 || this.duration > 15) {
            throw new IllegalArgumentException("Duration should be inside [1, 15]");
        }
        if (this.test && Parameter.isFixed((Parameter)this.coefficient)) {
            throw new IllegalArgumentException("Fixed coefficient should not be used with testing");
        }
        return this;
    }

    public boolean isUsed() {
        return this.type != Type.Unused;
    }

    public boolean isDefined() {
        return this.type != Type.Unused && !this.test;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_UNUSED);
    }

    public static EasterSpec none() {
        return DEFAULT_UNUSED;
    }

    public boolean hasFixedCoefficient() {
        return this.coefficient != null && this.coefficient.isFixed();
    }

    @Generated
    EasterSpec(boolean test, int duration, Type type, boolean julian, Parameter coefficient) {
        this.test = test;
        this.duration = duration;
        this.type = type;
        this.julian = julian;
        this.coefficient = coefficient;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().test(this.test).duration(this.duration).type(this.type).julian(this.julian).coefficient(this.coefficient);
    }

    @Generated
    public boolean isTest() {
        return this.test;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public boolean isJulian() {
        return this.julian;
    }

    @Generated
    public Parameter getCoefficient() {
        return this.coefficient;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasterSpec)) {
            return false;
        }
        EasterSpec other = (EasterSpec)o;
        if (this.isTest() != other.isTest()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isJulian() != other.isJulian()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Parameter this$coefficient = this.getCoefficient();
        Parameter other$coefficient = other.getCoefficient();
        return !(this$coefficient == null ? other$coefficient != null : !this$coefficient.equals(other$coefficient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTest() ? 79 : 97);
        result = result * 59 + this.getDuration();
        result = result * 59 + (this.isJulian() ? 79 : 97);
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Parameter $coefficient = this.getCoefficient();
        result = result * 59 + ($coefficient == null ? 43 : $coefficient.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "EasterSpec(test=" + this.isTest() + ", duration=" + this.getDuration() + ", type=" + String.valueOf((Object)this.getType()) + ", julian=" + this.isJulian() + ", coefficient=" + String.valueOf(this.getCoefficient()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<EasterSpec> {
        @Generated
        private boolean test;
        @Generated
        private int duration;
        @Generated
        private Type type;
        @Generated
        private boolean julian;
        @Generated
        private Parameter coefficient;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder test(boolean test) {
            this.test = test;
            return this;
        }

        @Generated
        public @NonNull Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Generated
        public @NonNull Builder type(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public @NonNull Builder julian(boolean julian) {
            this.julian = julian;
            return this;
        }

        @Generated
        public @NonNull Builder coefficient(Parameter coefficient) {
            this.coefficient = coefficient;
            return this;
        }

        @Generated
        public @NonNull EasterSpec buildWithoutValidation() {
            return new EasterSpec(this.test, this.duration, this.type, this.julian, this.coefficient);
        }

        @Generated
        public @NonNull String toString() {
            return "EasterSpec.Builder(test=" + this.test + ", duration=" + this.duration + ", type=" + String.valueOf((Object)this.type) + ", julian=" + this.julian + ", coefficient=" + String.valueOf(this.coefficient) + ")";
        }
    }

    public static enum Type {
        Unused,
        Standard,
        IncludeEaster,
        IncludeEasterMonday;


        public boolean containsEaster() {
            return this == IncludeEaster || this == IncludeEasterMonday;
        }

        public boolean containsEasterMonday() {
            return this == IncludeEasterMonday;
        }
    }
}

